#pragma once

#include <vector>



namespace lib_geo
{
namespace ply
{


class VertPropIdx
{
public:
	void Clear(void);
	int GetMaxPropIdx(void) const;

public:
	int vX;
	int vY;
	int vZ;
	int nX;
	int nY;
	int nZ;
	int cR;
	int cG;
	int cB;
	int cA;
};


class PlyHeader
{
public:
	PlyHeader(void);
	void Clear(void);

	int GetMaxPropIdx(void) const;
	bool HasNormal(void) const;
	bool HasCol(void) const;
	int NumColorElems(void) const;

public:
	std::string m_FormatType;

	size_t m_NumVerts;
	VertPropIdx m_VPI;

	size_t m_NumFaces;

	std::vector<std::string> m_Comments;
};


}
}
