#pragma once

#include <vector>



namespace lib_geo
{


class FaceIdxRange
{
public:
	FaceIdxRange(void) :
		m_Offset(0),
		m_Count(0)
	{
	}

	void Reset(void)
	{
		m_Offset = 0;
		m_Count = 0;
	}

	void Add(std::vector<int>& buf, int idx)
	{
		if (m_Count == 0)
			m_Offset = buf.size();

		m_Count++;
		buf.push_back(idx);
	}

	bool IsEmpty(void) const
	{
		return (m_Count == 0);
	}

	void ToVec(const std::vector<int>& buf, std::vector<int>& dst) const
	{
		dst.resize(m_Count);
		for (size_t i = 0; i < m_Count; ++i)
		{
			dst[i] = buf[i + m_Offset];
		}
	}

public:
	size_t m_Offset;
	size_t m_Count;
};


class ObjFaceBuf
{
public:
	void Swap(ObjFaceBuf& buf)
	{
		buf.m_FaceIdxV.swap(m_FaceIdxV);
		buf.m_FaceIdxN.swap(m_FaceIdxN);
		buf.m_FaceIdxUV.swap(m_FaceIdxUV);
	}

	void Clear(void)
	{
		m_FaceIdxV.clear();
		m_FaceIdxN.clear();
		m_FaceIdxUV.clear();
	}

public:
	std::vector<int> m_FaceIdxV;
	std::vector<int> m_FaceIdxN;
	std::vector<int> m_FaceIdxUV;
};


//! Obj`̃|S
class ObjFace
{
public:
	ObjFace(void)
		: m_MatNameIdx(-1)
		, m_GroupIdx(0)
	{}

	void Clear(void)
	{
		m_IdxV.Reset();
		m_IdxN.Reset();
		m_IdxUV.Reset();

		m_MatNameIdx = -1;
		m_GroupIdx = 0;
	}

	bool HasValidMatIdx(void) const
	{
		return m_MatNameIdx != -1;
	}


public:
	FaceIdxRange m_IdxV;
	FaceIdxRange m_IdxN;
	FaceIdxRange m_IdxUV;

	int m_MatNameIdx;
	int m_GroupIdx;
};


class ObjPolyline
{
public:
	ObjPolyline(void)
	{
		m_GroupIdx = 0;
	}

	void Clear(void)
	{
		m_IdxV.clear();
		m_GroupIdx = 0;
	}

public:
	std::vector<int> m_IdxV;
	int m_GroupIdx;
};


}
