#pragma once

#include <C2/gl/GlewFramebuffer.h>
#include <C2/gl/GlTextureObject.h>


class FBORenderBuf
{
public:
	FBORenderBuf(void)
	{
		m_IsInitialized = false;

		m_BufWidth  = 0;
		m_BufHeight = 0;
	}

	void RebuildIfResized(int w, int h);

	void ReleaseBuf(void);

	void InitializeOnce(int w, int h);

	void Initialize(int w, int h);

	int GetWidth(void) const { return m_BufWidth; }
	int GetHeight(void) const { return m_BufHeight; }

private:
	void InitializeDethBuffer(void);
	void InitializeColorBuffer(void);
	void AssignFBOToFrameBufObjects(void);

private:
	void operator=(const FBORenderBuf&) {}


public:
	lib_gl::GlFramebuffer m_Fbo;
	lib_gl::GlTextureObject m_ColorBuf;
	lib_gl::GlTextureObject m_DepthBuf;

protected:
	int m_BufWidth;
	int m_BufHeight;

	bool m_IsInitialized;
};
