#pragma once

#include <iostream>
#include <vector>
#include <string>

#include <C2/lm/vector3.h>


namespace lib_geo
{


class BaseMesh;


class StlFace
{
public:
	lm::vec3f  m_Normal;
	lm::vec3f  m_Verts[3];
};


class StlMesh
{
public:
	static const int MSG_LENGTH = 80;

public:
	StlMesh(void);
	void Clear(void);

	bool Load( std::istream& ist );
	bool Load( const std::string& i_Filename );
	bool Save( std::ostream& ost ) const;
	bool Save( const std::string& i_Filename ) const;

	bool ConvertToBaseMesh( BaseMesh& o_mesh ) const;

	bool ExistZeroLengthNormal(void) const;

private:
	void ClearMessage(void);

	bool LoadBinary(std::istream& in);
	bool LoadText(std::istream& in);

	bool IsExistValidAsciiHeader(std::istream& in);

	bool IsBinarySTL(size_t fileSize);

public:
	char m_Message[MSG_LENGTH];
	std::vector<StlFace> m_Faces;
};


}
