#pragma once

#include "math_util.h"

#include <numeric>
#include <limits>


namespace lm
{


//! axis aligned rect
template<typename T>
class range1
{
public:
	range1(void)
	{
		// Ȃ̏ꍇ min > max ƂȂ悤ɐݒ肷
		T v_max = (std::numeric_limits<T>::max)();
		T v_min = -v_max;

		p0 = v_max;
		p1 = v_min;
	}

	range1( const T& x0 , const T& x1 )
		: p0( x0 ) , p1( x1 )
	{}

	void clear(void);

	//! LȔ͈͂ݒ肳Ă邩(ʐς0ȏォ)m߂
	bool is_valid(void) const;

	//! ͈͂L
	void expand( const T& v );
	void expand( const range1<T>& i_range );

	//! w肵W܂ޏꍇtrue
	bool contains( const T& v ) const;
	//! w肵range͈͂true
	bool intersect( const range1<T>& i_range ) const;

	T length(void) const { return p1 - p0; }

	T center(void) const { return ( p1 + p0 ) / T(2); }

	T&       min_val(void)       { return p0; }
	T&       max_val(void)       { return p1; }
	const T& min_val(void) const { return p0; }
	const T& max_val(void) const { return p1; }

protected:
	// p0 <= p1
	T p0 , p1;
};


typedef range1<float>  range1f;
typedef range1<double> range1d;



// ----------------------------------------------------------------------------------------------------------------------------------------------------------------


template<typename T> inline
void range1<T>::clear(void)
{
	T v_max = (std::numeric_limits<T>::max)();
	T v_min = -v_max;

	p0 = v_max;
	p1 = v_min;
}

	//! LȔ͈͂ݒ肳Ă邩(ʐς0ȏォ)m߂
template<typename T> inline
bool range1<T>::is_valid(void) const
{
	if( p0 > p1 ) return false;
	return true;
}

template<typename T> inline
void range1<T>::expand( const T& v )
{
	p0 = (std::min)( v , p0 );
	p1 = (std::max)( v , p1 );
}

template<typename T> inline
void range1<T>::expand( const range1<T>& i_range )
{
	if( !i_range.is_valid() )
		return;

	expand( i_range.min_point() );
	expand( i_range.max_point() );
}

template<typename T> inline
bool range1<T>::contains( const T& v ) const
{
	if( v < p0 || p1 < v ) return false;
	return true;
}

template<typename T> inline
bool range1<T>::intersect( const range1<T>& i_range ) const
{
	if( this->max_val() < i_range.min_val() || this->min_val() > i_range.max_val() ) return false;
	return true;
}


}
