#pragma once

#include "GlInclude.h"


namespace lib_gl
{

//! Pvf̃fBXvCXg
class GlDisplayList
{
public:
	GlDisplayList(void);
	~GlDisplayList(void);

	//! fBXvCXg̎擾AJ
	bool GenerateList(void);
	void ReleaseList(void);

	//! fBXvCXgIDĂꍇtrueԂ
	bool IsEnable(void) const;

	//! _O̊Jn
	//! @param ListMode - GL_COMPILE_AND_EXECUTE or GL_COMPILE
	void BeginList( GLenum ListMode = GL_COMPILE );

	void BeginCompile(void);
	void BeginCompieAndExecute(void);

	//! Xg̓o^I
	void EndList(void);

	//! fBXvCXgĂяo
	void CallList(void);

private:
	GlDisplayList(const GlDisplayList&) {}
	void operator=(const GlDisplayList&) {}

protected:
	GLuint m_ListID; //!< fBXvCXgID
};



// ------------------------------------------------------------------------------------------
// GlDisplayList implements

inline GlDisplayList::GlDisplayList(void)
{
	m_ListID = 0;
}

inline GlDisplayList::~GlDisplayList(void)
{
	if( m_ListID != 0 )
		glDeleteLists( m_ListID , 1 );
}

inline bool GlDisplayList::GenerateList(void)
{
	m_ListID = glGenLists( 1 );
	
	return ( m_ListID != 0 );
}

inline void GlDisplayList::ReleaseList(void)
{
	if( m_ListID != 0 )
	{
		glDeleteLists( m_ListID , 1 );
		m_ListID = 0;
	}
}

inline bool GlDisplayList::IsEnable(void) const
{
	return ( m_ListID != 0 );
}

inline void GlDisplayList::BeginList( GLenum ListMode )
{
	glNewList( m_ListID , ListMode );
}

inline void GlDisplayList::BeginCompile(void)
{
	BeginList(GL_COMPILE);
}

inline void GlDisplayList::BeginCompieAndExecute(void)
{
	BeginList(GL_COMPILE_AND_EXECUTE);
}

inline void GlDisplayList::EndList(void)
{
	glEndList();
}

inline void GlDisplayList::CallList(void)
{
	glCallList( m_ListID );
}


}
