/*
 * Funambol is a mobile platform developed by Funambol, Inc.
 * Copyright (C) 2011 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT  OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

package com.funambol.framework.core;

/**
 * This is a base class for "command" classes
 *
 *
 *
 * @version $Id: AbstractCommand.java,v 1.3 2006/08/07 21:05:28 nichele Exp $
 */
public abstract class AbstractCommand
implements java.io.Serializable {

    // ---------------------------------------------------------- Protected data
    protected CmdID   cmdID     ;
    protected Boolean noResp    ;
    protected Meta    meta      ;
    protected Cred    credential;

    // ------------------------------------------------------------ Constructors

    /** For serialization purposes */
    protected AbstractCommand() {}

    /**
     * Create a new AbstractCommand object with the given commandIdentifier
     * and noResponse
     *
     * @param cmdID the command identifier - NOT NULL
     * @param noResp true if the command doesn't require a response
     *
     */
    public AbstractCommand(final CmdID cmdID, final boolean noResp) {
        setCmdID(cmdID);
        this.noResp  = (noResp) ? Boolean.valueOf(noResp) : null;
    }

    /**
     * Create a new AbstractCommand object with the given commandIdentifier
     *
     * @param cmdID the command identifier - NOT NULL
     *
     */
    public AbstractCommand(final CmdID cmdID) {
        this(cmdID, false);
    }

    // ---------------------------------------------------------- Public methods
    /**
     * Get CommandIdentifier property
     *
     * @return the command identifier - NOT NULL
     */
    public CmdID getCmdID() {
        return this.cmdID;
    }

    /**
     * Sets the CommandIdentifier property
     *
     * @param cmdID the command identifier
     *
     */
    public void setCmdID(CmdID cmdID) {
        if (cmdID == null) {
            throw new IllegalArgumentException("cmdID cannot be null");
        }
        this.cmdID = cmdID;
    }

    /**
     * Gets noResp property
     *
     * @return true if the command doesn't require a response, false otherwise
     */
    public boolean isNoResp() {
        return (noResp != null);
    }

    public Boolean getNoResp() {
        if (!noResp.booleanValue()) {
            return null;
        }
        return noResp;
    }

    /**
     * Sets noResp true if no response is required
     *
     * @param noResp is true if no response is required
     *
     */
    public void setNoResp(Boolean noResp) {
        this.noResp = (noResp.booleanValue()) ? noResp : null;
    }

    /**
     * Gets Credential object
     *
     * @return the Credential object
     */
    public Cred getCred() {
        return credential;
    }

    /**
     * Sets authentication credential
     *
     * @param cred the authentication credential
     *
     */
    public void setCred(Cred cred) {
        this.credential = cred;
    }

    /**
     * Gets an Meta object
     *
     * @return an Meta object
     */
    public Meta getMeta() {
        return meta;
    }

    /**
     * Sets Meta object
     *
     * @param meta the meta object
     *
     */
    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    /**
     * Get name property
     *
     * @return the name of the command
     */
    public abstract String getName();
}
