/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.InstructionHandle;
import org.jibx.binding.classes.BranchTarget;
import org.jibx.binding.classes.MethodBuilder;

public class BranchWrapper {
    private static boolean s_trackSource;
    private static boolean s_errorOverride;
    private final BranchHandle m_branchHandle;
    private final String[] m_stackTypes;
    private final Object m_sourceObject;
    private final Throwable m_sourceTrace;

    BranchWrapper(BranchHandle hand, String[] types, Object src) {
        this.m_branchHandle = hand;
        this.m_stackTypes = types;
        this.m_sourceObject = src;
        this.m_sourceTrace = s_trackSource ? new Throwable() : null;
    }

    String[] getStackState() {
        return this.m_stackTypes;
    }

    private String describeStack(String[] types) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            buff.append("  ");
            buff.append(i);
            buff.append(": ");
            buff.append(types[i]);
            buff.append('\n');
        }
        return buff.toString();
    }

    private String buildReport(String text, String[] types, MethodBuilder mb) {
        if (this.m_sourceTrace != null) {
            System.err.println("Backtrack for branch source:");
            this.m_sourceTrace.printStackTrace(System.err);
        }
        StringBuffer buff = new StringBuffer(text);
        buff.append("\n in method ");
        buff.append(mb.getClassFile().getName());
        buff.append('.');
        buff.append(mb.getName());
        buff.append("\n generated by ");
        buff.append(this.m_sourceObject.toString());
        buff.append("\n from stack:\n");
        buff.append(this.describeStack(this.m_stackTypes));
        buff.append(" to stack:\n");
        buff.append(this.describeStack(types));
        return buff.toString();
    }

    void setTarget(InstructionHandle hand, String[] types, MethodBuilder mb) {
        if (types.length == this.m_stackTypes.length) {
            boolean match = true;
            for (int i = 0; i < types.length; ++i) {
                String stype = this.m_stackTypes[i];
                if (types[i].equals(stype) || "<null>".equals(types[i]) || "<null>".equals(stype)) continue;
                if (this.m_sourceTrace != null) {
                    System.err.println("Backtrack for branch source:");
                    this.m_sourceTrace.printStackTrace(System.err);
                }
                String text = this.buildReport("Stack value type mismatch on branch", types, mb);
                if (s_errorOverride) {
                    new Throwable(text).printStackTrace(System.err);
                    continue;
                }
                throw new IllegalStateException(text);
            }
        } else {
            String text = this.buildReport("Stack size mismatch on branch", types, mb);
            if (s_errorOverride) {
                new Throwable(text).printStackTrace(System.err);
            } else {
                throw new IllegalStateException(text);
            }
        }
        this.m_branchHandle.setTarget(hand);
    }

    public void setTarget(BranchTarget target, MethodBuilder mb) {
        this.setTarget(target.getInstruction(), target.getStack(), mb);
    }

    public static void setTracking(boolean track) {
        s_trackSource = track;
    }

    public static void setErrorOverride(boolean over) {
        s_errorOverride = over;
    }
}

