/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcherTest
implements RequestHandler {
    Channel channel;
    MessageDispatcher disp;
    RspList rsp_list;
    String props = "UDP:PING:FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:QUEUE";

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.disp = new MessageDispatcher(this.channel, null, null, this);
        this.channel.connect("MessageDispatcherTestGroup");
        for (int i = 0; i < 10; ++i) {
            Util.sleep(1000L);
            System.out.println("Casting message #" + i);
            this.rsp_list = this.disp.castMessage(null, new Message(null, null, new String("Number #" + i).getBytes()), 2, 0L);
            System.out.println("Responses:\n" + this.rsp_list);
        }
        System.out.println("** Disconnecting channel");
        this.channel.disconnect();
        System.out.println("** Disconnecting channel -- done");
        System.out.println("** Closing channel");
        this.channel.close();
        System.out.println("** Closing channel -- done");
        System.out.println("** disp.stop()");
        this.disp.stop();
        System.out.println("** disp.stop() -- done");
    }

    public Object handle(Message msg) {
        System.out.println("handle(): " + msg);
        return new String("Success !");
    }

    public static void main(String[] args) {
        try {
            new MessageDispatcherTest().start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

