/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.HammerSender;

public class HammerListener
implements ChannelListener,
MembershipListener {
    private static JChannel channel = null;
    private static RpcDispatcher disp;
    private static int SEND_COUNT;
    private static int counter;
    private static long startTime;

    public void channelConnected(Channel ch) {
    }

    public void channelDisconnected(Channel ch) {
    }

    public void channelClosed(Channel ch) {
    }

    public void channelShunned() {
    }

    public void channelReconnected(Address addr) {
    }

    private static void initCommChannel() {
        String props = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32;ucast_recv_buf_size=16000;ucast_send_buf_size=16000;mcast_send_buf_size=32000;mcast_recv_buf_size=64000;loopback=true):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=10000):pbcast.NAKACK(gc_lag=50;retransmit_timeout=1000,1500,2000,3000;max_xmit_size=8192):UNICAST(timeout=1000,1500,2000,3000):FLOW_CONTROL(window_size=1000;fwd_mrgn=200;rttweight=0.125;reduction=0.75;expansion=1.25):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
        try {
            channel = new JChannel(props);
            HammerListener listener = new HammerListener();
            disp = new RpcDispatcher((Channel)channel, null, (MembershipListener)listener, (Object)listener);
            channel.connect("BOSGroup");
        }
        catch (ChannelException ce) {
            System.err.println("Channel Error" + ce);
        }
    }

    public static int printnum(Integer number) throws Exception {
        if (++counter >= SEND_COUNT) {
            long endTime = System.currentTimeMillis();
            System.out.println("Messages received " + counter);
            System.out.println("Messages succesfully trasmitted in " + (endTime - startTime));
            System.exit(0);
        }
        return number * 2;
    }

    public void viewAccepted(View new_view) {
        System.out.println("Accepted view (" + new_view.size() + new_view.getMembers() + ")");
    }

    public void suspect(Address suspected_mbr) {
        System.out.println("-- suspected " + suspected_mbr);
    }

    public void block() {
    }

    public HammerListener() {
        System.out.println("HammerListener loaded");
    }

    public static void main(String[] args) {
        startTime = System.currentTimeMillis();
        System.out.println("startTime " + startTime);
        HammerSender sender = new HammerSender();
        for (int i = 0; i < SEND_COUNT; ++i) {
            HammerSender.executeDistributedCommand("not used");
        }
    }

    protected void finalizer() {
        channel.disconnect();
        channel.close();
    }

    static {
        SEND_COUNT = 100000;
        counter = 0;
        startTime = 0L;
        HammerListener.initCommChannel();
    }
}

