/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.log.Trace;
import org.jgroups.stack.GossipData;

public class GossipServer {
    Hashtable groups = new Hashtable();
    int port = 7500;
    ServerSocket srv_sock = null;
    long EXPIRY_TIME = 30000L;
    CacheCleaner cache_cleaner = null;
    Timer timer = new Timer(true);
    InetAddress bind_address = null;

    public GossipServer(int port) throws Exception {
        this.port = port;
        this.init();
    }

    public GossipServer(int port, long expiry_time) throws Exception {
        this.port = port;
        this.EXPIRY_TIME = expiry_time;
        this.init();
    }

    public GossipServer(int port, long expiry_time, InetAddress bind_address) throws Exception {
        this.port = port;
        this.bind_address = bind_address;
        this.EXPIRY_TIME = expiry_time;
        this.init();
    }

    public void run() {
        ObjectOutputStream output = null;
        while (true) {
            try {
                while (true) {
                    Socket sock = this.srv_sock.accept();
                    if (Trace.trace) {
                        Trace.info("GossipServer.run()", "accepted connection from " + sock.getInetAddress() + ":" + sock.getPort());
                    }
                    sock.setSoLinger(true, 500);
                    ObjectInputStream input = new ObjectInputStream(sock.getInputStream());
                    GossipData gossip_req = (GossipData)input.readObject();
                    GossipData gossip_rsp = this.processGossip(gossip_req);
                    if (gossip_rsp != null) {
                        output = new ObjectOutputStream(sock.getOutputStream());
                        output.writeObject(gossip_rsp);
                        output.flush();
                        output.close();
                    }
                    input.close();
                    sock.close();
                }
            }
            catch (Exception ex) {
                Trace.error("GossipServer.run()", "exception=" + ex);
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    void init() throws Exception {
        if (this.bind_address == null) {
            this.srv_sock = new ServerSocket(this.port, 20);
            this.bind_address = this.srv_sock.getInetAddress();
        } else {
            this.srv_sock = new ServerSocket(this.port, 20, this.bind_address);
        }
        if (Trace.trace) {
            Trace.info("GossipServe.init()", "GossipServer was created at " + new Date());
            Trace.info("GossipServe.init()", "Listening on port " + this.port + " bound on address " + this.bind_address);
        }
        this.cache_cleaner = new CacheCleaner();
        this.timer.schedule((TimerTask)this.cache_cleaner, this.EXPIRY_TIME, this.EXPIRY_TIME);
    }

    GossipData processGossip(GossipData gossip) {
        if (gossip == null) {
            return null;
        }
        if (Trace.trace) {
            Trace.info("GossipServer.processGossip()", gossip.toString());
        }
        switch (gossip.getType()) {
            case 1: {
                String group = gossip.getGroup();
                Address mbr = gossip.getMbr();
                if (group == null || mbr == null) {
                    Trace.error("GossipServer.processGossip()", "group or member is null, cannot register member");
                    return null;
                }
                return this.processRegisterRequest(group, mbr);
            }
            case 2: {
                String group = gossip.getGroup();
                if (group == null) {
                    Trace.error("GossipServer.processGossip()", "group is null, cannot get membership");
                    return null;
                }
                return this.processGetRequest(group);
            }
            case 3: {
                Trace.warn("GossipServer.processGossip()", "received a GET_RSP. Should not be received by server");
                return null;
            }
        }
        Trace.warn("GossipServer.processGossip()", "received unkown gossip request (gossip=" + gossip + ")");
        return null;
    }

    GossipData processRegisterRequest(String group, Address mbr) {
        this.addMember(group, mbr);
        return null;
    }

    GossipData processGetRequest(String group) {
        GossipData ret = null;
        Vector mbrs = this.getMembers(group);
        ret = new GossipData(3, group, null, mbrs);
        if (Trace.trace) {
            Trace.info("GossipServer.processGetRequest()", "members are " + mbrs + ", gossip_rsp=" + ret);
        }
        return ret;
    }

    void addMember(String group, Address mbr) {
        Vector<Entry> mbrs = (Vector<Entry>)this.groups.get(group);
        if (mbrs == null) {
            mbrs = new Vector<Entry>();
            mbrs.addElement(new Entry(mbr));
            this.groups.put(group, mbrs);
            if (Trace.trace) {
                Trace.info("GossipServer.addMember()", "added " + mbr + " to " + group + " (new group)");
            }
        } else {
            Entry entry = this.findEntry(mbrs, mbr);
            if (entry == null) {
                entry = new Entry(mbr);
                mbrs.addElement(entry);
                if (Trace.trace) {
                    Trace.info("GossipServer.addMember()", "added " + mbr + " to " + group);
                }
            } else {
                entry.update();
                if (Trace.trace) {
                    Trace.info("GossipServer.addMember()", "updated entry " + entry);
                }
            }
        }
    }

    Vector getMembers(String group) {
        Vector<Address> ret = null;
        Vector mbrs = (Vector)this.groups.get(group);
        if (mbrs == null) {
            return null;
        }
        ret = new Vector<Address>();
        for (int i = 0; i < mbrs.size(); ++i) {
            ret.addElement(((Entry)mbrs.elementAt((int)i)).mbr);
        }
        return ret;
    }

    Entry findEntry(Vector mbrs, Address mbr) {
        Entry entry = null;
        for (int i = 0; i < mbrs.size(); ++i) {
            entry = (Entry)mbrs.elementAt(i);
            if (entry.mbr == null || !entry.mbr.equals(mbr)) continue;
            return entry;
        }
        return null;
    }

    void sweep() {
        long current_time = System.currentTimeMillis();
        int num_entries_removed = 0;
        String key = null;
        Enumeration e = this.groups.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            Vector val = (Vector)this.groups.get(key);
            if (val == null) continue;
            ListIterator it = val.listIterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                long diff = current_time - entry.timestamp;
                if (entry.timestamp + this.EXPIRY_TIME >= current_time) continue;
                it.remove();
                if (Trace.trace) {
                    Trace.info("GossipServer.sweep()", "removed member " + entry + " from group " + key + "(" + diff + " msecs old)");
                }
                ++num_entries_removed;
            }
        }
        if (Trace.trace && num_entries_removed > 0) {
            Trace.info("GossipServer.sweep()", "done (removed " + num_entries_removed + " entries)");
        }
    }

    public static void main(String[] args) throws UnknownHostException {
        int port = 7500;
        long expiry_time = 30000L;
        GossipServer gossip_server = null;
        InetAddress address = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                System.out.println("GossipServer [-port <port>] [-expiry <msecs>] [-bindaddress <address>]");
                return;
            }
            if (arg.equals("-port")) {
                port = new Integer(args[++i]);
                continue;
            }
            if (arg.equals("-expiry")) {
                expiry_time = new Long(args[++i]);
                continue;
            }
            if (arg.equals("-bindaddress")) {
                address = InetAddress.getByName(args[++i]);
                continue;
            }
            System.out.println("GossipServer [-port <port>] [-expiry <msecs>]");
            return;
        }
        try {
            Trace.init();
        }
        catch (Throwable ex) {
            System.err.println("GossipServer.main(): " + ex);
        }
        try {
            gossip_server = new GossipServer(port, expiry_time, address);
            gossip_server.run();
        }
        catch (Exception e) {
            System.err.println("GossipServer.main(): " + e);
        }
    }

    private class CacheCleaner
    extends TimerTask {
        private CacheCleaner() {
        }

        public void run() {
            GossipServer.this.sweep();
        }
    }

    private static class Entry {
        Address mbr = null;
        long timestamp = 0L;

        private Entry(Address mbr) {
            this.mbr = mbr;
            this.update();
        }

        void update() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            if (this.mbr != null && other != null && other instanceof Address) {
                return this.mbr.equals(other);
            }
            return false;
        }

        public String toString() {
            return "mbr=" + this.mbr;
        }
    }
}

