/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import org.jgroups.Message;
import org.jgroups.log.Trace;

public class AckReceiverWindow {
    long initial_seqno = 0L;
    long next_to_remove = 0L;
    HashMap msgs = new HashMap();

    public AckReceiverWindow(long initial_seqno) {
        this.initial_seqno = initial_seqno;
        this.next_to_remove = initial_seqno;
    }

    public void add(long seqno, Message msg) {
        if (seqno < this.next_to_remove) {
            if (Trace.trace) {
                Trace.warn("AckReceiverWindow.add()", "discarded msg with seqno=" + seqno + " (next msg to receive is " + this.next_to_remove + ")");
            }
            return;
        }
        this.msgs.put(new Long(seqno), msg);
    }

    public Message remove() {
        Message retval = (Message)this.msgs.remove(new Long(this.next_to_remove));
        if (retval != null) {
            ++this.next_to_remove;
        }
        return retval;
    }

    public void reset() {
        this.msgs.clear();
        this.next_to_remove = this.initial_seqno;
    }

    public String toString() {
        return this.msgs.keySet().toString();
    }

    public static void main(String[] args) {
        AckReceiverWindow win = new AckReceiverWindow(33L);
        Message m = new Message();
        win.add(37L, m);
        System.out.println(win);
        while (win.remove() != null) {
            System.out.println("Removed message, win is " + win);
        }
        win.add(35L, m);
        System.out.println(win);
        win.add(36L, m);
        System.out.println(win);
        while (win.remove() != null) {
            System.out.println("Removed message, win is " + win);
        }
        win.add(33L, m);
        System.out.println(win);
        win.add(34L, m);
        System.out.println(win);
        win.add(38L, m);
        System.out.println(win);
        while (win.remove() != null) {
            System.out.println("Removed message, win is " + win);
        }
        win.add(35L, m);
        System.out.println(win);
        win.add(332L, m);
        System.out.println(win);
    }
}

