/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class DistributedQueue
implements MessageListener,
MembershipListener,
Cloneable {
    static Logger logger = Logger.getLogger((String)(class$org$jgroups$blocks$DistributedQueue == null ? (class$org$jgroups$blocks$DistributedQueue = DistributedQueue.class$("org.jgroups.blocks.DistributedQueue")) : class$org$jgroups$blocks$DistributedQueue).getName());
    Object mutex = new Object();
    private transient boolean stopped = false;
    private LinkedList internalQueue;
    private transient Channel channel;
    private transient RpcDispatcher disp = null;
    private transient String groupname = null;
    private transient Vector notifs = new Vector();
    private transient Vector members = new Vector();
    private transient MethodCall add_method = null;
    private transient MethodCall addAtHead_method = null;
    private transient MethodCall addAll_method = null;
    private transient MethodCall reset_method = null;
    private transient MethodCall remove_method = null;
    private transient MethodCall getFirst_method = null;
    private transient MethodCall getLast_method = null;
    static /* synthetic */ Class class$org$jgroups$blocks$DistributedQueue;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;

    public DistributedQueue(String groupname, ChannelFactory factory, String properties, long state_timeout) {
        this.groupname = groupname;
        try {
            this.initMethods();
            this.internalQueue = new LinkedList();
            this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
            this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            this.disp.setDeadlockDetection(false);
            this.channel.setOpt(4, new Boolean(true));
            this.channel.connect(groupname);
            this.start(state_timeout);
        }
        catch (Exception e) {
            logger.error((Object)"DistributedQueue.DistributedQueue()", (Throwable)e);
        }
    }

    public DistributedQueue(JChannel channel) throws ChannelNotConnectedException, ChannelClosedException {
        this.groupname = channel.getChannelName();
        this.channel = channel;
        this.init();
    }

    protected void init() throws ChannelClosedException, ChannelNotConnectedException {
        this.initMethods();
        this.internalQueue = new LinkedList();
        this.channel.setOpt(4, new Boolean(true));
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setDeadlockDetection(false);
    }

    public void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        logger.debug((Object)("DistributedQueue.initState(" + this.groupname + "): starting state retrieval"));
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            logger.info((Object)("DistributedQueue.initState(" + this.groupname + "): state was retrieved successfully"));
        } else {
            logger.info((Object)("DistributedQueue.initState(" + this.groupname + "): state could not be retrieved (first member)"));
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        this.stopped = true;
    }

    public void add(Object value) {
        try {
            Object retval = null;
            this.add_method.setArg(0, value);
            RspList rsp = this.disp.callRemoteMethods(null, this.add_method, 2, 0L);
            Vector results = rsp.getResults();
            if (results.size() > 0) {
                retval = results.elementAt(0);
                if (logger.isDebugEnabled()) {
                    this.checkResult(rsp, retval);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to add value " + value), (Throwable)e);
        }
    }

    public void addAtHead(Object value) {
        try {
            this.addAtHead_method.setArg(0, value);
            this.disp.callRemoteMethods(null, this.addAtHead_method, 2, 0L);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to addAtHead value " + value), (Throwable)e);
        }
    }

    public void addAll(Collection values) {
        try {
            this.addAll_method.setArg(0, values);
            this.disp.callRemoteMethods(null, this.addAll_method, 2, 0L);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to addAll value: " + values), (Throwable)e);
        }
    }

    public Vector getContents() {
        Vector result = new Vector();
        boolean i = false;
        Iterator e = this.internalQueue.iterator();
        while (e.hasNext()) {
            result.add(e.next());
        }
        return result;
    }

    public int size() {
        return this.internalQueue.size();
    }

    public Object peek() {
        Object retval = null;
        try {
            retval = this.internalQueue.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return retval;
    }

    public void reset() {
        try {
            this.disp.callRemoteMethods(null, this.reset_method, 2, 0L);
        }
        catch (Exception e) {
            logger.error((Object)("DistributedQueue.reset(" + this.groupname + ")"), (Throwable)e);
        }
    }

    protected void checkResult(RspList rsp, Object retval) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Value updated from " + this.groupname + " :" + retval));
        }
        Vector results = rsp.getResults();
        for (int i = 0; i < results.size(); ++i) {
            Object data = results.elementAt(i);
            if (data.equals(retval)) continue;
            logger.error((Object)("Reference value differs from returned value " + retval + " != " + data));
        }
    }

    public Object remove() {
        RspList rsp;
        Vector results;
        Object retval = null;
        if (this.internalQueue.size() > 0 && (results = (rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L)).getResults()).size() > 0) {
            retval = results.elementAt(0);
            if (logger.isDebugEnabled()) {
                this.checkResult(rsp, retval);
            }
        }
        return retval;
    }

    public Object remove(long timeout) {
        Object retval;
        block9: {
            block8: {
                retval = null;
                if (this.internalQueue.size() <= 0) break block8;
                RspList rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L);
                Vector results = rsp.getResults();
                if (results.size() <= 0) break block9;
                retval = results.elementAt(0);
                if (!logger.isDebugEnabled()) break block9;
                this.checkResult(rsp, retval);
                break block9;
            }
            long t = System.currentTimeMillis();
            if (timeout == 0L) {
                while (retval == null) {
                    RspList rsp;
                    Vector results;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (this.stopped || (results = (rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L)).getResults()).size() <= 0) continue;
                    retval = results.elementAt(0);
                    if (!logger.isDebugEnabled()) continue;
                    this.checkResult(rsp, retval);
                }
            } else {
                long interval = timeout / 10L;
                while (System.currentTimeMillis() - t < timeout && retval == null) {
                    RspList rsp;
                    Vector results;
                    try {
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (this.stopped || (results = (rsp = this.disp.callRemoteMethods(null, this.remove_method, 2, 0L)).getResults()).size() <= 0) continue;
                    retval = results.elementAt(0);
                    if (!logger.isDebugEnabled()) continue;
                    this.checkResult(rsp, retval);
                }
            }
        }
        return retval;
    }

    public String toString() {
        return this.internalQueue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.groupname + "@" + this.getLocalAddress() + " _add(" + value + ")"));
        }
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.add(value);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addAtHead(Object value) {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.addFirst(value);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value);
        }
    }

    public void _reset() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.groupname + "@" + this.getLocalAddress() + " _reset()"));
        }
        this._private_reset();
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _private_reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.clear();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _remove() {
        Object retval = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                retval = this.internalQueue.removeFirst();
                this.mutex.notifyAll();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.groupname + "@" + this.getLocalAddress() + "_remove(" + retval + ")"));
            }
            for (int i = 0; i < this.notifs.size(); ++i) {
                ((Notification)this.notifs.elementAt(i)).entryRemoved(retval);
            }
        }
        catch (NoSuchElementException e) {
            logger.debug((Object)(this.groupname + "@" + this.getLocalAddress() + "_remove(): nothing to remove"));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addAll(Collection c) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.groupname + "@" + this.getLocalAddress() + " _addAll(" + c + ")"));
        }
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.addAll(c);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsSet(c);
        }
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        Vector copy = (Vector)this.getContents().clone();
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            logger.error((Object)"DistributedQueue.getState(): exception marshalling state.", ex);
            return null;
        }
    }

    public void setState(byte[] new_state) {
        Vector new_copy;
        try {
            new_copy = (Vector)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"DistributedQueue.setState(): exception unmarshalling state.", ex);
            return;
        }
        this._private_reset();
        this._addAll(new_copy);
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (i = 0; i < this.notifs.size(); ++i) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
        }
    }

    void initMethods() {
        try {
            if (this.add_method == null) {
                this.add_method = new MethodCall(this.getClass().getMethod("_add", class$java$lang$Object == null ? (class$java$lang$Object = DistributedQueue.class$("java.lang.Object")) : class$java$lang$Object));
                this.add_method.setNumArgs(1);
            }
            if (this.addAtHead_method == null) {
                this.addAtHead_method = new MethodCall(this.getClass().getMethod("_addAtHead", class$java$lang$Object == null ? (class$java$lang$Object = DistributedQueue.class$("java.lang.Object")) : class$java$lang$Object));
                this.addAtHead_method.setNumArgs(1);
            }
            if (this.addAll_method == null) {
                this.addAll_method = new MethodCall(this.getClass().getMethod("_addAll", class$java$util$Collection == null ? (class$java$util$Collection = DistributedQueue.class$("java.util.Collection")) : class$java$util$Collection));
                this.addAll_method.setNumArgs(1);
            }
            if (this.reset_method == null) {
                this.reset_method = new MethodCall(this.getClass().getMethod("_reset", new Class[0]));
            }
            if (this.remove_method == null) {
                this.remove_method = new MethodCall(this.getClass().getMethod("_remove", new Class[0]));
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"DistributedQueue.initMethods()", ex);
        }
    }

    public static void main(String[] args) {
        try {
            JChannel c = new JChannel("file:/c:/JGroups-2.0/conf/conf/total-token.xml");
            c.setOpt(4, new Boolean(true));
            DistributedQueue ht = new DistributedQueue(c);
            c.connect("demo");
            ht.start(5000L);
            ht.add("name");
            ht.add("Michelle Ban");
            Object old_key = ht.remove();
            System.out.println("old key was " + old_key);
            old_key = ht.remove();
            System.out.println("old value was " + old_key);
            ht.add("name 'Michelle Ban'");
            System.out.println("queue is " + ht);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Notification {
        public void entryAdd(Object var1);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);

        public void contentsCleared();

        public void contentsSet(Collection var1);
    }
}

