/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;

public class ContentAddOperation
extends AbstractOperation {
    private Object content;

    public ContentAddOperation(DiffElement node, Object content) {
        this(node, content, null);
    }

    public ContentAddOperation(DiffElement node, Object content, String comment) {
        this.node = node;
        this.content = content;
        this.comment = comment;
    }

    public int cost() {
        return 1;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("Content", namespace);
        el.setAttribute("Operation", "insert");
        el.setAttribute("Child", this.childNumber(this.content));
        if (this.content instanceof String) {
            el.addContent((String)this.content);
        } else if (this.content instanceof Comment) {
            el.addContent((Comment)this.content);
        } else if (this.content instanceof EntityRef) {
            el.addContent((EntityRef)this.content);
        } else if (this.content instanceof ProcessingInstruction) {
            el.addContent((ProcessingInstruction)this.content);
        } else if (this.content instanceof CDATA) {
            el.addContent((CDATA)this.content);
        } else if (this.content instanceof Element) {
            el.addContent((Element)((Element)this.content).clone());
        } else {
            el.addContent(this.content.toString());
        }
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    private String childNumber(Object child) {
        int n = -1;
        Object[] c = this.node.getContentAsArray();
        int i = 0;
        while (n < 0 && i < c.length) {
            if (c[i] == child) {
                n = i + 1;
            }
            ++i;
        }
        return Integer.toString(n);
    }

    public String toString() {
        return "add content " + this.content + " to " + (Object)((Object)this.node);
    }

    public String getOperationXpath() throws JDOMException {
        return this.node.getXpath();
    }

    public int getOperationNodeNumber() {
        return this.node.getNodeNumber();
    }
}

