/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.ProcessingInstruction;

public class XPath {
    private XPath() {
    }

    public static String getXPath(Element root, Object target) throws JDOMException {
        StringBuffer xpath = null;
        xpath = root == target ? new StringBuffer("/").append(root.getName()) : XPath.followXPath(root, target);
        return xpath.toString();
    }

    public static String getXPath(Element root, Element parent, Object target) throws JDOMException {
        return XPath.computeXPath(root, parent, target).toString();
    }

    public static String getChildXPath(Element parent, Object target) throws JDOMException {
        String xpath = null;
        if (parent == target) {
            xpath = ".";
        } else {
            xpath = XPath.followXPath(parent, target).toString();
            if (xpath == null) {
                throw new JDOMException("the target element is not a descendant of the parent element");
            }
        }
        return xpath;
    }

    private static StringBuffer followXPath(Element root, Object target) throws JDOMException {
        StringBuffer xpath;
        if (target instanceof Element) {
            xpath = ((Element)target).isRootElement() ? XPath.computeXPath(root, null, target) : XPath.computeXPath(root, ((Element)target).getParent(), target);
        } else if (target instanceof Comment) {
            xpath = XPath.computeXPath(root, ((Comment)target).getParent(), target);
        } else if (target instanceof ProcessingInstruction) {
            xpath = XPath.computeXPath(root, ((ProcessingInstruction)target).getParent(), target);
        } else if (target instanceof EntityRef) {
            xpath = XPath.computeXPath(root, ((EntityRef)target).getParent(), target);
        } else {
            Element parent = XPath.findTarget(root, target);
            if (parent != null) {
                xpath = XPath.computeXPath(root, parent, target);
            } else {
                throw new JDOMException("the target object is not in the tree (" + target + ")");
            }
        }
        return xpath;
    }

    private static StringBuffer computeXPath(Element root, Element parent, Object target) throws JDOMException {
        StringBuffer xpath;
        if (target == root) {
            xpath = new StringBuffer("/").append(root.getName());
        } else if (parent == root) {
            xpath = XPath.targetXPath(parent, target);
        } else {
            xpath = XPath.computeXPathToNode(root, parent);
            xpath.append((Object)XPath.targetXPath(parent, target));
        }
        return xpath;
    }

    private static StringBuffer targetXPath(Element parent, Object child) throws JDOMException {
        StringBuffer xpath;
        if (parent == null || child == null) {
            throw new JDOMException("can't use null parent or child");
        }
        if (child instanceof Element) {
            xpath = new StringBuffer();
            xpath.append("/").append(((Element)child).getName());
            int i = XPath.computeTwinIndex(parent, (Element)child);
            if (i > 0) {
                xpath.append("[").append(i).append("]");
            }
        } else {
            int i = XPath.computeChildIndex(parent, child);
            xpath = new StringBuffer("/self::node()[").append(i).append("]");
        }
        return xpath;
    }

    /*
     * Unable to fully structure code
     */
    private static StringBuffer computeXPathToNode(Element root, Element node) throws JDOMException {
        xpath = new StringBuffer();
        n = node;
        if (root != null && node != null) ** GOTO lbl18
        throw new JDOMException("can't use null root or node");
lbl-1000:
        // 1 sources

        {
            p = n.getParent();
            if (p != null && (ti = XPath.computeTwinIndex(p, n)) > 0) {
                xpath.insert(0, "]");
                xpath.insert(0, ti);
                xpath.insert(0, "[");
            }
            xpath.insert(0, n.getName());
            xpath.insert(0, "/");
            n = p;
lbl18:
            // 2 sources

            ** while (n != null)
        }
lbl19:
        // 1 sources

        return xpath;
    }

    private static Element findTarget(Element parent, Object target) {
        Element rslt = null;
        List children = parent.getContent();
        int i = 0;
        while (rslt == null && i < children.size()) {
            Object x = children.get(i);
            if (x == target) {
                rslt = parent;
            } else if (x instanceof Element) {
                rslt = XPath.findTarget((Element)x, target);
            }
            ++i;
        }
        return rslt;
    }

    public static Object getElement(Element root, String xpath) throws JDOMException {
        Object rslt = root.getParent();
        boolean atRoot = true;
        int pathPartStart = 0;
        if (xpath.charAt(0) == '/') {
            pathPartStart = 1;
            while ((atRoot || rslt != null) && pathPartStart < xpath.length()) {
                int pathPartEnd = xpath.indexOf(47, pathPartStart);
                if (pathPartEnd < 0) {
                    pathPartEnd = xpath.length();
                }
                String pathPart = xpath.substring(pathPartStart, pathPartEnd);
                if (rslt == null) {
                    if (root.getName().equals(pathPart)) {
                        rslt = root;
                    }
                } else {
                    int doubleColon = -1;
                    int openBracket = -1;
                    doubleColon = pathPart.indexOf("self::node()[");
                    if (doubleColon >= 0) {
                        int childIndex = XPath.getIndex(pathPart);
                        List children = rslt.getContent();
                        rslt = childIndex >= 0 && childIndex < children.size() ? children.get(childIndex) : null;
                    } else {
                        openBracket = pathPart.indexOf(91);
                        if (openBracket >= 0) {
                            String nodeName = XPath.getNodeName(pathPart);
                            int childIndex = XPath.getIndex(pathPart);
                            List children = XPath.getNamedChildren(rslt, nodeName);
                            rslt = childIndex >= 0 && childIndex < children.size() ? (Element)children.get(childIndex) : null;
                        } else {
                            rslt = rslt.getChild(pathPart);
                        }
                    }
                }
                pathPartStart = pathPartEnd + 1;
                atRoot = false;
            }
        } else {
            throw new JDOMException("xpath is not absolute (must begin with '/')");
        }
        return rslt;
    }

    public static Element getParentElement(Element root, String xpath) throws JDOMException {
        Element rslt = null;
        String parentXpath = XPath.getParentXpath(xpath);
        if (parentXpath != null) {
            Object x = XPath.getElement(root, parentXpath);
            if (x instanceof Element) {
                rslt = (Element)x;
            } else {
                throw new JDOMException("parent element should be type Element, not " + x.getClass().getName());
            }
        }
        return rslt;
    }

    public static String getParentXpath(String xpath) {
        String rslt = null;
        int lastSlash = xpath.lastIndexOf(47);
        if (lastSlash >= 0) {
            rslt = xpath.substring(0, lastSlash);
        }
        return rslt;
    }

    public static String getNodeName(String pathPart) {
        return pathPart.substring(0, pathPart.indexOf(91));
    }

    public static int getIndex(String pathPart) throws JDOMException {
        int rslt = 0;
        int lbracket = pathPart.indexOf(91);
        int rbracket = pathPart.indexOf(93);
        if (rbracket == pathPart.length() - 1) {
            String numStr = pathPart.substring(lbracket + 1, rbracket);
            try {
                rslt = Integer.parseInt(numStr);
            }
            catch (NumberFormatException e) {
                throw new JDOMException("invalid index in \"" + pathPart + "\"");
            }
        } else {
            throw new JDOMException("index must be the last part of \"" + pathPart + "\"");
        }
        return rslt - 1;
    }

    private static List getNamedChildren(Element parent, String name) throws JDOMException {
        ArrayList children = new ArrayList();
        if (parent == null) {
            throw new JDOMException("can't use null parent");
        }
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof Element) || !((Element)child).getName().equals(name)) continue;
            children.add(child);
        }
        return children;
    }

    private static int computeTwinIndex(Element parent, Element child) throws JDOMException {
        int index = -1;
        if (parent == null) {
            throw new JDOMException("can't use null parent");
        }
        List identicalTwins = XPath.getNamedChildren(parent, child.getName());
        if (identicalTwins.size() > 1) {
            int j = 0;
            while (index < 0 && j < identicalTwins.size()) {
                if ((Element)identicalTwins.get(j) == child) {
                    index = j + 1;
                }
                ++j;
            }
            if (index < 0) {
                throw new JDOMException("error in tree: node is not listed among its parent's children");
            }
        }
        return index;
    }

    private static int computeChildIndex(Element parent, Object child) throws JDOMException {
        int index = -1;
        List content = parent.getContent();
        int i = 0;
        while (index < 0 && i < content.size()) {
            if (content.get(i) == child) {
                index = i + 1;
            }
            ++i;
        }
        if (index < 0) {
            throw new JDOMException("error in tree: object is not listed among its parent's children");
        }
        return index;
    }
}

