/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.util.List;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.vmguys.vmtools.utils.DiffElement;

public abstract class AbstractOperation {
    protected DiffElement node;
    protected String comment;

    public String toString() {
        return "undetermined operation";
    }

    public int getNodeNumber() {
        return this.node.getNodeNumber();
    }

    public String getXpath() throws JDOMException {
        return this.node.getXpath();
    }

    public abstract String getOperationXpath() throws JDOMException;

    public abstract int getOperationNodeNumber();

    public abstract int cost();

    public abstract Element asElement(Namespace var1);

    protected Element wrapMetaData(Element node) {
        List content = node.getContent();
        int i = 0;
        while (i < content.size()) {
            Object x = content.get(i);
            if (x instanceof Element) {
                this.wrapMetaData((Element)x);
            } else if (x instanceof Comment) {
                content.remove(i);
                content.add(i, this.wrapComment((Comment)x));
            } else if (x instanceof ProcessingInstruction) {
                content.remove(i);
                content.add(i, this.wrapPI((ProcessingInstruction)x));
            }
            ++i;
        }
        return node;
    }

    protected Element wrapComment(Comment comment) {
        Element c = new Element("Comment");
        c.setAttribute("Value", comment.getText());
        return c;
    }

    protected Element wrapPI(ProcessingInstruction procInst) {
        Element pi = new Element("ProcessingInstruction");
        pi.setAttribute("Target", procInst.getTarget());
        pi.setAttribute("Data", procInst.getData());
        return pi;
    }
}

