/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.set;

import java.util.Comparator;
import java.util.SortedSet;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.set.PredicatedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedSortedSet<E>
extends PredicatedSet<E>
implements SortedSet<E> {
    private static final long serialVersionUID = -9110948148132275052L;

    public static <E> SortedSet<E> decorate(SortedSet<E> set, Predicate<? super E> predicate) {
        return new PredicatedSortedSet<E>(set, predicate);
    }

    protected PredicatedSortedSet(SortedSet<E> set, Predicate<? super E> predicate) {
        super(set, predicate);
    }

    private SortedSet<E> getSortedSet() {
        return (SortedSet)this.getCollection();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        SortedSet<E> sub = this.getSortedSet().subSet(fromElement, toElement);
        return new PredicatedSortedSet<E>(sub, this.predicate);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        SortedSet<E> sub = this.getSortedSet().headSet(toElement);
        return new PredicatedSortedSet<E>(sub, this.predicate);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        SortedSet<E> sub = this.getSortedSet().tailSet(fromElement);
        return new PredicatedSortedSet<E>(sub, this.predicate);
    }

    @Override
    public E first() {
        return this.getSortedSet().first();
    }

    @Override
    public E last() {
        return this.getSortedSet().last();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.getSortedSet().comparator();
    }
}

