/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.store;

import com.funambol.framework.engine.dm.DeviceDMState;
import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.store.BasePersistentStore;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.server.store.PreparedWhere;
import com.funambol.framework.server.store.WhereClause;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.DBTools;
import com.funambol.server.engine.Sync4jSource;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class EnginePersistentStore
extends BasePersistentStore
implements PersistentStore,
Serializable {
    private static final String OPT_INSERT = "INSERT";
    public static final byte SQL_INSERT_PRINCIPAL = 0;
    public static final byte SQL_GET_PRINCIPAL = 1;
    public static final byte SQL_SELECT_PRINCIPAL = 2;
    public static final byte SQL_UPDATE_PRINCIPAL = 3;
    public static final byte SQL_SELECT_ALL_PRINCIPALS = 4;
    public static final byte SQL_INSERT_SOURCE = 5;
    public static final byte SQL_GET_SOURCE = 6;
    public static final byte SQL_UPDATE_SOURCE = 7;
    public static final byte SQL_SELECT_ALL_SOURCES = 8;
    public static final byte SQL_SELECT_ALL_DEVICES = 9;
    public static final byte SQL_GET_DEVICE = 10;
    public static final byte SQL_INSERT_DEVICE = 11;
    public static final byte SQL_UPDATE_DEVICE = 12;
    public static final byte SQL_DELETE_DEVICE = 13;
    public static final byte SQL_DELETE_DEVICE_PRINCIPAL = 14;
    public static final byte SQL_DELETE_PRINCIPAL = 15;
    public static final byte SQL_DELETE_CLIENT_MAPPING = 16;
    public static final byte SQL_DELETE_LAST_SYNC = 17;
    public static final byte SQL_GET_COUNTER = 18;
    public static final byte SQL_UPDATE_COUNTER = 19;
    public static final byte SQL_DELETE_SOURCE = 20;
    public static final byte SQL_INSERT_SYNCSOURCE = 21;
    public static final byte SQL_UPDATE_SYNCSOURCE = 22;
    public static final byte SQL_DELETE_SOURCE_CLIENT_MAPPING = 23;
    public static final byte SQL_DELETE_SOURCE_LAST_SYNC = 24;
    public static final byte SQL_COUNT_DEVICES = 25;
    public static final byte SQL_COUNT_PRINCIPALS = 26;
    public static final byte SQL_GET_DEVICE_DM_STATE = 27;
    public static final byte SQL_UPDATE_DEVICE_DM_STATE = 28;
    public static final byte SQL_INSERT_DEVICE_DM_STATE = 29;
    public static final byte SQL_DELETE_DEVICE_DM_STATE = 30;
    public static final byte SQL_SELECT_ALL_DM_STATE = 31;
    public static final String NS_PRINCIPAL = "principal";
    public static final String NS_DEVICE = "device";
    public static final String NS_DM_STATE = "dmstate";
    private String[] sql = null;
    private static final String SEARCH_COUNT_DEVICES = "SCD";
    private static final String SEARCH_COUNT_PRINCIPALS = "SCP";

    public void setSql(String[] sql) {
        this.sql = sql;
    }

    public String[] getSql() {
        return this.sql;
    }

    public boolean delete(Object o) throws PersistentStoreException {
        if (o instanceof Sync4jDevice) {
            this.deleteDevice((Sync4jDevice)o);
            return true;
        }
        if (o instanceof Sync4jPrincipal) {
            this.deletePrincipal((Sync4jPrincipal)o);
            return true;
        }
        if (o instanceof Sync4jSource) {
            this.deleteSource((Sync4jSource)o);
            return true;
        }
        if (o instanceof DeviceDMState) {
            this.deleteDeviceDMState((DeviceDMState)o);
            return true;
        }
        return false;
    }

    public boolean store(String id, Object o, String operation) throws PersistentStoreException {
        if (o instanceof Sync4jSource) {
            if (operation.equals(OPT_INSERT)) {
                this.insertSyncSource(id, (Sync4jSource)o);
            } else {
                this.updateSyncSource(id, (Sync4jSource)o);
            }
            return true;
        }
        return false;
    }

    public boolean store(Object o) throws PersistentStoreException {
        if (o instanceof Sync4jPrincipal) {
            this.storePrincipal((Sync4jPrincipal)o);
            return true;
        }
        if (o instanceof Sync4jSource) {
            this.storeSource((Sync4jSource)o);
            return true;
        }
        if (o instanceof Sync4jDevice) {
            this.storeDevice((Sync4jDevice)o);
            return true;
        }
        if (o instanceof DeviceDMState) {
            this.storeDeviceDMState((DeviceDMState)o);
            return true;
        }
        return false;
    }

    public boolean read(Object o) throws PersistentStoreException {
        if (o instanceof Sync4jPrincipal) {
            this.readPrincipal((Sync4jPrincipal)o);
            return true;
        }
        if (o instanceof Sync4jSource) {
            this.readSource((Sync4jSource)o);
            return true;
        }
        if (o instanceof Sync4jDevice) {
            this.readDevice((Sync4jDevice)o);
            return true;
        }
        if (o instanceof DeviceDMState) {
            this.readDeviceDMState((DeviceDMState)o);
            return true;
        }
        return false;
    }

    public Object[] read(Class objClass) throws PersistentStoreException {
        if (objClass.equals(Sync4jSource.class)) {
            return this.readAllSources();
        }
        return null;
    }

    public Object[] read(Object o, Clause clause) throws PersistentStoreException {
        if (o instanceof Sync4jPrincipal) {
            return this.readAllPrincipals(clause);
        }
        if (o instanceof Sync4jDevice) {
            return this.readAllDevices(clause);
        }
        if (o instanceof String) {
            if (o.equals(SEARCH_COUNT_DEVICES)) {
                return this.readCountDevices(clause);
            }
            if (o.equals(SEARCH_COUNT_PRINCIPALS)) {
                return this.readCountPrincipals(clause);
            }
        } else {
            if (o instanceof Sync4jSource) {
                return this.readSource((Sync4jSource)o, clause);
            }
            if (o instanceof DeviceDMState) {
                return this.readDeviceDMState(clause);
            }
        }
        return null;
    }

    private void storePrincipal(Sync4jPrincipal p) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int n = 0;
        try {
            conn = this.dataSource.getConnection();
            if (p.getId() != null && !p.getId().equals("")) {
                stmt = conn.prepareStatement(this.sql[3]);
                stmt.setString(1, p.getUsername());
                stmt.setString(2, p.getDeviceId());
                stmt.setString(3, p.getId());
                n = stmt.executeUpdate();
                stmt.close();
            } else {
                stmt = conn.prepareStatement(this.sql[2]);
                stmt.setString(1, p.getUsername());
                stmt.setString(2, p.getDeviceId());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    n = 0;
                } else {
                    n = 1;
                    p.setId(rs.getString(1));
                    p.setUsername(rs.getString(2));
                    p.setDeviceId(rs.getString(3));
                    p.setEmail(rs.getString(4));
                    p.setFirstName(rs.getString(5));
                    p.setLastName(rs.getString(6));
                }
                stmt.close();
                rs.close();
            }
            if (n == 0) {
                int principalId = this.readCounter(NS_PRINCIPAL);
                p.setId("" + principalId);
                stmt = conn.prepareStatement(this.sql[0]);
                stmt.setString(1, p.getId());
                stmt.setString(2, p.getUsername());
                stmt.setString(3, p.getDeviceId());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error storing principal " + p, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private void readPrincipal(Sync4jPrincipal p) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            if (p.getId() == null) {
                stmt = conn.prepareStatement(this.sql[2]);
                stmt.setString(1, p.getUsername());
                stmt.setString(2, p.getDeviceId());
            } else {
                stmt = conn.prepareStatement(this.sql[1]);
                stmt.setString(1, p.getId());
            }
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NotFoundException("Principal not found for " + p.toString());
            }
            p.setId(rs.getString(1));
            p.setUsername(rs.getString(2));
            p.setDeviceId(rs.getString(3));
            p.setEmail(rs.getString(4));
            p.setFirstName(rs.getString(5));
            p.setLastName(rs.getString(6));
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading principal " + p, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private Object[] readAllPrincipals(Clause clause) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jPrincipal> ret = new ArrayList<Sync4jPrincipal>();
        try {
            conn = this.dataSource.getConnection();
            PreparedWhere where = clause.getPreparedWhere();
            String query = this.sql[4];
            if (where.sql.length() > 0) {
                query = query + " where " + where.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < where.parameters.length; ++i) {
                stmt.setObject(i + 1, where.parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jPrincipal(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
            objectArray = ret.toArray(new Sync4jPrincipal[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading principals", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return objectArray;
    }

    private void deletePrincipal(Sync4jPrincipal p) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[15]);
            stmt.setString(1, p.getId());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error deleting the principal " + p, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    public Object[] readCountPrincipals(Clause clause) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int n = 0;
        try {
            conn = this.dataSource.getConnection();
            PreparedWhere where = clause.getPreparedWhere();
            String query = this.sql[26];
            if (where.sql.length() > 0) {
                query = query + " where " + where.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < where.parameters.length; ++i) {
                stmt.setObject(i + 1, where.parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                n = rs.getInt(1);
            }
            Object[] s = new String[]{"" + n};
            objectArray = s;
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading count principals ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return objectArray;
    }

    private Object[] readAllDevices(Clause clause) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jDevice> ret = new ArrayList<Sync4jDevice>();
        try {
            conn = this.dataSource.getConnection();
            PreparedWhere where = clause.getPreparedWhere();
            String query = this.sql[9];
            if (where.sql.length() > 0) {
                query = query + " where " + where.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < where.parameters.length; ++i) {
                stmt.setObject(i + 1, where.parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jDevice(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
            objectArray = ret.toArray(new Sync4jDevice[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading devices", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return objectArray;
    }

    private void readDevice(Sync4jDevice d) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[10]);
            stmt.setString(1, d.getDeviceId());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NotFoundException("Device not found for " + d.getDeviceId());
            }
            d.setDescription(rs.getString(1));
            d.setType(rs.getString(2));
            d.setDigest(rs.getString(3));
            String value = rs.getString(4);
            if (value == null) {
                d.setClientNonce(null);
            } else if (value.equals("")) {
                d.setClientNonce(new byte[0]);
            } else {
                d.setClientNonce(Base64.decode((byte[])value.getBytes()));
            }
            value = rs.getString(5);
            if (value == null) {
                d.setServerNonce(null);
            } else if (value.equals("")) {
                d.setServerNonce(new byte[0]);
            } else {
                d.setServerNonce(Base64.decode((byte[])value.getBytes()));
            }
            d.setServerPassword(rs.getString(6));
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading the device " + d, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private void storeDevice(Sync4jDevice d) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        int n = 0;
        try {
            conn = this.dataSource.getConnection();
            if (d.getDeviceId() != null && !d.getDeviceId().equals("")) {
                stmt = conn.prepareStatement(this.sql[12]);
                stmt.setString(1, d.getDescription());
                stmt.setString(2, d.getType());
                stmt.setString(3, d.getDigest());
                byte[] nonce = d.getClientNonce();
                stmt.setString(4, nonce != null ? new String(Base64.encode((byte[])nonce)) : null);
                nonce = d.getServerNonce();
                stmt.setString(5, nonce != null ? new String(Base64.encode((byte[])nonce)) : null);
                stmt.setString(6, d.getServerPassword());
                stmt.setString(7, d.getDeviceId());
                n = stmt.executeUpdate();
                stmt.close();
            }
            if (n == 0) {
                if (d.getDeviceId() == null || d.getDeviceId().equals("")) {
                    int deviceId = this.readCounter(NS_DEVICE);
                    d.setDeviceId("" + deviceId);
                }
                stmt = conn.prepareStatement(this.sql[11]);
                stmt.setString(1, d.getDeviceId());
                stmt.setString(2, d.getDescription());
                stmt.setString(3, d.getType());
                stmt.setString(4, d.getDigest());
                byte[] nonce = d.getClientNonce();
                stmt.setString(5, nonce != null ? new String(Base64.encode((byte[])nonce)) : null);
                nonce = d.getServerNonce();
                stmt.setString(6, nonce != null ? new String(Base64.encode((byte[])nonce)) : null);
                stmt.setString(7, d.getServerPassword());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new PersistentStoreException("Error storing the device " + d, (Throwable)e);
        }
        finally {
            DBTools.close((Connection)conn, stmt, null);
        }
    }

    private void deleteDevice(Sync4jDevice d) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            WhereClause c = new WhereClause(NS_DEVICE, new String[]{d.getDeviceId()}, "EQ", true);
            Sync4jPrincipal[] sp = (Sync4jPrincipal[])this.readAllPrincipals((Clause)c);
            for (int i = 0; sp != null && i < sp.length; ++i) {
                Sync4jPrincipal syncPrincipal = sp[i];
                this.deletePrincipal(syncPrincipal);
            }
            stmt = conn.prepareStatement(this.sql[13]);
            stmt.setString(1, d.getDeviceId());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error deleting the device " + d, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    public Object[] readCountDevices(Clause clause) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int n = 0;
        try {
            conn = this.dataSource.getConnection();
            PreparedWhere where = clause.getPreparedWhere();
            String query = this.sql[25];
            if (where.sql.length() > 0) {
                query = query + " where " + where.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < where.parameters.length; ++i) {
                stmt.setObject(i + 1, where.parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                n = rs.getInt(1);
            }
            Object[] s = new String[]{"" + n};
            objectArray = s;
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading count devices ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return objectArray;
    }

    private Object[] readAllSources() throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jSource> ret = new ArrayList<Sync4jSource>();
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[8]);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jSource(rs.getString(1), rs.getString(2)));
            }
            objectArray = ret.toArray(new Sync4jSource[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading sources", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return objectArray;
    }

    private void storeSource(Sync4jSource s) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[7]);
            stmt.setString(1, s.getConfig());
            stmt.setString(2, s.getUri());
            int n = stmt.executeUpdate();
            if (n == 0) {
                stmt.close();
                stmt = conn.prepareStatement(this.sql[5]);
                stmt.setString(1, s.getUri());
                stmt.setString(2, s.getConfig());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error storing the source " + s, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    private void readSource(Sync4jSource s) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[6]);
            stmt.setString(1, s.getUri());
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NotFoundException("Source not found for " + s.getUri());
            }
            s.setUri(rs.getString(1));
            s.setConfig(rs.getString(2));
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading the source " + s, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private Object[] readSource(Sync4jSource s, Clause clause) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Sync4jSource> ret = new ArrayList<Sync4jSource>();
        try {
            conn = this.dataSource.getConnection();
            PreparedWhere where = clause.getPreparedWhere();
            String query = this.sql[8];
            if (where.sql.length() > 0) {
                query = query + " where " + where.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < where.parameters.length; ++i) {
                stmt.setObject(i + 1, where.parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(new Sync4jSource(rs.getString(1), rs.getString(2)));
            }
            objectArray = ret.toArray(new Sync4jSource[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading sources", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return objectArray;
    }

    private void deleteSource(Sync4jSource s) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[23]);
            stmt.setString(1, s.getUri());
            stmt.executeUpdate();
            stmt.close();
            stmt = conn.prepareStatement(this.sql[24]);
            stmt.setString(1, s.getUri());
            stmt.executeUpdate();
            stmt.close();
            stmt = conn.prepareStatement(this.sql[20]);
            stmt.setString(1, s.getUri());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error deleting the source " + s, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    private void insertSyncSource(String sourcetypeid, Sync4jSource ss) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[21]);
            stmt.setString(1, ss.getUri());
            stmt.setString(2, ss.getConfig());
            stmt.setString(3, ss.getSourceName());
            stmt.setString(4, sourcetypeid);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error storing the syncsource " + ss, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    private void updateSyncSource(String sourcetypeid, Sync4jSource ss) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[22]);
            stmt.setString(1, ss.getConfig());
            stmt.setString(2, ss.getSourceName());
            stmt.setString(3, ss.getSourceTypeId());
            stmt.setString(4, ss.getUri());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error updating the syncsource " + ss, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    private void readDeviceDMState(DeviceDMState d) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[27]);
            stmt.setString(1, d.deviceId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NotFoundException("Device not found for " + d.deviceId);
            }
            d.mssid = rs.getString(1);
            String value = rs.getString(2);
            d.state = value == null ? (byte)0 : (byte)value.charAt(0);
            d.start = rs.getTimestamp(3);
            d.end = rs.getTimestamp(4);
            d.operation = rs.getString(5);
            d.info = rs.getString(6);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading the device " + d, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private void storeDeviceDMState(DeviceDMState d) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        int n = 0;
        try {
            conn = this.dataSource.getConnection();
            if (d.id != null) {
                stmt = conn.prepareStatement(this.sql[28]);
                stmt.setString(1, d.deviceId);
                stmt.setString(2, d.mssid);
                stmt.setString(3, String.valueOf((char)d.state));
                stmt.setTimestamp(4, d.start == null ? null : new Timestamp(d.start.getTime()));
                stmt.setTimestamp(5, d.end == null ? null : new Timestamp(d.end.getTime()));
                stmt.setString(6, d.operation);
                stmt.setString(7, d.info);
                stmt.setString(8, d.id);
                n = stmt.executeUpdate();
                stmt.close();
                stmt = null;
            }
            if (n == 0) {
                if (d.id == null) {
                    d.id = String.valueOf(this.readCounter(NS_DM_STATE));
                }
                stmt = conn.prepareStatement(this.sql[29]);
                stmt.setString(1, d.id);
                stmt.setString(2, d.deviceId);
                stmt.setString(3, d.mssid);
                stmt.setString(4, String.valueOf((char)d.state));
                stmt.setTimestamp(5, d.start == null ? null : new Timestamp(d.start.getTime()));
                stmt.setTimestamp(6, d.end == null ? null : new Timestamp(d.end.getTime()));
                stmt.setString(7, d.operation);
                stmt.setString(8, d.info);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new PersistentStoreException("Error storing the device DM state " + d, (Throwable)e);
        }
        finally {
            DBTools.close((Connection)conn, stmt, null);
        }
    }

    private Object[] readDeviceDMState(Clause clause) throws PersistentStoreException {
        Object[] objectArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<DeviceDMState> ret = new ArrayList<DeviceDMState>();
        try {
            conn = this.dataSource.getConnection();
            PreparedWhere where = clause.getPreparedWhere();
            String query = this.sql[31];
            if (where.sql.length() > 0) {
                query = query + " where " + where.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < where.parameters.length; ++i) {
                stmt.setObject(i + 1, where.parameters[i]);
            }
            rs = stmt.executeQuery();
            String value = null;
            DeviceDMState dms = null;
            while (rs.next()) {
                dms = new DeviceDMState();
                dms.id = rs.getString(1);
                dms.deviceId = rs.getString(2);
                dms.mssid = rs.getString(3);
                value = rs.getString(4);
                dms.state = (byte)(value != null ? (int)value.charAt(0) : 45);
                dms.start = rs.getTimestamp(5);
                dms.end = rs.getTimestamp(6);
                dms.operation = rs.getString(7);
                dms.info = rs.getString(8);
                ret.add(dms);
            }
            objectArray = ret.toArray(new DeviceDMState[ret.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading device managment state", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return objectArray;
    }

    private void deleteDeviceDMState(DeviceDMState d) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sql[30]);
            stmt.setString(1, d.id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error deleting the device " + d, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    public int readCounter(String idSpace) throws PersistentStoreException {
        return this.readCounter(idSpace, 1);
    }

    public int readCounter(String idSpace, int increment) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            conn = this.dataSource.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            stmt = dmd.supportsSelectForUpdate() ? conn.prepareStatement(this.sql[18]) : conn.prepareStatement("select counter from sync4j_id where idspace=?");
            stmt.setString(1, idSpace);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NotFoundException("Counter not found for " + idSpace);
            }
            counter = rs.getInt(1);
            stmt.close();
            stmt = conn.prepareStatement(this.sql[19]);
            stmt.setInt(1, counter + increment);
            stmt.setString(2, idSpace);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new PersistentStoreException("Error reading the counter " + counter, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return counter;
    }
}

