/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.notification;

import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.notification.NotificationSender;
import java.io.BufferedOutputStream;
import java.net.Socket;
import java.net.URL;
import org.jboss.logging.Logger;

public class HttpSender
implements NotificationSender {
    private String deviceAddress = null;
    private static final transient Logger log = Logger.getLogger((String)HttpSender.class.getName());

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public void setDeviceAddress(String deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public void sendMessages(int messageType, String[] phoneNumbers, byte[][] messages, String info) throws NotificationException {
        for (int i = 0; i < phoneNumbers.length; ++i) {
            if (i != 0) {
                System.out.println("Wait 20 s for test with SCTS");
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            this.sendMessage(messageType, phoneNumbers[i], messages[i], info);
        }
    }

    private void sendMessage(int messageType, String phoneNumber, byte[] message, String info) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("sendMessage: " + message + " (length: " + message.length + ")"));
        }
        if (messageType != 0) {
            throw new NotificationException("This sender is usable only for notification message");
        }
        byte[] nestedRequest = this.buildNestedRequest(message);
        byte[] request = this.buildRequest(nestedRequest);
        try {
            this.sendHttpRequest(request);
        }
        catch (Exception e) {
            throw new NotificationException("Error sending the message via http", (Throwable)e);
        }
    }

    private void sendHttpRequest(byte[] message) throws Exception {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Send message to: " + this.deviceAddress));
        }
        URL url = new URL(this.deviceAddress);
        String host = url.getHost();
        int port = url.getPort();
        Socket conn = new Socket(host, port);
        BufferedOutputStream wr = new BufferedOutputStream(conn.getOutputStream());
        wr.write(message);
        wr.flush();
        wr.close();
    }

    private byte[] buildRequest(byte[] message) {
        StringBuffer sb = new StringBuffer("POST /wappush HTTP/1.1\r\n");
        sb.append("Host: 127.0.0.1\r\n");
        sb.append("Content-Type: application/http\r\n");
        sb.append("Content-Length: ").append(message.length).append("\r\n");
        sb.append("X-Wap-Push-OTA-Version: 1.0\r\n\r\n");
        byte[] header = sb.toString().getBytes();
        byte[] request = new byte[header.length + message.length];
        System.arraycopy(header, 0, request, 0, header.length);
        System.arraycopy(message, 0, request, header.length, message.length);
        return request;
    }

    private byte[] buildNestedRequest(byte[] message) {
        StringBuffer sb = new StringBuffer("HTTP/1.1 200 OK\r\n");
        sb.append("Content-Language: en\r\n");
        sb.append("Content-Length: ").append(message.length).append("\r\n");
        sb.append("Content-Type: application/vnd.syncml.notification\r\n\r\n");
        byte[] header = sb.toString().getBytes();
        byte[] nestedRequest = new byte[header.length + message.length];
        System.arraycopy(header, 0, nestedRequest, 0, header.length);
        System.arraycopy(message, 0, nestedRequest, header.length, message.length);
        return nestedRequest;
    }
}

