/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.tools.beans;

import com.funambol.framework.tools.beans.BeanException;
import com.funambol.framework.tools.beans.BeanExceptionListener;
import com.funambol.framework.tools.beans.BeanInitializationException;
import com.funambol.framework.tools.beans.BeanInstantiationException;
import com.funambol.framework.tools.beans.LazyInitBean;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BeanFactory {
    protected BeanFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getNoInitBeanInstance(ClassLoader classLoader, String beanName) throws BeanInstantiationException, BeanInitializationException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Object bean = null;
        try {
            bean = Class.forName(beanName, true, classLoader).newInstance();
            if (bean instanceof LazyInitBean) {
                ((LazyInitBean)bean).init();
            }
            return bean;
        }
        catch (ClassNotFoundException e) {
        }
        catch (BeanInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanInstantiationException("Error instantiating " + beanName, e);
        }
        InputStream is = classLoader.getResourceAsStream(beanName);
        if (is == null) {
            throw new BeanInstantiationException("Resource " + beanName + " not found" + " with " + classLoader);
        }
        BeanExceptionListener exceptionListener = new BeanExceptionListener();
        Class<BeanFactory> clazz = BeanFactory.class;
        synchronized (BeanFactory.class) {
            XMLDecoder d = new XMLDecoder(is, null, exceptionListener);
            bean = d.readObject();
            d.close();
            // ** MonitorExit[var5_8] (shouldn't be in output)
            if (exceptionListener.exceptionThrown()) {
                Throwable t = exceptionListener.getException();
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                throw new BeanInstantiationException("Error instantiating " + beanName, t);
            }
            return bean;
        }
    }

    public static Object getBeanInstance(ClassLoader classLoader, String beanName) throws BeanInstantiationException, BeanInitializationException {
        Object bean = null;
        bean = BeanFactory.getNoInitBeanInstance(classLoader, beanName);
        if (bean instanceof LazyInitBean) {
            ((LazyInitBean)bean).init();
        }
        return bean;
    }

    public static Object getBeanInstance(String beanName) throws BeanInstantiationException, BeanInitializationException {
        return BeanFactory.getBeanInstance(null, beanName);
    }

    public static Object getBeanInstance(File beanFile) throws BeanInstantiationException, BeanInitializationException {
        try {
            Object bean = null;
            XMLDecoder e = new XMLDecoder(new FileInputStream(beanFile));
            bean = e.readObject();
            e.close();
            if (bean instanceof LazyInitBean) {
                ((LazyInitBean)bean).init();
            }
            return bean;
        }
        catch (IOException e) {
            String msg = "Bean creation (" + beanFile + ") failed: " + e.getMessage();
            throw new BeanInstantiationException(msg, e);
        }
        catch (Exception e) {
            String msg = "Bean creation (" + beanFile + ") failed: " + e.getMessage();
            throw new BeanInstantiationException(msg, e);
        }
    }

    public static void saveBeanInstance(Object obj, File file) throws BeanException {
        XMLEncoder encoder = null;
        try {
            encoder = new XMLEncoder(new FileOutputStream(file));
            encoder.writeObject(obj);
        }
        catch (IOException e) {
            String msg = "Bean saving (" + file + ") failed: " + e.getMessage();
            throw new BeanException(msg, e);
        }
        finally {
            if (encoder != null) {
                encoder.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Syntax: com.funambol.framework.tools.beans.BeanFactory <class name> <file name>");
            return;
        }
        BeanFactory.saveBeanInstance(BeanFactory.getBeanInstance(args[0]), new File(args[1]));
    }
}

