/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.Anchor;
import com.funambol.framework.core.Atomic;
import com.funambol.framework.core.Chal;
import com.funambol.framework.core.CmdID;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.NextNonce;
import com.funambol.framework.core.Replace;
import com.funambol.framework.core.ResponseCommand;
import com.funambol.framework.core.Sequence;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.Sync;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.core.dm.ddf.DevInfo;
import com.funambol.framework.database.Database;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.tools.MD5;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ProtocolUtil {
    public static ArrayList<AbstractCommand> filterCommands(AbstractCommand[] commands, Class filterClass) {
        ArrayList<AbstractCommand> filteredCommands = new ArrayList<AbstractCommand>();
        for (int i = 0; i < commands.length; ++i) {
            if (!filterClass.isInstance(commands[i])) continue;
            filteredCommands.add(commands[i]);
        }
        return filteredCommands;
    }

    public static ArrayList<AbstractCommand> filterCommands(AbstractCommand[] commands, CmdID cmdId) {
        ArrayList<AbstractCommand> filteredCommands = new ArrayList<AbstractCommand>();
        for (int i = 0; i < commands.length; ++i) {
            if (!(commands[i] instanceof ResponseCommand) || !((ResponseCommand)commands[i]).getCmdID().equals(cmdId)) continue;
            filteredCommands.add(commands[i]);
        }
        return filteredCommands;
    }

    public static ArrayList<AbstractCommand> filterCommands(AbstractCommand[] commands, Class filterClass, CmdID cmdId) {
        ArrayList<AbstractCommand> list = ProtocolUtil.filterCommands(commands, cmdId);
        int size = list.size();
        AbstractCommand[] aCommands = new AbstractCommand[size];
        for (int i = 0; i < size; ++i) {
            aCommands[i] = list.get(i);
        }
        return ProtocolUtil.filterCommands(aCommands, filterClass);
    }

    public static Status filterStatus(AbstractCommand[] commands, Class filterClass, String cmd) {
        ArrayList<AbstractCommand> allStatus = ProtocolUtil.filterCommands(commands, filterClass);
        for (int i = 0; allStatus != null && i < allStatus.size(); ++i) {
            if (!((Status)allStatus.get(i)).getCmd().equals(cmd)) continue;
            return (Status)allStatus.get(i);
        }
        return null;
    }

    public static Alert searchAlertCommand(SyncBody syncBody, int code) {
        AbstractCommand[] commands = syncBody.getCommands().toArray(new AbstractCommand[0]);
        ArrayList<AbstractCommand> alertList = ProtocolUtil.filterCommands(commands, Alert.class);
        Iterator<AbstractCommand> i = alertList.iterator();
        Alert alertCommand = null;
        while (i.hasNext()) {
            alertCommand = (Alert)i.next();
            if (code != alertCommand.getData()) continue;
            return alertCommand;
        }
        return null;
    }

    public static Alert[] searchAlertCommands(SyncBody syncBody, int code) {
        AbstractCommand[] commands = syncBody.getCommands().toArray(new AbstractCommand[0]);
        ArrayList<AbstractCommand> alertList = ProtocolUtil.filterCommands(commands, Alert.class);
        Iterator<AbstractCommand> i = alertList.iterator();
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        Alert alertCommand = null;
        while (i.hasNext()) {
            alertCommand = (Alert)i.next();
            if (code != alertCommand.getData()) continue;
            alerts.add(alertCommand);
        }
        return alerts.toArray(new Alert[0]);
    }

    public static Alert[] searchGenericAlertCommands(SyncBody syncBody) {
        return ProtocolUtil.searchAlertCommands(syncBody, 1226);
    }

    public static Alert createAlertCommand(CmdID id, boolean noResponse, Cred credential, Database db) {
        Item[] items = new Item[1];
        Anchor serverAnchor = db.getServerAnchor();
        Meta meta = new Meta();
        meta.setAnchor(serverAnchor);
        items[0] = new Item(db.getTarget(), db.getSource(), meta, null, false);
        return new Alert(id, noResponse, credential, db.getMethod(), items);
    }

    public static Source target2Source(Target target) {
        if (target == null) {
            return null;
        }
        return new Source(target.getLocURI(), target.getLocName());
    }

    public static Target source2Target(Source source) {
        if (source == null) {
            return null;
        }
        return new Target(source.getLocURI(), source.getLocName());
    }

    public static void extractRefs(Item[] items, TargetRef[] targetRefs, SourceRef[] sourceRefs) {
        if (items == null) {
            return;
        }
        Target t = null;
        Source s = null;
        for (int i = 0; i < items.length; ++i) {
            t = items[i].getTarget();
            s = items[i].getSource();
            targetRefs[i] = t != null ? new TargetRef(t) : null;
            sourceRefs[i] = s != null ? new SourceRef(s) : null;
        }
    }

    public static List<AbstractCommand> filterCommands(List<AbstractCommand> commands, String[] types) {
        StringBuffer sb = new StringBuffer(",");
        for (int i = 0; types != null && i < types.length; ++i) {
            sb.append(types[i]).append(',');
        }
        ArrayList<AbstractCommand> selectedCommands = new ArrayList<AbstractCommand>();
        AbstractCommand command2 = null;
        for (AbstractCommand command2 : commands) {
            if (sb.indexOf(',' + command2.getName() + ',') < 0) continue;
            selectedCommands.add(command2);
        }
        return selectedCommands;
    }

    public static boolean noMoreResponse(SyncML msg) {
        AbstractCommand[] commands = msg.getSyncBody().getCommands().toArray(new AbstractCommand[0]);
        for (int i = 0; commands != null && i < commands.length; ++i) {
            if (Status.COMMAND_NAME.equals(commands[i].getName())) continue;
            return false;
        }
        return true;
    }

    public static DevInfo devInfoFromReplace(Replace cmd) throws ProtocolException {
        Item item2 = null;
        ArrayList<Item> items = cmd.getItems();
        if (items.isEmpty()) {
            throw new ProtocolException("No Item found in Replace");
        }
        String devId = null;
        String man = null;
        String mod = null;
        String dmV = null;
        String lang = null;
        String uri = null;
        for (Item item2 : items) {
            try {
                uri = item2.getSource().getLocURI();
                if (uri == null) {
                    throw new NullPointerException();
                }
            }
            catch (NullPointerException e) {
                throw new ProtocolException("Some of the items are not in the right format.");
            }
            if (uri.endsWith("/DevId")) {
                devId = item2.getData().getData();
                continue;
            }
            if (uri.endsWith("/Man")) {
                man = item2.getData().getData();
                continue;
            }
            if (uri.endsWith("/Mod")) {
                mod = item2.getData().getData();
                continue;
            }
            if (uri.endsWith("/DmV")) {
                dmV = item2.getData().getData();
                continue;
            }
            if (!uri.endsWith("/Lang")) continue;
            lang = item2.getData().getData();
        }
        return new DevInfo(devId, man, mod, dmV, lang);
    }

    public static NextNonce generateNextNonce() {
        return new NextNonce(MD5.getNextNonce());
    }

    public static int getHeaderStatusCode(SyncML msg) {
        ArrayList<AbstractCommand> cmdList = msg.getSyncBody().getCommands();
        if ((cmdList = ProtocolUtil.filterCommands(cmdList.toArray(new AbstractCommand[cmdList.size()]), Status.class, new CmdID("1"))).isEmpty()) {
            return -1;
        }
        return ((Status)cmdList.get(0)).getStatusCode();
    }

    public static Chal getStatusChal(SyncML msg) {
        ArrayList<AbstractCommand> cmdList = msg.getSyncBody().getCommands();
        if ((cmdList = ProtocolUtil.filterCommands(cmdList.toArray(new AbstractCommand[cmdList.size()]), Status.class, new CmdID("1"))).isEmpty()) {
            return null;
        }
        return ((Status)cmdList.get(0)).getChal();
    }

    public static Object[] sortStatusCommand(Object[] statusToSort) {
        StatusComparator comparator = new StatusComparator();
        Arrays.sort(statusToSort, comparator);
        return statusToSort;
    }

    public static Object[] sortAbstractCommand(Object[] cmdToSort) {
        AbstractCmdComparator comparator = new AbstractCmdComparator();
        Arrays.sort(cmdToSort, comparator);
        return cmdToSort;
    }

    public static Item getLargeObject(AbstractCommand[] commands) {
        int num = commands.length;
        AbstractCommand command = null;
        ArrayList<Item> items = null;
        Iterator<Item> iItems = null;
        Item item2 = null;
        for (int i = 0; i < num; ++i) {
            command = commands[i];
            if (!(command instanceof ItemizedCommand)) continue;
            items = ((ItemizedCommand)command).getItems();
            for (Item item2 : items) {
                if (!item2.isMoreData()) continue;
                return item2;
            }
        }
        return null;
    }

    public static Item getLargeObject(List<AbstractCommand> commands) {
        AbstractCommand command = null;
        ArrayList<Item> items = null;
        Iterator<Item> iItems = null;
        Item item2 = null;
        command = commands.get(commands.size() - 1);
        if (!(command instanceof ItemizedCommand)) {
            return null;
        }
        items = ((ItemizedCommand)command).getItems();
        for (Item item2 : items) {
            if (!item2.isMoreData()) continue;
            return item2;
        }
        return null;
    }

    public static boolean hasLargeObject(AbstractCommand command) {
        if (!(command instanceof ItemizedCommand)) {
            return false;
        }
        ArrayList<Item> items = ((ItemizedCommand)command).getItems();
        Iterator<Item> iItems = items.iterator();
        Item item = null;
        while (iItems.hasNext()) {
            item = iItems.next();
            if (!item.isMoreData()) continue;
            return true;
        }
        return false;
    }

    public static void updateCmdId(List<AbstractCommand> commandsList) {
        ProtocolUtil.updateCmdId(commandsList, 1);
    }

    public static int updateCmdId(List<AbstractCommand> commands, int startId) {
        Iterator<AbstractCommand> iCommand = commands.iterator();
        AbstractCommand command = null;
        int id = startId;
        while (iCommand.hasNext()) {
            command = iCommand.next();
            command.setCmdID(new CmdID(id++));
            if (command instanceof Sync) {
                id = ProtocolUtil.updateCmdId(((Sync)command).getCommands(), id);
                continue;
            }
            if (command instanceof Atomic) {
                id = ProtocolUtil.updateCmdId(((Atomic)command).getCommands(), id);
                continue;
            }
            if (!(command instanceof Sequence)) continue;
            id = ProtocolUtil.updateCmdId(((Sequence)command).getCommands(), id);
        }
        return id;
    }

    private static class AbstractCmdComparator
    implements Comparator {
        private AbstractCmdComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer value1 = null;
            Integer value2 = null;
            value1 = new Integer(((AbstractCommand)o1).getCmdID().getCmdID());
            value2 = new Integer(((AbstractCommand)o2).getCmdID().getCmdID());
            return value1.compareTo(value2);
        }
    }

    private static class StatusComparator
    implements Comparator {
        private StatusComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer value1 = null;
            Integer value2 = null;
            value1 = new Integer(((Status)o1).getCmdRef());
            value2 = new Integer(((Status)o2).getCmdRef());
            return value1.compareTo(value2);
        }
    }
}

