/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.engine;

import com.funambol.framework.engine.SyncItem;
import com.funambol.framework.engine.SyncItemKey;
import com.funambol.framework.engine.SyncProperty;
import com.funambol.framework.engine.source.SyncSource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SyncItemImpl
implements Serializable,
SyncItem {
    protected SyncItemKey key = null;
    protected SyncItemKey mappedKey = null;
    protected char state = (char)32;
    protected HashMap<String, Object> properties = new HashMap();
    protected SyncSource syncSource = null;

    @Override
    public SyncItemKey getKey() {
        return this.key;
    }

    @Override
    public SyncItemKey getMappedKey() {
        return this.mappedKey;
    }

    @Override
    public boolean isMapped() {
        return this.mappedKey != null;
    }

    @Override
    public char getState() {
        return this.state;
    }

    @Override
    public void setState(char state) {
        this.state = state;
    }

    @Override
    public Map<String, Object> getProperties() {
        return (Map)this.properties.clone();
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        Object value = null;
        String name2 = null;
        for (String name2 : properties.keySet()) {
            value = properties.get(name2);
            if (!(value instanceof SyncProperty)) {
                value = new SyncProperty(name2, value.toString());
            }
            this.properties.put(name2, value);
        }
    }

    @Override
    public void setProperty(SyncProperty property) {
        this.properties.put(property.getName(), property);
    }

    @Override
    public SyncProperty getProperty(String propertyName) {
        return (SyncProperty)this.properties.get(propertyName);
    }

    @Override
    public SyncSource getSyncSource() {
        return this.syncSource;
    }

    public void setSyncSource(SyncSource syncSource) {
        if (syncSource == null) {
            throw new NullPointerException("syncSource cannot be null");
        }
        this.syncSource = syncSource;
    }

    protected SyncItemImpl() {
    }

    public SyncItemImpl(SyncSource syncSource, Object key) {
        this(syncSource, key, ' ');
    }

    public SyncItemImpl(SyncSource syncSource, Object key, char state) {
        this(syncSource, key, null, state);
    }

    public SyncItemImpl(SyncSource syncSource, Object key, Object mappedKey, char state) {
        this.syncSource = syncSource;
        this.key = new SyncItemKey(key);
        this.state = state;
        this.mappedKey = mappedKey != null ? new SyncItemKey(mappedKey) : null;
    }

    @Override
    public void setPropertyValue(String propertyName, String propertyValue) {
        SyncProperty property = (SyncProperty)this.properties.get(propertyName);
        if (property != null) {
            property.setValue(propertyValue);
        }
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        SyncProperty property = (SyncProperty)this.properties.get(propertyName);
        return property == null ? null : property.getValue();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyncItem)) {
            return false;
        }
        return ((SyncItem)o).getKey().equals(this.key);
    }

    public static SyncItem getNotExistingSyncItem(SyncSource syncSource) {
        SyncItemImpl notExisting = new SyncItemImpl(syncSource, "NOT_EXISTING");
        notExisting.setState('X');
        return notExisting;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key.toString()).append("state", this.state).append("properties", (Object)this.properties.toString()).toString();
    }
}

