/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol.v11;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.Sync;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.v11.BasicRequirements;
import com.funambol.framework.protocol.v11.Errors;

public class ClientModificationsRequirements
extends BasicRequirements
implements Errors {
    public static void checkSync(Sync cmd) throws ProtocolException {
        try {
            ClientModificationsRequirements.checkCommandId(cmd.getCmdID());
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new ProtocolException("Invalid sync command ({1})", args);
        }
        AbstractCommand[] modifications = cmd.getCommands().toArray(new AbstractCommand[0]);
        for (int i = 0; modifications != null && i < modifications.length; ++i) {
            ClientModificationsRequirements.checkModification((ItemizedCommand)modifications[i]);
        }
    }

    public static void checkModification(ItemizedCommand cmd) throws ProtocolException {
        try {
            ClientModificationsRequirements.checkCommandId(cmd.getCmdID());
            Item[] items = cmd.getItems().toArray(new Item[0]);
            Meta meta = cmd.getMeta();
            boolean checkType = false;
            if (meta.getType() != null) {
                checkType = true;
            }
            for (int i = 0; items != null && i < items.length; ++i) {
                ClientModificationsRequirements.checkModificationItem(items[i], checkType, !cmd.getName().equals("Delete"));
            }
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new ProtocolException("Invalid modification command ({1})", args);
        }
    }

    public static void checkModificationItem(Item item, boolean checkType, boolean checkData) throws ProtocolException {
        Meta meta;
        ClientModificationsRequirements.checkSource(item.getSource());
        if (checkType && (meta = item.getMeta()).getType() == null) {
            Object[] args = new String[]{item.toString()};
            throw new ProtocolException("Missing metadata type in {1}", args);
        }
        if (checkData && item.getData() == null) {
            Object[] args = new String[]{item.toString()};
            throw new ProtocolException("Missing data in {1}", args);
        }
    }
}

