/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.Map;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.ProtocolUtil;
import com.funambol.framework.protocol.SyncPackage;
import com.funambol.framework.protocol.v11.BasicRequirements;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ClientCompletion
extends SyncPackage {
    private static final transient Logger mLog = Logger.getLogger((String)ClientCompletion.class.getName());
    private AbstractCommand[] clientCommands = null;
    private Map[] mapCommands = null;
    private boolean mapCommandFind = false;
    private String lastMessageId = null;

    public AbstractCommand[] getClientCommands() {
        return this.clientCommands;
    }

    public Map[] getMapCommands() {
        return this.mapCommands;
    }

    public boolean isMapCommandFind() {
        return this.mapCommandFind;
    }

    public ClientCompletion(SyncHdr syncHeader, SyncBody syncBody) throws ProtocolException {
        super(syncHeader, syncBody);
        this.checkHeaderRequirements();
        this.checkBodyRequirements();
    }

    @Override
    public void checkHeaderRequirements() throws ProtocolException {
        BasicRequirements.checkDTDVersion(this.syncHeader.getVerDTD());
        BasicRequirements.checkProtocolVersion(this.syncHeader.getVerProto());
        BasicRequirements.checkSessionId(this.syncHeader.getSessionID());
        BasicRequirements.checkMessageId(this.syncHeader.getMsgID());
        BasicRequirements.checkTarget(this.syncHeader.getTarget());
        BasicRequirements.checkSource(this.syncHeader.getSource());
        this.lastMessageId = this.syncHeader.getMsgID();
    }

    @Override
    public void checkBodyRequirements() throws ProtocolException {
        this.clientCommands = this.syncBody.getCommands().toArray(new AbstractCommand[0]);
        this.checkStatusCommands();
        this.checkMapCommand();
    }

    private void checkStatusCommands() {
    }

    private void checkMapCommand() throws ProtocolException {
        ArrayList<AbstractCommand> list = ProtocolUtil.filterCommands(this.clientCommands, Map.class);
        if (list.size() > 0) {
            this.mapCommands = list.toArray(new Map[list.size()]);
            this.mapCommandFind = true;
        } else {
            this.mapCommands = null;
            this.mapCommandFind = false;
        }
    }

    @Override
    public SyncML getResponse(String msgId) throws ProtocolException {
        ArrayList<Status> commands = new ArrayList<Status>();
        Target target = new Target(this.syncHeader.getSource().getLocURI(), this.syncHeader.getSource().getLocName());
        Source source = new Source(this.syncHeader.getTarget().getLocURI(), this.syncHeader.getTarget().getLocName());
        SyncHdr responseHeader = new SyncHdr(this.getDTDVersion(), this.getProtocolVersion(), this.syncHeader.getSessionID(), msgId, target, source, null, false, null, null);
        TargetRef[] targetRefs = new TargetRef[]{new TargetRef(this.syncHeader.getTarget().getLocURI())};
        SourceRef[] sourceRefs = new SourceRef[]{new SourceRef(this.syncHeader.getSource().getLocURI())};
        Status synchdrStatus = new Status(this.idGenerator.next(), this.lastMessageId, "0", "SyncHdr", targetRefs, sourceRefs, null, null, new Data(200L), new Item[0]);
        commands.add(synchdrStatus);
        if (this.mapCommandFind) {
            Status mapStatus = null;
            for (int i = 0; i < this.mapCommands.length; ++i) {
                targetRefs = new TargetRef[]{new TargetRef(this.mapCommands[i].getTarget())};
                sourceRefs = new SourceRef[]{new SourceRef(this.mapCommands[i].getSource())};
                mapStatus = new Status(this.idGenerator.next(), this.lastMessageId, this.mapCommands[i].getCmdID().getCmdID(), Map.COMMAND_NAME, targetRefs, sourceRefs, null, null, new Data(200L), new Item[0]);
                commands.add(mapStatus);
            }
        }
        SyncBody responseBody = new SyncBody(commands.toArray(new AbstractCommand[0]), this.isFlag(3));
        try {
            return new SyncML(responseHeader, responseBody);
        }
        catch (RepresentationException e) {
            throw new ProtocolException("Unexpected error", e);
        }
    }
}

