/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.notification;

import com.funambol.framework.tools.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestNotificationMessage {
    private static final String ALGORITHM_NAME = "MD5";
    private static final String SEPARATOR = ":";
    private String serverId;
    private String serverPw;
    private byte[] nonce;

    public DigestNotificationMessage() {
    }

    public DigestNotificationMessage(String serverId, String serverPw, byte[] nonce) {
        this.setServerId(serverId);
        this.setServerPw(serverPw);
        this.setNonce(nonce);
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerPw() {
        return this.serverPw;
    }

    public void setServerPw(String serverPw) {
        this.serverPw = serverPw;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce == null ? new byte[]{} : nonce;
    }

    public byte[] computeDigestMessage(byte[] triggerMessage) throws NoSuchAlgorithmException {
        String cred = this.serverId + SEPARATOR + this.serverPw;
        MessageDigest md = MessageDigest.getInstance(ALGORITHM_NAME);
        byte[] digestTriggerMessage = null;
        byte[] b64DigestTriggerMessage = null;
        byte[] digestCred = null;
        byte[] b64DigestCred = null;
        byte[] digest = null;
        digestTriggerMessage = md.digest(triggerMessage);
        b64DigestTriggerMessage = Base64.encode(digestTriggerMessage);
        md.reset();
        digestCred = md.digest(cred.getBytes());
        b64DigestCred = Base64.encode(digestCred);
        md.reset();
        byte[] buf = new byte[b64DigestCred.length + 2 + this.nonce.length + b64DigestTriggerMessage.length];
        System.arraycopy(b64DigestCred, 0, buf, 0, b64DigestCred.length);
        buf[b64DigestCred.length] = 58;
        System.arraycopy(this.nonce, 0, buf, b64DigestCred.length + 1, this.nonce.length);
        buf[b64DigestCred.length + this.nonce.length + 1] = 58;
        System.arraycopy(b64DigestTriggerMessage, 0, buf, b64DigestCred.length + this.nonce.length + 2, b64DigestTriggerMessage.length);
        digest = md.digest(buf);
        return digest;
    }
}

