/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.spy.P6PooledConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class P6ProxyConnection
implements Connection {
    private P6PooledConnection pooledConnection = null;
    private Connection connection = null;
    private String stateError = "The (pooled) connection is not valid because it has been closed";

    public P6ProxyConnection(P6PooledConnection pooledConnection, Connection realConnection) throws SQLException {
        this.pooledConnection = pooledConnection;
        this.connection = realConnection;
    }

    public synchronized void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        this.pooledConnection.deliverEvent(1, null);
    }

    public void clearWarnings() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void commit() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.createStatement();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.getCatalog();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.getMetaData();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.getTransactionIsolation();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.getTypeMap();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.getWarnings();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.nativeSQL(sql);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareCall(sql);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void rollback() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.connection == null;
    }

    public void setHoldability(int holdability) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.setHoldability(holdability);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public int getHoldability() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.getHoldability();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.setSavepoint(name);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.connection == null) {
            throw new SQLException(this.stateError);
        }
        try {
            return this.connection.prepareStatement(sql, columnNames);
        }
        catch (SQLException sqlException) {
            this.pooledConnection.deliverEvent(2, sqlException);
            throw sqlException;
        }
    }
}

