
#include <iostream>
#include <ruby.h>
#include <kgmod.h>
#include <kgMessage.h>
//#include <kgCSV.h>
//#include <kgCSVout.h>
//#include <kgruby.h>
//#include <kgcut.h>
//#include <kgcut.h>

using namespace std;
using namespace kglib;
//using namespace kgmod;

extern "C" {
	void Init_lcm(void);
	int LCM_main (const char* args[], int* iRecNo, int* oRecNo, double* topk_weight);
}

/*
 * = Lcm LCM
 *
 * === 書式
 * Lcm.new("f=fields","[-r]","[i=infile]","[o=outfile]")
 *
 * === 引数
 * i= : 入力トランザクションファイル名
 * w= : ウェイトファイル名
 * o= : パターン出力ファイル名
 * t= : トランザクションID-パターンID出力ファイル名
 * K= : 上位K個の頻出パターンを出力する
 * l= : 最小パターン長
 * u= : 最大パターン長
 * s= : 最小サポート
 * S= : 最大サポート
 * g= : アイテム間ギャップ長制限
 * G= : ウィンドウサイズ
 *
 * === 例
 * * Lcm.new("f=顧客CD,日付,金額").run
 *
 * === 参照
 * {mcutコマンドマニュアル}[http://kgmod.jp/mcmd/index.php?mcut]
 *
 */
VALUE lcmFunc(int argc, VALUE *argv, VALUE self) try {
	kgArgs args;
	kgEnv  env;
	string name; // rubyスクリプト名
	string argstr;

	try { // kgmodのエラーはrubyのエラーとは別に検知する(メッセージ表示のため)

		// 引数をopetionsにセット
		VALUE options;
		rb_scan_args(argc, argv,"01",&options);

		// rubyの引数文字列を一旦argstrに退避させてからtoken分割する。
		// 退避させないと、ruby変数としての文字列を変更してしまうことになる。
		if(TYPE(options)==T_NIL){
			argstr="";
		}else if(TYPE(options)==T_STRING){
			argstr=RSTRING_PTR(options);
		}else{
			rb_raise(rb_eRuntimeError,"1st argument must be String");
		}
		vector<char *> opts = splitToken(const_cast<char*>(argstr.c_str()), ' ');

		// 引数文字列へのポインタの領域はここでauto変数に確保する
		kgAutoPtr2<char*> argv;
		char** vv;
		try{
			argv.set(new char*[opts.size()+1]);
			vv = argv.get();
		}catch(...){
			rb_raise(rb_eRuntimeError,"memory allocation error");
		}

		// vv配列0番目はコマンド名
		vv[0]=const_cast<char*>("lcm");

		size_t vvSize;
		for(vvSize=0; vvSize<opts.size(); vvSize++){
			vv[vvSize+1] = opts.at(vvSize);
		}
		vvSize+=1;

		// 引数をセット!!
		args.add(vvSize,const_cast<const char**>(vv));

		// argsに指定した引数の存在チェック
		args.paramcheck("i=,w=,o=,t=,K=,l=,u=,s=,S=,type=,M=",false);
	
		// -----------------------------------------------------
		// 各種引数の設定
		const char* argsAR[20];
		vector<string> argtmp(20); 
		argtmp[0] = args.toString("i=",true );
		argtmp[1] = args.toString("w=",false);
		argtmp[2] = args.toString("o=",false);
		argtmp[3] = args.toString("t=",false);
		argtmp[4] = args.toString("K=",false);
		argtmp[5] = args.toString("l=",false);
		argtmp[6] = args.toString("u=",false);
		argtmp[7] = args.toString("s=",false);
		argtmp[8] = args.toString("S=",false);
		argtmp[9] = args.toString("type=",false);
		argtmp[10] = args.toString("M=",false);
		for(size_t i=0;i<11;i++){
			argsAR[i] = argtmp[i].c_str();		
		}

  	double topk_weight=0;

		// K=が指定された時は、topkのsupport(weight)を求め、再度LCMを実行する。
		if(*argsAR[4]!='\0'){
			char buf[100];
			argsAR[4]="";
			if(topk_weight > atof(argsAR[7])){
				sprintf(buf,"%f",topk_weight);
				argsAR[7]=buf;
			}
		}

  	int iRecNo=0;
  	int oRecNo=0;
		int ret = LCM_main(argsAR, &iRecNo, &oRecNo, &topk_weight);

		return INT2NUM(ret);

	}catch(kgError& err){ // kgmod関係エラーのchatch
		err.addModName(name);
		kgMsg msg(kgMsg::ERR, &env);
		msg.output(err.message());
		throw;
	}

}catch(...){
	rb_raise(rb_eRuntimeError,"Error at lcm()");
}

void Init_lcm(void) {
	// モジュール定義:MCMD::xxxxの部分
	VALUE mcmd=rb_define_module("MCMD");

  rb_define_module_function(mcmd,"lcm" ,
 (VALUE (*)(...))lcmFunc , -1);
}

