#!/usr/bin/env ruby
#/* ////////// LICENSE INFO ////////////////////
#
# * Copyright (C) 2013 by NYSOL CORPORATION
# *
# * Unless you have received this program directly from NYSOL pursuant
# * to the terms of a commercial license agreement with NYSOL, then
# * this program is licensed to you under the terms of the GNU Affero General
# * Public License (AGPL) as published by the Free Software Foundation,
# * either version 3 of the License, or (at your option) any later version.
# * 
# * This program is distributed in the hope that it will be useful, but
# * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
# * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
# *
# * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
# * for more details.
#
# ////////// LICENSE INFO ////////////////////*/

#= MCMD ruby拡張ライブラリ
#Mコマンドruby拡張ライブラリとは、MCMDで提供されている各種データ処理モジュールをrubyから利用できるようにするインターフェースを提供する。
#
#mcmd.rbは、以下の6つのクラスライブラリをrequireしている。
# require "mcsvin"   # MCMD::CSVin   CSVの行単位読み込みクラス (c++で作成された共有ライブラリ)
# require "mcsvout"  # MCMD::CSVout  CSVの出力クラス (c++で作成された共有ライブラリ)
# require "mtable"   # MCMD::Table   CSVのメモリ展開クラス (c++で作成された共有ライブラリ)
# require "margs"    # MCMD::Args    コマンドライン引数を扱うクラス(rubyスクリプト)
# require "mtemp"    # MCMD::Temp    一時ファイル管理(rubyスクリプト)

require "mcsvin"
require "mcsvout"
require "mtable"
require "mmethods"
require "margs"
require "mtemp"
require "fileutils"

$mcmd=true

class Array

	# 並列処理each
	def meach(mpCount=4,&block)
		params=self.dup

		#totalCount=self.size
		count=0 # 何個目のファイルを処理中か
		running=0 # 稼働中のプロセス数
		while params.size>0

			# 配列から引数を１個取り出す。
			param=params.delete_at(0)
			running+=1 # 現在動作中thread数
			count+=1   # 動作スタートトータル数

			# blockの実行
			pid=fork {
				case block.arity
				when 1
					yield(param)
				else
					yield(param,count-1)				
				end
				exit!
			}

			if running >=mpCount then
				begin
					Process.wait
					running-=1
				rescue
					puts "no process found"
					exit
				end
			end
		end

		Process.waitall
	end
end

module MCMD
	def MCMD::errorLog(msg="",fpw=STDERR)
		vbl=ENV["KG_ScpVerboseLevel"]
		if(not vbl or vbl.to_i>=1) then
			fpw.puts "#ERROR# #{msg}; #{Time.now.strftime('%Y/%m/%d %H:%M:%S')}"
		end
	end

	def MCMD::warningLog(msg="",fpw=STDERR)
		vbl=ENV["KG_ScpVerboseLevel"]
		if(not vbl or vbl.to_i>=2) then
			fpw.puts "#WARNING# #{msg}; #{Time.now.strftime('%Y/%m/%d %H:%M:%S')}"
		end
	end

	def MCMD::endLog(msg="",fpw=STDERR)
		vbl=ENV["KG_ScpVerboseLevel"]
		if(not vbl or vbl.to_i>=3) then
			fpw.puts "#END# #{msg}; #{Time.now.strftime('%Y/%m/%d %H:%M:%S')}"
		end
	end

	def MCMD::msgLog(msg="",fpw=STDERR)
		vbl=ENV["KG_ScpVerboseLevel"]
		if(not vbl or vbl.to_i>=4) then
			fpw.puts "#MSG# #{msg}; #{Time.now.strftime('%Y/%m/%d %H:%M:%S')}"
		end
	end

	# ディレクトリの作成
	def MCMD::mkDir(path,rm=false)
		if File.exist?(path)
			if rm
				FileUtils.rm_rf(path) if rm
				FileUtils.mkdir_p(path)
			end
		else
			FileUtils.mkdir_p(path)
		end
	end
end
