/* ////////// LICENSE INFO ////////////////////

 * Copyright (C) 2013 by NYSOL CORPORATION
 *
 * Unless you have received this program directly from NYSOL pursuant
 * to the terms of a commercial license agreement with NYSOL, then
 * this program is licensed to you under the terms of the GNU Affero General
 * Public License (AGPL) as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF 
 * NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please refer to the AGPL (http://www.gnu.org/licenses/agpl-3.0.txt)
 * for more details.

 ////////// LICENSE INFO ////////////////////*/
#pragma once
#include <kgsetversion.h>

using namespace std;

namespace kglib { ////////////////////////////////////////////// namespace start

class kgVersion {
	const char* name_;
	const char* version_;
	const char* revision_;

public:
	kgVersion(void) : name_(KGLIBCODENAME), version_(KGLIBVER), revision_(KGLIBREVISION) {}
	void show(){
		cout << "kgmod " << version_ << "(" << name_ << ") " << "revision " << revision() << endl;
	}
	string name(void){ return name_;}
	string version(void){ return version_;}
	string revision(void){
		string v=revision_;
		string::size_type s1=v.find(' ');
		string::size_type s2=v.find(' ',s1+1);
		string::size_type s3=v.find(' ',s2+1);
		string substr=v.substr(s2+1,s3-s2-1);
		return substr;
	}

};

} //////////////////////////////////////////////////////////////////////////////
