/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommLogListener;
import lejos.pc.comm.NXTCommand;
import lejos.pc.comm.NXTInfo;
import lejos.pc.tools.NXJUploadException;
import lejos.pc.tools.SendFile;
import lejos.pc.tools.ToolsLogListener;

public class Upload {
    private Collection<ToolsLogListener> fLogListeners = new ArrayList<ToolsLogListener>();
    private NXTCommand fNXTCommand = NXTCommand.getSingleton();

    public void upload(String name, String address, int protocols, String fileName, boolean run) throws NXJUploadException {
        NXTInfo[] nxtInfo;
        File f = new File(fileName);
        if (!f.exists()) {
            throw new NXJUploadException(fileName + ": No such file");
        }
        if (f.getName().length() > 20) {
            throw new NXJUploadException(fileName + ": Filename is more than 20 characters");
        }
        if (protocols == 0) {
            protocols = 3;
        }
        if (address != null) {
            try {
                this.fNXTCommand.setNXTCommBlueTooth();
            }
            catch (NXTCommException e) {
                throw new NXJUploadException(e);
            }
            nxtInfo = new NXTInfo[]{new NXTInfo(name == null ? "Unknown" : name, address)};
        } else {
            try {
                nxtInfo = this.fNXTCommand.search(name, protocols);
            }
            catch (Throwable t) {
                throw new NXJUploadException(t);
            }
        }
        boolean connected = false;
        try {
            for (int i = 0; i < nxtInfo.length; ++i) {
                try {
                    connected = this.fNXTCommand.open(nxtInfo[i]);
                }
                catch (NXTCommException e) {
                    connected = false;
                }
                if (!connected) continue;
                String result = SendFile.sendFile(this.fNXTCommand, f);
                for (ToolsLogListener listener : this.fLogListeners) {
                    listener.logEvent(result);
                }
                if (run) {
                    this.fNXTCommand.setVerify(false);
                    this.fNXTCommand.startProgram(f.getName());
                }
                this.fNXTCommand.close();
                break;
            }
        }
        catch (Throwable t) {
            throw new NXJUploadException("Exception during upload", t);
        }
        if (!connected) {
            throw new NXJUploadException("No NXT found - is it switched on and plugged in (for USB)?");
        }
    }

    public void addLogListener(ToolsLogListener listener) {
        this.fLogListeners.add(listener);
        this.fNXTCommand.addLogListener((NXTCommLogListener)listener);
    }

    public void removeLogListener(ToolsLogListener listener) {
        this.fLogListeners.remove(listener);
        this.fNXTCommand.removeLogListener((NXTCommLogListener)listener);
    }
}

