/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTInfo;

public class SocketProxy {
    private String host;
    private int port;
    private DataInputStream inFromNXT;
    private DataOutputStream outToNXT;
    private ServerSocket serverSocket;
    private Socket sock;

    public SocketProxy(String NXTName, String NXTaddress) {
        try {
            NXTComm nxtComm = null;
            try {
                nxtComm = NXTCommFactory.createNXTComm((int)2);
            }
            catch (NXTCommException e) {
                System.err.println("Failed to load comms driver: " + e.getMessage());
                System.exit(1);
            }
            NXTInfo[] nxtInfo = new NXTInfo[]{new NXTInfo(NXTName, NXTaddress)};
            System.out.println("Connecting to " + nxtInfo[0].btResourceString);
            boolean isOpen = false;
            try {
                isOpen = nxtComm.open(nxtInfo[0]);
            }
            catch (NXTCommException n) {
                System.err.println(n.getMessage());
                isOpen = false;
            }
            if (!isOpen) {
                System.out.println("Failed to open " + nxtInfo[0].name);
                System.exit(1);
            }
            this.inFromNXT = new DataInputStream(nxtComm.getInputStream());
            this.outToNXT = new DataOutputStream(nxtComm.getOutputStream());
            boolean isServer = this.inFromNXT.readBoolean();
            if (isServer) {
                this.newSocketServer();
            } else {
                this.newSocketConnection();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void newSocketServer() throws IOException {
        int port = this.inFromNXT.readInt();
        this.serverSocket = new ServerSocket(port);
        boolean cmdMode = true;
        while (cmdMode) {
            byte command = this.inFromNXT.readByte();
            if (command != 1) continue;
            this.waitForConnection();
            cmdMode = false;
        }
    }

    private void waitForConnection() throws IOException {
        while (true) {
            this.sock = this.serverSocket.accept();
            this.outToNXT.writeBoolean(true);
            this.outToNXT.flush();
            DataInputStream inFromSocket = new DataInputStream(this.sock.getInputStream());
            DataOutputStream outToSocket = new DataOutputStream(this.sock.getOutputStream());
            new forward(this.sock, inFromSocket, this.outToNXT);
            new forwardNXT(this.sock, this.inFromNXT, outToSocket);
        }
    }

    private void newSocketConnection() throws UnknownHostException, IOException {
        int len = this.inFromNXT.readByte();
        char[] hostChars = new char[len];
        for (int i = 0; i < len; ++i) {
            hostChars[i] = this.inFromNXT.readChar();
        }
        this.port = this.inFromNXT.readInt();
        this.host = new String(hostChars);
        System.out.println("Host: " + this.host + " port: " + this.port);
        this.sock = new Socket(this.host, this.port);
        this.outToNXT.writeBoolean(true);
        this.outToNXT.flush();
        DataInputStream inFromSocket = new DataInputStream(this.sock.getInputStream());
        DataOutputStream outToSocket = new DataOutputStream(this.sock.getOutputStream());
        new forward(this.sock, inFromSocket, this.outToNXT);
        new forwardNXT(this.sock, this.inFromNXT, outToSocket);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("USAGE: java lejos.pc.tools.SocketProxy <NXTName> <NXTAddress>");
            System.exit(0);
        }
        new SocketProxy(args[0], args[1]);
    }

    private class forwardNXT
    extends Thread {
        private DataOutputStream dout;
        private DataInputStream din;
        private Socket sock;

        public forwardNXT(Socket sock, DataInputStream dis, DataOutputStream dos) {
            this.din = dis;
            this.dout = dos;
            this.sock = sock;
            this.start();
        }

        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        int in;
                        if ((in = this.din.readUnsignedByte()) < 0) {
                            System.out.println("In Thread: Socket closed:" + in);
                            this.sock.close();
                            return;
                        }
                        if (in != 0) {
                            this.dout.writeByte(in);
                            this.dout.flush();
                        }
                        try {
                            Thread.sleep(10L);
                            Thread.yield();
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
            }
        }
    }

    private class forward
    extends Thread {
        private DataOutputStream dout;
        private DataInputStream din;
        private Socket sock;

        public forward(Socket sock, DataInputStream dis, DataOutputStream dos) {
            this.din = dis;
            this.dout = dos;
            this.sock = sock;
            this.start();
        }

        public void run() {
            try {
                boolean flushed = true;
                while (true) {
                    int a;
                    if ((a = this.din.available()) > 0) {
                        flushed = false;
                        int in = this.din.readUnsignedByte();
                        if (in < 0) {
                            this.sock.close();
                            return;
                        }
                        this.dout.writeByte(in);
                    } else if (!flushed) {
                        this.dout.flush();
                        flushed = true;
                    }
                    try {
                        Thread.sleep(100L);
                        Thread.yield();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }
    }
}

