/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import lejos.pc.tools.Connector;

public class ConsoleViewer
extends JFrame
implements ActionListener {
    private JButton startButton = new JButton("Connect");
    private JToggleButton usbButton = new JToggleButton("USE BlueTooth");
    private TextField statusField = new TextField(20);
    private TextField nameField = new TextField(12);
    private String _nxt = "NXT";
    private boolean _useUSB = true;
    private InputStream is = null;
    private DataInputStream dataIn = null;
    private OutputStream os = null;
    private Connector con;
    private boolean _connected = false;
    private TextArea theLog;

    public ConsoleViewer() {
        this.setDefaultCloseOperation(3);
        this.setTitle("View RConsole output from NXT");
        this.setSize(500, 600);
        JPanel p1 = new JPanel();
        p1.add(this.usbButton);
        this.usbButton.addActionListener(this);
        p1.add(new JLabel("name or address"));
        p1.add(this.nameField);
        this.startButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.add(this.startButton);
        p2.add(new JLabel("  Status:"));
        p2.add(this.statusField);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(p1);
        panel.add(p2);
        this.add((Component)panel, "North");
        this.theLog = new TextArea(40, 40);
        this.getContentPane().add((Component)this.theLog, "Center");
        this.statusField.setText("using USB");
        Reader reader = new Reader();
        reader.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startButton) {
            this._nxt = this.nameField.getText();
            this.startDownload();
        }
        if (e.getSource() == this.usbButton) {
            boolean bl = this._useUSB = !this._useUSB;
            if (this._useUSB) {
                this.setMessage("using USB");
            } else {
                this.setMessage("using Bluetooth");
            }
        }
    }

    public static void main(String[] args) {
        ConsoleViewer frame = new ConsoleViewer();
        frame.setVisible(true);
    }

    private void connect() {
        this._nxt = this.nameField.getText();
        this.setMessage("Connecting");
        this.con = new Connector();
        if (!this.con.connectTo(this._nxt, this._useUSB)) {
            System.exit(1);
        }
        this.is = this.con.getInputStream();
        this._connected = true;
    }

    private void startDownload() {
        if (!this._connected) {
            this.connect();
        }
        this.os = this.con.getOutputStream();
        try {
            byte[] hello = new byte[]{67, 79, 78};
            this.os.write(hello);
            this.os.flush();
        }
        catch (IOException e) {
            System.out.println(e + " write ");
        }
        this._connected = true;
        this.setMessage("ready for data");
    }

    public void setMessage(String s) {
        this.statusField.setText(s);
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        public void run() {
            while (true) {
                if (ConsoleViewer.this._connected) {
                    try {
                        int input;
                        while ((input = ConsoleViewer.this.is.read()) >= 0) {
                            ConsoleViewer.this.theLog.append("" + (char)input);
                        }
                        ConsoleViewer.this.is.close();
                    }
                    catch (IOException e) {
                        System.out.println("read error");
                    }
                }
                Thread.yield();
            }
        }
    }
}

