/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTInfo;

public class Connector {
    DataInputStream dataIn;
    DataOutputStream dataOut;
    InputStream is;
    OutputStream os;
    NXTInfo[] _nxtInfo;

    public boolean connectTo(String NXT, boolean useUSB) {
        NXTComm nxtComm = null;
        if (useUSB) {
            try {
                nxtComm = NXTCommFactory.createNXTComm((int)1);
            }
            catch (Exception e) {
                // empty catch block
            }
            NXTInfo[] nxtInfo = null;
            try {
                nxtInfo = nxtComm.search(null, 1);
            }
            catch (NXTCommException e) {
                System.out.println("Exception in search");
            }
            if (nxtInfo.length == 0) {
                System.out.println("No NXT Found");
                System.exit(1);
            }
            try {
                nxtComm.open(nxtInfo[0]);
            }
            catch (NXTCommException e) {
                System.out.println("Exception in open");
            }
            System.out.println("Opened USB connection");
        } else {
            try {
                nxtComm = NXTCommFactory.createNXTComm((int)2);
            }
            catch (NXTCommException e) {
                System.err.println("Failed to load Bluetooth comms driver: " + e.getMessage());
                System.exit(1);
            }
            if (NXT == null || NXT == " " || NXT.length() < 1) {
                System.out.println("searching for all");
                try {
                    this._nxtInfo = nxtComm.search(null, 2);
                }
                catch (NXTCommException ex) {
                    System.out.println("search Failed " + (Object)((Object)ex));
                }
            } else if (NXT.length() < 8) {
                System.out.println("searching for " + NXT);
                try {
                    this._nxtInfo = nxtComm.search(NXT, 2);
                }
                catch (Exception ex) {
                    System.out.println("search Failed " + ex);
                }
            } else {
                this._nxtInfo = new NXTInfo[1];
                this._nxtInfo[0] = new NXTInfo("unknown ", NXT);
            }
            if (this._nxtInfo == null || this._nxtInfo.length == 0) {
                System.out.println("NXT " + NXT + " not found: is BT adaper on? is NXT on? ");
                return false;
            }
            System.out.println("Connecting to " + this._nxtInfo[0].name + " " + this._nxtInfo[0].btDeviceAddress);
            boolean opened = false;
            try {
                opened = nxtComm.open(this._nxtInfo[0]);
            }
            catch (NXTCommException ex) {
                System.out.println((Object)ex);
            }
            if (!opened) {
                System.out.println("Failed to open " + this._nxtInfo[0].name + " " + this._nxtInfo[0].btDeviceAddress);
                return false;
            }
            System.out.println("Connected to " + this._nxtInfo[0].name);
        }
        this.is = nxtComm.getInputStream();
        this.dataIn = new DataInputStream(nxtComm.getInputStream());
        this.os = nxtComm.getOutputStream();
        this.dataOut = new DataOutputStream(this.os);
        return true;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public DataInputStream getDataIn() {
        return this.dataIn;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public DataOutputStream getDataOut() {
        return this.dataOut;
    }

    public NXTInfo[] getNXTInfo() {
        return this._nxtInfo;
    }

    public boolean startConnector(String NXT, boolean useUSB) {
        return this.connectTo(NXT, useUSB);
    }
}

