/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperationDelivery;
import com.intel.bluetooth.obex.OBEXOperationOutputStream;
import com.intel.bluetooth.obex.OBEXServerOperation;
import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.UnsupportedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;

class OBEXServerOperationGet
extends OBEXServerOperation
implements OBEXOperationDelivery {
    protected OBEXOperationOutputStream os;

    protected OBEXServerOperationGet(OBEXServerSessionImpl session, HeaderSet receivedHeaders) {
        super(session, receivedHeaders);
    }

    public InputStream openInputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        return new UnsupportedInputStream();
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        if (this.os != null) {
            throw new IOException("output still open");
        }
        this.os = new OBEXOperationOutputStream(this.session.mtu, this);
        this.session.writeOperation(144, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
        return this.os;
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
            this.os = null;
        }
        super.close();
    }

    public void deliverPacket(boolean finalPacket, byte[] buffer) throws IOException {
        byte[] b = this.session.readOperation();
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
        switch (requestHeaders.getResponseCode()) {
            case 131: {
                this.finalPacketReceived = true;
                this.replyWithPacket(finalPacket, buffer);
                break;
            }
            case 255: {
                this.processAbort();
                break;
            }
            default: {
                this.session.writeOperation(211, null);
            }
        }
    }

    private void processAbort() throws IOException {
        this.finalPacketReceived = true;
    }

    private void replyWithPacket(boolean finalPacket, byte[] buffer) throws IOException {
        byte[] b;
        OBEXHeaderSetImpl requestHeaders;
        HeaderSet dataHeaders = OBEXSessionBase.createOBEXHeaderSet();
        dataHeaders.setHeader(72, buffer);
        this.session.writeOperation(144, OBEXHeaderSetImpl.toByteArray(dataHeaders));
        if (finalPacket && (requestHeaders = OBEXHeaderSetImpl.readHeaders((b = this.session.readOperation())[0], b, 3)).getResponseCode() != 131) {
            throw new IOException("wrong final request");
        }
    }

    void writeResponse(int responseCode) throws IOException {
        this.session.writeOperation(responseCode, OBEXHeaderSetImpl.toByteArray(this.sendHeaders));
    }
}

