/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothConsts;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.BluetoothStackWIDCOMMSDPInputStream;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.DiscoveryListenerAdapter;
import com.intel.bluetooth.NativeLibLoader;
import com.intel.bluetooth.NotSupportedRuntimeException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SDPOutputStream;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesTerminatedException;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackWIDCOMM
implements BluetoothStack,
DeviceInquiryRunnable,
SearchServicesRunnable {
    private boolean initialized = false;
    private Vector deviceDiscoveryListeners = new Vector();
    private Hashtable deviceDiscoveryListenerReportedDevices = new Hashtable();
    private static final int ATTR_RETRIEVABLE_MAX = 256;
    private static final int RECEIVE_MTU_MAX = 1024;
    static final short NULL_DESC_TYPE = 0;
    static final short UINT_DESC_TYPE = 1;
    static final short TWO_COMP_INT_DESC_TYPE = 2;
    static final short UUID_DESC_TYPE = 3;
    static final short TEXT_STR_DESC_TYPE = 4;
    static final short BOOLEAN_DESC_TYPE = 5;
    static final short DATA_ELE_SEQ_DESC_TYPE = 6;
    static final short DATA_ELE_ALT_DESC_TYPE = 7;
    static final short URL_DESC_TYPE = 8;
    static /* synthetic */ Class class$com$intel$bluetooth$BluetoothStackWIDCOMM;

    BluetoothStackWIDCOMM() {
    }

    public String getStackID() {
        return "widcomm";
    }

    public int getFeatureSet() {
        return 3;
    }

    public native int getLibraryVersion();

    public native int detectBluetoothStack();

    public native void enableNativeDebug(Class var1, boolean var2);

    public void initialize() {
        if (!this.initializeImpl()) {
            throw new RuntimeException("WIDCOMM BluetoothStack not found");
        }
        this.initialized = true;
    }

    public native boolean initializeImpl();

    private native void uninitialize();

    public void destroy() {
        if (this.initialized) {
            this.uninitialize();
            this.initialized = false;
            DebugLog.debug("WIDCOMM destroyed");
        }
    }

    protected void finalize() {
        this.destroy();
    }

    public native String getLocalDeviceBluetoothAddress() throws BluetoothStateException;

    public native String getLocalDeviceName();

    private native int getDeviceClassImpl();

    public DeviceClass getLocalDeviceClass() {
        return new DeviceClass(this.getDeviceClassImpl());
    }

    public void setLocalDeviceServiceClasses(int classOfDevice) {
        throw new NotSupportedRuntimeException(this.getStackID());
    }

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        int curentMode = this.getLocalDeviceDiscoverable();
        return curentMode == mode;
    }

    private native boolean isStackServerUp();

    private void verifyDeviceReady() throws BluetoothStateException {
        if (!this.isLocalDevicePowerOn()) {
            throw new BluetoothStateException("Bluetooth Device is not ready");
        }
    }

    public native boolean isLocalDeviceDiscoverable();

    public int getLocalDeviceDiscoverable() {
        if (this.isStackServerUp() && this.isLocalDeviceDiscoverable()) {
            return 10390323;
        }
        return 0;
    }

    public native boolean isLocalDevicePowerOn();

    private native String getBTWVersionInfo();

    private native int getDeviceVersion();

    private native int getDeviceManufacturer();

    public String getLocalDeviceProperty(String property) {
        String TRUE = "true";
        String FALSE = "false";
        if ("bluetooth.connected.devices.max".equals(property)) {
            return "7";
        }
        if ("bluetooth.sd.trans.max".equals(property)) {
            return "1";
        }
        if ("bluetooth.connected.inquiry.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.inquiry".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page".equals(property)) {
            return "true";
        }
        if ("bluetooth.sd.attr.retrievable.max".equals(property)) {
            return String.valueOf(256);
        }
        if ("bluetooth.master.switch".equals(property)) {
            return "false";
        }
        if ("bluetooth.l2cap.receiveMTU.max".equals(property)) {
            return String.valueOf(1024);
        }
        if ("bluecove.radio.version".equals(property)) {
            return String.valueOf(this.getDeviceVersion());
        }
        if ("bluecove.radio.manufacturer".equals(property)) {
            return String.valueOf(this.getDeviceManufacturer());
        }
        if ("bluecove.stack.version".equals(property)) {
            return this.getBTWVersionInfo();
        }
        return null;
    }

    public boolean isCurrentThreadInterruptedCallback() {
        return Thread.interrupted();
    }

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        this.deviceDiscoveryListeners.addElement(listener);
        this.deviceDiscoveryListenerReportedDevices.put(listener, new Vector());
        return DeviceInquiryThread.startInquiry(this, accessCode, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        try {
            int n = this.runDeviceInquiryImpl(startedNotify, accessCode, listener);
            return n;
        }
        finally {
            this.deviceDiscoveryListeners.removeElement(listener);
            this.deviceDiscoveryListenerReportedDevices.remove(listener);
        }
    }

    public native int runDeviceInquiryImpl(DeviceInquiryThread var1, int var2, DiscoveryListener var3) throws BluetoothStateException;

    public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
        DebugLog.debug("deviceDiscoveredCallback deviceName", deviceName);
        if (!this.deviceDiscoveryListeners.contains(listener)) {
            return;
        }
        RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(this, deviceAddr, deviceName, paired);
        Vector reported = (Vector)this.deviceDiscoveryListenerReportedDevices.get(listener);
        if (reported == null || reported.contains(remoteDevice)) {
            return;
        }
        reported.addElement(remoteDevice);
        DeviceClass cod = new DeviceClass(deviceClass);
        DebugLog.debug("deviceDiscoveredCallback address", remoteDevice.getBluetoothAddress());
        DebugLog.debug("deviceDiscoveredCallback deviceClass", cod);
        listener.deviceDiscovered(remoteDevice, cod);
    }

    private native boolean deviceInquiryCancelImpl();

    public boolean cancelInquiry(DiscoveryListener listener) {
        if (!this.deviceDiscoveryListeners.removeElement(listener)) {
            return false;
        }
        return this.deviceInquiryCancelImpl();
    }

    native String getRemoteDeviceFriendlyName(long var1, int var3, int var4) throws IOException;

    native String peekRemoteDeviceFriendlyName(long var1);

    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        if (this.deviceDiscoveryListeners.size() != 0) {
            return this.peekRemoteDeviceFriendlyName(address);
        }
        DiscoveryListenerAdapter listener = new DiscoveryListenerAdapter();
        if (this.startInquiry(10390323, listener)) {
            String name = this.peekRemoteDeviceFriendlyName(address);
            this.cancelInquiry(listener);
            return name;
        }
        return null;
    }

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        return SearchServicesThread.startSearchServices(this, attrSet, uuidSet, device, listener);
    }

    private native void cancelServiceSearchImpl();

    public boolean cancelServiceSearch(int transID) {
        SearchServicesThread sst = SearchServicesThread.getServiceSearchThread(transID);
        if (sst != null) {
            sst.setTerminated();
            this.cancelServiceSearchImpl();
            return true;
        }
        return false;
    }

    private native long[] runSearchServicesImpl(SearchServicesThread var1, byte[] var2, long var3) throws BluetoothStateException, SearchServicesTerminatedException;

    private native byte[] getServiceAttribute(int var1, long var2) throws IOException;

    private native boolean isServiceRecordDiscoverable(long var1, long var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runSearchServices(SearchServicesThread startedNotify, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        Class clazz = class$com$intel$bluetooth$BluetoothStackWIDCOMM == null ? (class$com$intel$bluetooth$BluetoothStackWIDCOMM = BluetoothStackWIDCOMM.class$("com.intel.bluetooth.BluetoothStackWIDCOMM")) : class$com$intel$bluetooth$BluetoothStackWIDCOMM;
        synchronized (clazz) {
            long[] handles;
            byte[] uuidValue = Utils.UUIDToByteArray(BluetoothConsts.L2CAP_PROTOCOL_UUID);
            try {
                handles = this.runSearchServicesImpl(startedNotify, uuidValue, RemoteDeviceHelper.getAddress(device));
            }
            catch (SearchServicesTerminatedException e) {
                DebugLog.debug("SERVICE_SEARCH_TERMINATED");
                return 2;
            }
            if (handles == null) {
                DebugLog.debug("SERVICE_SEARCH_ERROR");
                return 3;
            }
            if (handles.length > 0) {
                boolean reqRFCOMM = false;
                UUID uuidFiler = null;
                for (int u = 0; u < uuidSet.length; ++u) {
                    if (uuidSet[u].equals(BluetoothConsts.L2CAP_PROTOCOL_UUID)) continue;
                    if (uuidSet[u].equals(BluetoothConsts.RFCOMM_PROTOCOL_UUID)) {
                        reqRFCOMM = true;
                        continue;
                    }
                    uuidFiler = uuidSet[u];
                    break;
                }
                if (uuidFiler == null && reqRFCOMM) {
                    uuidFiler = BluetoothConsts.RFCOMM_PROTOCOL_UUID;
                }
                Vector<ServiceRecordImpl> records = new Vector<ServiceRecordImpl>();
                int[] uuidFilerAttrIDs = new int[]{1, 4};
                int[] requiredAttrIDs = new int[]{0, 2, 3};
                for (int i = 0; i < handles.length; ++i) {
                    ServiceRecordImpl sr = new ServiceRecordImpl(this, device, handles[i]);
                    try {
                        sr.populateRecord(uuidFilerAttrIDs);
                        if (uuidFiler != null && !sr.hasServiceClassUUID(uuidFiler) && !sr.hasProtocolClassUUID(uuidFiler) || !this.isServiceRecordDiscoverable(RemoteDeviceHelper.getAddress(device), sr.getHandle())) continue;
                        records.addElement(sr);
                        sr.populateRecord(requiredAttrIDs);
                        if (attrSet != null) {
                            sr.populateRecord(attrSet);
                        }
                        DebugLog.debug("ServiceRecord (" + i + ") sr.handle", handles[i]);
                        DebugLog.debug("ServiceRecord (" + i + ")", sr);
                    }
                    catch (Exception e) {
                        DebugLog.debug("populateRecord error", e);
                    }
                    if (!startedNotify.isTerminated()) continue;
                    DebugLog.debug("SERVICE_SEARCH_TERMINATED");
                    return 2;
                }
                if (records.size() != 0) {
                    DebugLog.debug("SERVICE_SEARCH_COMPLETED");
                    ServiceRecord[] fileteredRecords = (ServiceRecord[])Utils.vector2toArray(records, new ServiceRecord[records.size()]);
                    listener.servicesDiscovered(startedNotify.getTransID(), fileteredRecords);
                    return 1;
                }
            }
            DebugLog.debug("SERVICE_SEARCH_NO_RECORDS");
            return 4;
        }
    }

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        if (attrIDs.length > 256) {
            throw new IllegalArgumentException();
        }
        boolean anyRetrived = false;
        for (int i = 0; i < attrIDs.length; ++i) {
            int id = attrIDs[i];
            try {
                DataElement protocolElement;
                Enumeration protocolsSeqEnum;
                byte[] sdpStruct = this.getServiceAttribute(id, serviceRecord.getHandle());
                if (sdpStruct == null) continue;
                DataElement element = new BluetoothStackWIDCOMMSDPInputStream(new ByteArrayInputStream(sdpStruct)).readElement();
                if (id == 4 && (protocolsSeqEnum = (Enumeration)element.getValue()).hasMoreElements() && (protocolElement = (DataElement)protocolsSeqEnum.nextElement()).getDataType() != 48) {
                    DataElement newMainSeq = new DataElement(48);
                    newMainSeq.addElement(element);
                    element = newMainSeq;
                }
                serviceRecord.populateAttributeValue(id, element);
                anyRetrived = true;
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return anyRetrived;
    }

    private native long connectionRfOpenClientConnectionImpl(long var1, int var3, boolean var4, boolean var5, int var6) throws IOException;

    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        this.verifyDeviceReady();
        return this.connectionRfOpenClientConnectionImpl(params.address, params.channel, params.authenticate, params.encrypt, params.timeout);
    }

    private native void closeRfCommPortImpl(long var1) throws IOException;

    public void connectionRfCloseClientConnection(long handle) throws IOException {
        this.closeRfCommPortImpl(handle);
    }

    public native long getConnectionRfRemoteAddress(long var1) throws IOException;

    public native int connectionRfRead(long var1) throws IOException;

    public native int connectionRfRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native int connectionRfReadAvailable(long var1) throws IOException;

    public native void connectionRfWrite(long var1, int var3) throws IOException;

    public native void connectionRfWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void connectionRfFlush(long handle) throws IOException {
    }

    public int getSecurityOpt(long handle, int expected) throws IOException {
        return expected;
    }

    private native long rfServerOpenImpl(byte[] var1, byte[] var2, boolean var3, String var4, boolean var5, boolean var6) throws IOException;

    private native int rfServerSCN(long var1) throws IOException;

    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        this.verifyDeviceReady();
        byte[] uuidValue = Utils.UUIDToByteArray(params.uuid);
        byte[] uuidValue2 = params.obex ? null : Utils.UUIDToByteArray(BluetoothConsts.SERIAL_PORT_UUID);
        long handle = this.rfServerOpenImpl(uuidValue, uuidValue2, params.obex, params.name, params.authenticate, params.encrypt);
        int channel = this.rfServerSCN(handle);
        DebugLog.debug("serverSCN", channel);
        long serviceRecordHandle = handle;
        serviceRecord.populateRFCOMMAttributes(serviceRecordHandle, channel, params.uuid, params.name, params.obex);
        return handle;
    }

    private native void sdpServiceAddAttribute(long var1, char var3, int var4, short var5, byte[] var6) throws ServiceRegistrationException;

    private byte[] long2byte(long value, int len) {
        byte[] cvalue = new byte[len];
        long l = value;
        for (int i = len - 1; i >= 0; --i) {
            cvalue[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return cvalue;
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.sdpServiceUpdateServiceRecord(handle, 'r', serviceRecord);
    }

    private byte[] sdpServiceSequenceAttribute(Enumeration en) throws ServiceRegistrationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SDPOutputStream sdpOut = new SDPOutputStream(out);
        try {
            while (en.hasMoreElements()) {
                sdpOut.writeElement((DataElement)en.nextElement());
            }
        }
        catch (IOException e) {
            throw new ServiceRegistrationException(e.getMessage());
        }
        return out.toByteArray();
    }

    private void sdpServiceUpdateServiceRecord(long handle, char handleType, ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        int[] ids = serviceRecord.getAttributeIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        block21: for (int i = 0; i < ids.length; ++i) {
            int id = ids[i];
            switch (id) {
                case 0: 
                case 1: 
                case 4: 
                case 256: {
                    continue block21;
                }
                default: {
                    DataElement d = serviceRecord.getAttributeValue(id);
                    switch (d.getDataType()) {
                        case 8: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)1, this.long2byte(d.getLong(), 1));
                            continue block21;
                        }
                        case 9: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)1, this.long2byte(d.getLong(), 2));
                            continue block21;
                        }
                        case 10: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)1, this.long2byte(d.getLong(), 4));
                            continue block21;
                        }
                        case 11: 
                        case 12: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)1, (byte[])d.getValue());
                            continue block21;
                        }
                        case 16: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)2, this.long2byte(d.getLong(), 1));
                            continue block21;
                        }
                        case 17: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)2, this.long2byte(d.getLong(), 2));
                            continue block21;
                        }
                        case 18: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)2, this.long2byte(d.getLong(), 4));
                            continue block21;
                        }
                        case 19: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)2, this.long2byte(d.getLong(), 8));
                            continue block21;
                        }
                        case 20: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)2, (byte[])d.getValue());
                            continue block21;
                        }
                        case 64: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)8, Utils.getASCIIBytes(d.getValue().toString()));
                            continue block21;
                        }
                        case 32: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)4, Utils.getUTF8Bytes(d.getValue().toString()));
                            continue block21;
                        }
                        case 0: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)0, null);
                            continue block21;
                        }
                        case 40: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)5, new byte[]{(byte)(d.getBoolean() ? 1 : 0)});
                            continue block21;
                        }
                        case 24: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)3, BluetoothStackWIDCOMMSDPInputStream.getUUIDHexBytes((UUID)d.getValue()));
                            continue block21;
                        }
                        case 48: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)6, this.sdpServiceSequenceAttribute((Enumeration)d.getValue()));
                            continue block21;
                        }
                        case 56: {
                            this.sdpServiceAddAttribute(handle, handleType, id, (short)7, this.sdpServiceSequenceAttribute((Enumeration)d.getValue()));
                            continue block21;
                        }
                    }
                    throw new ServiceRegistrationException("Invalid " + d.getDataType());
                }
            }
        }
    }

    public native long rfServerAcceptAndOpenRfServerConnection(long var1) throws IOException;

    public native void connectionRfCloseServerConnection(long var1) throws IOException;

    private native void rfServerCloseImpl(long var1) throws IOException;

    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        this.rfServerCloseImpl(handle);
    }

    private void validateMTU(int receiveMTU, int transmitMTU) {
        if (receiveMTU > 1024) {
            throw new IllegalArgumentException("invalid ReceiveMTU value " + receiveMTU);
        }
    }

    private native long l2OpenClientConnectionImpl(long var1, int var3, boolean var4, boolean var5, int var6, int var7, int var8) throws IOException;

    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        this.verifyDeviceReady();
        this.validateMTU(receiveMTU, transmitMTU);
        return this.l2OpenClientConnectionImpl(params.address, params.channel, params.authenticate, params.encrypt, receiveMTU, transmitMTU, params.timeout);
    }

    public native void l2CloseClientConnection(long var1) throws IOException;

    private native long l2ServerOpenImpl(byte[] var1, boolean var2, boolean var3, String var4, int var5, int var6, int var7) throws IOException;

    public native int l2ServerPSM(long var1) throws IOException;

    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        this.verifyDeviceReady();
        this.validateMTU(receiveMTU, transmitMTU);
        byte[] uuidValue = Utils.UUIDToByteArray(params.uuid);
        long handle = this.l2ServerOpenImpl(uuidValue, params.authenticate, params.encrypt, params.name, receiveMTU, transmitMTU, params.bluecove_ext_psm);
        int channel = this.l2ServerPSM(handle);
        int serviceRecordHandle = (int)handle;
        serviceRecord.populateL2CAPAttributes(serviceRecordHandle, channel, params.uuid, params.name);
        return handle;
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.sdpServiceUpdateServiceRecord(handle, 'l', serviceRecord);
    }

    public native long l2ServerAcceptAndOpenServerConnection(long var1) throws IOException;

    public native void l2CloseServerConnection(long var1) throws IOException;

    private native void l2ServerCloseImpl(long var1) throws IOException;

    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        this.l2ServerCloseImpl(handle);
    }

    public native int l2GetReceiveMTU(long var1) throws IOException;

    public native int l2GetTransmitMTU(long var1) throws IOException;

    public native boolean l2Ready(long var1) throws IOException;

    public native int l2Receive(long var1, byte[] var3) throws IOException;

    public native void l2Send(long var1, byte[] var3) throws IOException;

    public native long l2RemoteAddress(long var1) throws IOException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NativeLibLoader.isAvailable("bluecove");
    }
}

