/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.SystemSettings;
import lejos.nxt.comm.USBConnection;

public class USB {
    public static final int RESET = 0x40000000;
    public static final int RAW = 0x20000000;
    public static final String SERIAL_NO = "lejos.usb_serno";
    public static final String NAME = "lejos.usb_name";
    static final int USB_BUFSZ = 64;
    static final int USB_STREAM = 1;
    private static String serialNo;
    private static String name;

    private USB() {
    }

    private static void flushInput() {
        byte[] buf = new byte[64];
        while (USB.usbRead(buf, 0, buf.length) > 0) {
        }
    }

    public static USBConnection waitForConnection(int timeout, int mode) {
        USB.usbEnable((mode & 0x40000000) != 0 ? 1 : 0);
        mode &= 0xBFFFFFFF;
        USB.flushInput();
        if (timeout == 0) {
            timeout = Integer.MAX_VALUE;
        }
        int features = 0;
        if ((mode & 0x20000000) == 0) {
            features = 1;
        }
        while (timeout-- > 0) {
            int status = USB.usbStatus();
            if ((status & 0xF0000000) == 0x10000000 && (status & 0xF000000) != 0 && (status & features) == features) {
                return new USBConnection(mode);
            }
            if (timeout != 0 && timeout-- <= 0) continue;
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {}
        }
        USB.usbDisable();
        return null;
    }

    public static USBConnection waitForConnection() {
        return USB.waitForConnection(0, 0);
    }

    public static void waitForDisconnect(int timeout) {
        int status;
        USB.flushInput();
        while (timeout-- > 0 && ((status = USB.usbStatus()) & 0xF0000000) == 0x10000000 && (status & 0xF000000) != 0 && (status & 0xFFFF) != 0) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        USB.usbDisable();
    }

    public static void setSerialNo(String sn) {
        serialNo = sn;
        USB.usbSetSerialNo(sn);
    }

    public static String getSerialNo() {
        return serialNo;
    }

    public static void setName(String nam) {
        name = nam;
        USB.usbSetName(nam);
    }

    public static String getName() {
        return name;
    }

    public static void loadSettings() {
        USB.setSerialNo(SystemSettings.getStringSetting(SERIAL_NO, "123456780090"));
        USB.setSerialNo(SystemSettings.getStringSetting(NAME, "nxt"));
    }

    public static native void usbEnable(int var0);

    public static native void usbDisable();

    public static native void usbReset();

    public static native int usbRead(byte[] var0, int var1, int var2);

    public static native int usbWrite(byte[] var0, int var1, int var2);

    public static native int usbStatus();

    public static native void usbSetSerialNo(String var0);

    public static native void usbSetName(String var0);

    static {
        USB.loadSettings();
    }
}

