/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.IOException;
import lejos.nxt.comm.DeviceInfo;
import lejos.nxt.comm.FirmwareInfo;
import lejos.nxt.comm.InputValues;
import lejos.nxt.comm.NXTComm;
import lejos.nxt.comm.NXTProtocol;

public class NXTCommand
implements NXTProtocol {
    private NXTComm nxtComm = new NXTComm();
    private boolean verifyCommand = false;
    private static final char[] cs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void open(String name) throws IOException {
        boolean open = this.nxtComm.open(name);
        if (!open) {
            throw new IOException("Open failed");
        }
    }

    private byte sendRequest(byte[] request) throws IOException {
        byte verify = 0;
        if (this.verifyCommand) {
            request[0] = 0;
        }
        this.nxtComm.sendData(request);
        if (this.verifyCommand) {
            byte[] reply = this.nxtComm.readData();
            verify = reply[2];
        }
        return verify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte setOutputState(int port, byte power, int mode, int regulationMode, int turnRatio, int runState, int tachoLimit) throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{-128, 4, (byte)port, power, (byte)mode, (byte)regulationMode, (byte)turnRatio, (byte)runState, (byte)tachoLimit, (byte)(tachoLimit >>> 8), (byte)(tachoLimit >>> 16), (byte)(tachoLimit >>> 24)};
            return this.sendRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTachoCount(int port) throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{0, 6, (byte)port};
            this.nxtComm.sendData(request);
            byte[] reply = this.nxtComm.readData();
            int tachoCount = 0xFF & reply[13] | (0xFF & reply[14]) << 8 | (0xFF & reply[15]) << 16 | (0xFF & reply[16]) << 24;
            return tachoCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte resetMotorPosition(int port, boolean relative) throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte boolVal = 0;
            if (relative) {
                boolVal = -1;
            }
            byte[] request = new byte[]{-128, 10, (byte)port, boolVal};
            return this.sendRequest(request);
        }
    }

    public void setVerify(boolean verify) {
        this.verifyCommand = verify;
    }

    public void close() throws IOException {
        this.nxtComm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBatteryLevel() throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{0, 11};
            this.nxtComm.sendData(request);
            byte[] reply = this.nxtComm.readData();
            int batteryLevel = 0xFF & reply[3] | (0xFF & reply[4]) << 8;
            return batteryLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputValues getInputValues(int port) throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{0, 7, (byte)port};
            this.nxtComm.sendData(request);
            byte[] reply = this.nxtComm.readData();
            InputValues inputValues = new InputValues();
            inputValues.inputPort = reply[3];
            inputValues.valid = reply[4] != 0;
            inputValues.isCalibrated = reply[5] == 0;
            inputValues.sensorType = reply[6];
            inputValues.sensorMode = reply[7];
            inputValues.rawADValue = 0xFF & reply[8] | (0xFF & reply[9]) << 8;
            inputValues.normalizedADValue = 0xFF & reply[10] | (0xFF & reply[11]) << 8;
            inputValues.scaledValue = (short)(0xFF & reply[12] | reply[13] << 8);
            inputValues.calibratedValue = (short)(0xFF & reply[14] | reply[15] << 8);
            return inputValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte setInputMode(int port, int sensorType, int sensorMode) throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{-128, 5, (byte)port, (byte)sensorType, (byte)sensorMode};
            return this.sendRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte playTone(int frequency, int duration) throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{-128, 3, (byte)frequency, (byte)(frequency >>> 8), (byte)duration, (byte)(duration >>> 8)};
            return this.sendRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceInfo getDeviceInfo() throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            int i;
            byte[] request = new byte[]{1, -101};
            char[] name = new char[14];
            this.nxtComm.sendData(request);
            byte[] reply = this.nxtComm.readData();
            DeviceInfo d = new DeviceInfo();
            d.status = reply[2];
            for (i = 0; reply[3 + i] != 0 && i < 14; ++i) {
                name[i] = (char)reply[3 + i];
            }
            d.NXTname = new String(name, 0, i);
            d.bluetoothAddress = this.getAddressString(reply);
            d.signalStrength = 0xFF & reply[25] | (0xFF & reply[26]) << 8 | (0xFF & reply[27]) << 16 | (0xFF & reply[28]) << 24;
            d.freeFlash = 0xFF & reply[29] | (0xFF & reply[30]) << 8 | (0xFF & reply[31]) << 16 | (0xFF & reply[32]) << 24;
            return d;
        }
    }

    private String getAddressString(byte[] reply) {
        char[] caddr = new char[20];
        int ci = 0;
        for (int i = 0; i < 7; ++i) {
            int nr = reply[i + 18] & 0xFF;
            caddr[ci++] = cs[nr / 16];
            caddr[ci++] = cs[nr % 16];
            if (i == 6) continue;
            caddr[ci++] = 58;
        }
        return new String(caddr, 0, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirmwareInfo getFirmwareVersion() throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{1, -120};
            this.nxtComm.sendData(request);
            byte[] reply = this.nxtComm.readData();
            FirmwareInfo info = new FirmwareInfo();
            info.status = reply[2];
            char[] cc = new char[3];
            if (info.status == 0) {
                cc[1] = 46;
                cc[0] = (char)(48 + reply[4]);
                cc[2] = (char)(48 + reply[3]);
                info.protocolVersion = new String(cc, 0, 3);
                cc[0] = (char)(48 + reply[6]);
                cc[2] = (char)(48 + reply[5]);
                info.firmwareVersion = new String(cc, 0, 3);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte deleteUserFlash() throws IOException {
        NXTCommand nXTCommand = this;
        synchronized (nXTCommand) {
            byte[] request = new byte[]{1, -96};
            this.nxtComm.sendData(request);
            byte[] reply = this.nxtComm.readData();
            return reply[2];
        }
    }
}

