/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.util.Vector;
import javax.bluetooth.RemoteDevice;
import lejos.nxt.comm.BTConnection;

public class Bluetooth {
    public static final byte MSG_BEGIN_INQUIRY = 0;
    public static final byte MSG_CANCEL_INQUIRY = 1;
    public static final byte MSG_CONNECT = 2;
    public static final byte MSG_OPEN_PORT = 3;
    public static final byte MSG_LOOKUP_NAME = 4;
    public static final byte MSG_ADD_DEVICE = 5;
    public static final byte MSG_REMOVE_DEVICE = 6;
    public static final byte MSG_DUMP_LIST = 7;
    public static final byte MSG_CLOSE_CONNECTION = 8;
    public static final byte MSG_ACCEPT_CONNECTION = 9;
    public static final byte MSG_PIN_CODE = 10;
    public static final byte MSG_OPEN_STREAM = 11;
    public static final byte MSG_START_HEART = 12;
    public static final byte MSG_HEARTBEAT = 13;
    public static final byte MSG_INQUIRY_RUNNING = 14;
    public static final byte MSG_INQUIRY_RESULT = 15;
    public static final byte MSG_INQUIRY_STOPPED = 16;
    public static final byte MSG_LOOKUP_NAME_RESULT = 17;
    public static final byte MSG_LOOKUP_NAME_FAILURE = 18;
    public static final byte MSG_CONNECT_RESULT = 19;
    public static final byte MSG_RESET_INDICATION = 20;
    public static final byte MSG_REQUEST_PIN_CODE = 21;
    public static final byte MSG_REQUEST_CONNECTION = 22;
    public static final byte MSG_LIST_RESULT = 23;
    public static final byte MSG_LIST_ITEM = 24;
    public static final byte MSG_LIST_DUMP_STOPPED = 25;
    public static final byte MSG_CLOSE_CONNECTION_RESULT = 26;
    public static final byte MSG_PORT_OPEN_RESULT = 27;
    public static final byte MSG_SET_DISCOVERABLE = 28;
    public static final byte MSG_CLOSE_PORT = 29;
    public static final byte MSG_CLOSE_PORT_RESULT = 30;
    public static final byte MSG_PIN_CODE_ACK = 31;
    public static final byte MSG_SET_DISCOVERABLE_ACK = 32;
    public static final byte MSG_SET_FRIENDLY_NAME = 33;
    public static final byte MSG_SET_FRIENDLY_NAME_ACK = 34;
    public static final byte MSG_GET_LINK_QUALITY = 35;
    public static final byte MSG_LINK_QUALITY_RESULT = 36;
    public static final byte MSG_SET_FACTORY_SETTINGS = 37;
    public static final byte MSG_SET_FACTORY_SETTINGS_ACK = 38;
    public static final byte MSG_GET_LOCAL_ADDR = 39;
    public static final byte MSG_GET_LOCAL_ADDR_RESULT = 40;
    public static final byte MSG_GET_FRIENDLY_NAME = 41;
    public static final byte MSG_GET_DISCOVERABLE = 42;
    public static final byte MSG_GET_PORT_OPEN = 43;
    public static final byte MSG_GET_FRIENDLY_NAME_RESULT = 44;
    public static final byte MSG_GET_DISCOVERABLE_RESULT = 45;
    public static final byte MSG_GET_PORT_OPEN_RESULT = 46;
    public static final byte MSG_GET_VERSION = 47;
    public static final byte MSG_GET_VERSION_RESULT = 48;
    public static final byte MSG_GET_BRICK_STATUSBYTE_RESULT = 49;
    public static final byte MSG_SET_BRICK_STATUSBYTE_RESULT = 50;
    public static final byte MSG_GET_BRICK_STATUSBYTE = 51;
    public static final byte MSG_SET_BRICK_STATUSBYTE = 52;
    public static final byte MSG_GET_OPERATING_MODE = 53;
    public static final byte MSG_SET_OPERATING_MODE = 54;
    public static final byte MSG_OPERATING_MODE_RESULT = 55;
    public static final byte MSG_GET_CONNECTION_STATUS = 56;
    public static final byte MSG_CONNECTION_STATUS_RESULT = 57;
    public static final byte MSG_GOTO_DFU_MODE = 58;
    public static final byte MSG_ANY = -1;
    public static final byte BT_PENDING_INPUT = 1;
    public static final byte BT_PENDING_OUTPUT = 2;
    private static final byte CHANCNT = 4;
    private static final byte RS_INIT = -1;
    private static final byte RS_IDLE = 0;
    private static final byte RS_CMD = 1;
    private static final byte RS_WAIT = 2;
    private static final byte RS_REPLY = 3;
    private static final byte RS_REQUESTCONNECT = 4;
    private static final byte RS_ERROR = 5;
    private static final byte IO_TIME = 100;
    private static final byte CMD_TIME = 50;
    private static final short TO_SWITCH = 500;
    private static final short TO_REPLY = 250;
    private static final short TO_SHORT = 2000;
    private static final short TO_LONG = 30000;
    private static final short TO_RESET = 5000;
    private static final byte TO_CLOSE = 100;
    private static final byte TO_FORCERESET = -1;
    private static final byte TO_NONE = 0;
    private static final short TO_FLUSH = 500;
    private static final byte TO_SWITCH_WAIT = 75;
    private static final byte CN_NONE = -1;
    private static final int CN_IDLE = 0x7FFFFFF;
    protected static final char[] cs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static BTConnection[] Chans = new BTConnection[4];
    static byte[] cmdBuf = new byte[128];
    static byte[] replyBuf = new byte[256];
    static int cmdTimeout;
    static int reqState;
    static int savedState;
    static boolean listening;
    static int connected;
    static int resetCnt;
    static boolean powerOn;
    static boolean publicPowerOn;
    public static final byte[] defaultPin;
    private static byte[] pin;
    static Object sync;
    static byte[] cachedName;
    static byte[] cachedAddress;
    private static BTThread btThread;

    public static native int btWrite(byte[] var0, int var1, int var2);

    public static native int btRead(byte[] var0, int var1, int var2);

    public static native int btPending();

    public static native void btSetArmCmdMode(int var0);

    public static native int btGetBC4CmdMode();

    public static native void btStartADConverter();

    public static native void btSetResetLow();

    public static native void btSetResetHigh();

    public static native void btSend(byte[] var0, int var1);

    public static native void btReceive(byte[] var0);

    private Bluetooth() {
    }

    private static void cmdInit(int cmd, int len, int param1, int param2) {
        Bluetooth.cmdBuf[0] = (byte)len;
        Bluetooth.cmdBuf[1] = (byte)cmd;
        Bluetooth.cmdBuf[2] = (byte)param1;
        Bluetooth.cmdBuf[3] = (byte)param2;
    }

    private static void startTimeout(int period) {
        cmdTimeout = (int)System.currentTimeMillis() + period;
    }

    private static boolean checkTimeout() {
        return cmdTimeout > 0 && (int)System.currentTimeMillis() > cmdTimeout;
    }

    private static void cancelTimeout() {
        cmdTimeout = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int waitState(int target) {
        Object object = sync;
        synchronized (object) {
            while (reqState != target && reqState != 5) {
                try {
                    sync.wait();
                }
                catch (Exception exception) {}
            }
            if (reqState == 5) {
                return -1;
            }
            return 0;
        }
    }

    private static void cmdStart() {
        while (Bluetooth.waitState(0) < 0) {
            try {
                sync.wait();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cmdComplete() {
        Object object = sync;
        synchronized (object) {
            reqState = 0;
            Bluetooth.cancelTimeout();
            sync.notifyAll();
        }
    }

    private static int cmdWait(int state, int waitState, int msg, int timeout) {
        Object object = sync;
        synchronized (object) {
            if (!powerOn) {
                return -1;
            }
            if (waitState > 0) {
                reqState = waitState;
            }
            if (timeout != 0) {
                Bluetooth.startTimeout(timeout);
            }
            while (true) {
                if (Bluetooth.waitState(state) < 0) {
                    return -1;
                }
                if (msg == -1 || replyBuf[1] == msg) {
                    return 0;
                }
                if (reqState != 3) continue;
                reqState = 2;
            }
        }
    }

    public static void setPin(byte[] newPin) {
        pin = newPin;
    }

    public static byte[] getPin() {
        return pin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int closeConnection(byte handle) {
        int ret = -1;
        Object object = sync;
        synchronized (object) {
            Bluetooth.cmdStart();
            int timeout = handle == 3 ? 500 : 100;
            reqState = 2;
            try {
                sync.wait(timeout);
            }
            catch (Exception e) {
                // empty catch block
            }
            reqState = 0;
            byte[] status = Bluetooth.getConnectionStatus();
            if (status == null || status[handle] != 2) {
                return -1;
            }
            if (Bluetooth.Chans[handle].state != 4) {
                return -1;
            }
            Bluetooth.cmdInit(8, 2, handle, 0);
            if (Bluetooth.cmdWait(3, 1, 26, 2000) >= 0) {
                ret = replyBuf[2];
            }
            int retryCnt = 5;
            do {
                reqState = 2;
                try {
                    sync.wait(250L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                reqState = 0;
            } while (Bluetooth.getConnectionStatus() == null);
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] openPort() {
        byte[] result = new byte[3];
        Object object = sync;
        synchronized (object) {
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(3, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 27, 2000) < 0) {
                result = null;
            } else {
                System.arraycopy(replyBuf, 2, result, 0, 3);
            }
            Bluetooth.cmdComplete();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] closePort() {
        byte[] result = new byte[2];
        Object object = sync;
        synchronized (object) {
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(29, 2, 3, 0);
            if (Bluetooth.cmdWait(3, 1, 30, 2000) < 0) {
                result = null;
            } else {
                System.arraycopy(replyBuf, 2, result, 0, 2);
            }
            Bluetooth.cmdComplete();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BTConnection waitForConnection(int timeout, byte[] pin) {
        Object object = sync;
        synchronized (object) {
            BTConnection ret = null;
            if (listening) {
                return null;
            }
            byte[] port = Bluetooth.openPort();
            if (port == null || port[0] != 1 || port[1] >= Chans.length || port[1] < 0) {
                return null;
            }
            listening = true;
            byte[] savedPin = null;
            if (pin != null) {
                savedPin = Bluetooth.getPin();
                Bluetooth.setPin(pin);
            }
            if (timeout == 0) {
                timeout = Integer.MAX_VALUE;
            }
            while (listening && reqState != 4) {
                try {
                    sync.wait(timeout < 1000 ? (long)timeout : 1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if ((timeout -= 1000) > 0) continue;
                listening = false;
            }
            if (listening) {
                byte handle;
                byte[] addr = new byte[7];
                for (int i = 0; i < addr.length; i = (int)((byte)(i + 1))) {
                    addr[i] = replyBuf[i + 2];
                }
                reqState = savedState;
                Bluetooth.cmdStart();
                Bluetooth.cmdInit(9, 2, 1, 0);
                if (Bluetooth.cmdWait(3, 1, 19, 30000) >= 0 && replyBuf[2] == 1 && (handle = replyBuf[3]) >= 0 && handle < Chans.length) {
                    Chans[handle].bind(handle, addr);
                    ++connected;
                    ret = Chans[handle];
                }
                listening = false;
                Bluetooth.cmdComplete();
            }
            if (savedPin != null) {
                Bluetooth.setPin(savedPin);
            }
            Bluetooth.closePort();
            return ret;
        }
    }

    public static BTConnection waitForConnection() {
        return Bluetooth.waitForConnection(0, null);
    }

    public static BTConnection connect(RemoteDevice remoteDevice) {
        if (remoteDevice == null) {
            return null;
        }
        return Bluetooth.connect(remoteDevice.getDeviceAddr());
    }

    public static BTConnection connect(byte[] device_addr) {
        return Bluetooth.connect(device_addr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BTConnection connect(byte[] device_addr, byte[] pin) {
        Object object = sync;
        synchronized (object) {
            BTConnection ret = null;
            byte[] savedPin = null;
            if (pin != null) {
                savedPin = Bluetooth.getPin();
                Bluetooth.setPin(pin);
            }
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(2, 8, 0, 0);
            System.arraycopy(device_addr, 0, cmdBuf, 2, 7);
            if (Bluetooth.cmdWait(3, 1, 19, 30000) >= 0 && replyBuf[2] != 0) {
                byte handle = replyBuf[3];
                reqState = 2;
                try {
                    sync.wait(300L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (reqState == 2 && handle >= 0 && handle < Chans.length) {
                    Chans[handle].bind(handle, device_addr);
                    ++connected;
                    ret = Chans[handle];
                }
            }
            Bluetooth.cmdComplete();
            if (savedPin != null) {
                Bluetooth.setPin(savedPin);
            }
            return ret;
        }
    }

    public static String addressToString(byte[] addr) {
        char[] caddr = new char[12];
        int ci = 0;
        int nr = 0;
        int addri = 0;
        for (int i = 0; i < 6; ++i) {
            addri = addr[i];
            nr = addri >= 0 ? addri : 256 + addri;
            caddr[ci++] = cs[nr / 16];
            caddr[ci++] = cs[nr % 16];
        }
        return new String(caddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSignalStrength(byte handle) {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            if (Bluetooth.Chans[handle].state != 2) {
                return -1;
            }
            Bluetooth.cmdInit(35, 2, handle, 0);
            if (Bluetooth.cmdWait(3, 1, 36, 2000) >= 0) {
                ret = replyBuf[2] & 0xFF;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFriendlyName() {
        byte[] result = new byte[16];
        Object object = sync;
        synchronized (object) {
            if (!powerOn) {
                return cachedName;
            }
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(41, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 44, 2000) < 0) {
                result = null;
            } else {
                System.arraycopy(replyBuf, 2, result, 0, 16);
            }
            Bluetooth.cmdComplete();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setFriendlyName(byte[] name) {
        Object object = sync;
        synchronized (object) {
            boolean ret = false;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(33, 17, 0, 0);
            System.arraycopy(name, 0, cmdBuf, 2, 16);
            if (Bluetooth.cmdWait(3, 1, 34, 30000) >= 0) {
                ret = true;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getLocalAddress() {
        byte[] result = new byte[7];
        Object object = sync;
        synchronized (object) {
            if (!powerOn) {
                return cachedAddress;
            }
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(39, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 40, 2000) < 0) {
                result = null;
            } else {
                System.arraycopy(replyBuf, 2, result, 0, 7);
            }
            Bluetooth.cmdComplete();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getKnownDevicesList() {
        Object object = sync;
        synchronized (object) {
            int state = 1;
            byte[] device = new byte[7];
            byte[] devclass = new byte[4];
            char[] name = new char[16];
            Vector retVec = new Vector(1);
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(7, 1, 0, 0);
            while (Bluetooth.cmdWait(3, state, -1, 30000) >= 0) {
                state = 2;
                if (replyBuf[1] == 24) {
                    int nl;
                    System.arraycopy(replyBuf, 2, device, 0, 7);
                    for (nl = 0; nl < 16 && replyBuf[nl + 9] != 0; ++nl) {
                        name[nl] = (char)replyBuf[nl + 9];
                    }
                    System.arraycopy(replyBuf, 25, devclass, 0, 4);
                    RemoteDevice curDevice = new RemoteDevice(name, nl, device, devclass);
                    retVec.addElement(curDevice);
                    continue;
                }
                if (replyBuf[1] != 25) continue;
            }
            Bluetooth.cmdComplete();
            return retVec;
        }
    }

    public static RemoteDevice getKnownDevice(String fName) {
        RemoteDevice btd = null;
        Vector devList = Bluetooth.getKnownDevicesList();
        if (devList.size() > 0) {
            for (int i = 0; i < devList.size(); ++i) {
                btd = (RemoteDevice)devList.elementAt(i);
                if (!btd.getFriendlyName(false).equals(fName)) continue;
                return btd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addDevice(RemoteDevice d) {
        byte[] addr = d.getDeviceAddr();
        String name = d.getFriendlyName(false);
        byte[] cod = d.getDeviceClass();
        Object object = sync;
        synchronized (object) {
            int i;
            boolean ret = false;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(5, 28, 0, 0);
            System.arraycopy(addr, 0, cmdBuf, 2, 7);
            System.arraycopy(cod, 0, cmdBuf, 25, 4);
            for (i = 0; i < name.length(); ++i) {
                Bluetooth.cmdBuf[i + 9] = (byte)name.charAt(i);
            }
            for (i = name.length(); i < 16; ++i) {
                Bluetooth.cmdBuf[i + 9] = 0;
            }
            if (Bluetooth.cmdWait(3, 1, 23, 30000) >= 0) {
                ret = replyBuf[2] == 80;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDevice(RemoteDevice d) {
        byte[] addr = d.getDeviceAddr();
        Object object = sync;
        synchronized (object) {
            boolean ret = false;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(6, 8, 0, 0);
            System.arraycopy(addr, 0, cmdBuf, 2, 7);
            if (Bluetooth.cmdWait(3, 1, 23, 30000) >= 0) {
                ret = replyBuf[2] == 83;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector inquire(int maxDevices, int timeout, byte[] cod) {
        Vector retVec = new Vector();
        byte[] device = new byte[7];
        char[] name = new char[16];
        Object object = sync;
        synchronized (object) {
            int state = 1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(0, 8, maxDevices, 0);
            Bluetooth.cmdBuf[4] = (byte)timeout;
            System.arraycopy(cod, 0, cmdBuf, 5, 4);
            while (Bluetooth.cmdWait(3, state, -1, 30000) >= 0) {
                state = 2;
                if (replyBuf[1] == 15) {
                    int nameLen;
                    System.arraycopy(replyBuf, 2, device, 0, 7);
                    for (nameLen = 0; nameLen < 16 && replyBuf[9 + nameLen] != 0; ++nameLen) {
                        name[nameLen] = (char)replyBuf[9 + nameLen];
                    }
                    System.arraycopy(replyBuf, 25, cod, 0, 4);
                    retVec.addElement(new RemoteDevice(name, nameLen, device, cod));
                    continue;
                }
                if (replyBuf[1] != 16) continue;
                Bluetooth.cmdComplete();
                for (int i = 0; i < retVec.size(); ++i) {
                    RemoteDevice btrd = (RemoteDevice)retVec.elementAt(i);
                    String s = btrd.getFriendlyName(false);
                    if (s.length() != 0) continue;
                    String nm = Bluetooth.lookupName(btrd.getDeviceAddr());
                    btrd.setFriendlyName(nm.toCharArray(), nm.length());
                }
                return retVec;
            }
            Bluetooth.cmdComplete();
            return retVec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lookupName(byte[] addr) {
        char[] name = new char[16];
        Object object = sync;
        synchronized (object) {
            String ret = "";
            int state = 1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(4, 8, 0, 0);
            System.arraycopy(addr, 0, cmdBuf, 2, 7);
            while (Bluetooth.cmdWait(3, state, -1, 30000) >= 0) {
                state = 2;
                if (replyBuf[1] == 17) {
                    int len;
                    for (len = 0; len < 16 && replyBuf[len + 9] != 0; ++len) {
                        name[len] = (char)replyBuf[len + 9];
                    }
                    ret = new String(name, 0, len);
                    break;
                }
                if (replyBuf[1] != 18) continue;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getConnectionStatus() {
        byte[] result = new byte[4];
        Object object = sync;
        synchronized (object) {
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(56, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 57, 2000) < 0) {
                result = null;
            } else {
                System.arraycopy(replyBuf, 5, result, 0, 4);
            }
            Bluetooth.cmdComplete();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getVersion() {
        byte[] version = new byte[2];
        Object object = sync;
        synchronized (object) {
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(47, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 48, 2000) < 0) {
                version = null;
            } else {
                System.arraycopy(replyBuf, 2, version, 0, 2);
            }
            Bluetooth.cmdComplete();
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatus() {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(51, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 49, 2000) >= 0) {
                ret = replyBuf[2] & 0xFF | (replyBuf[3] & 0xFF) << 8;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setStatus(int status) {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(52, 3, status & 0xFF, status >> 8 & 0xFF);
            if (Bluetooth.cmdWait(3, 1, 50, 2000) >= 0) {
                ret = 0;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVisibility() {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(42, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 45, 2000) >= 0) {
                ret = replyBuf[2];
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPortOpen() {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(43, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 46, 2000) >= 0) {
                ret = replyBuf[2];
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOperatingMode() {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(53, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 55, 2000) >= 0) {
                ret = replyBuf[2];
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setVisibility(byte visible) {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(28, 2, visible, 0);
            if (Bluetooth.cmdWait(3, 1, 32, 2000) >= 0) {
                ret = 0;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setFactorySettings() {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(37, 1, 0, 0);
            if (Bluetooth.cmdWait(3, 1, 38, 2000) >= 0) {
                ret = 0;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setOperatingMode(byte mode) {
        Object object = sync;
        synchronized (object) {
            int ret = -1;
            Bluetooth.cmdStart();
            Bluetooth.cmdInit(54, 2, mode, 0);
            if (Bluetooth.cmdWait(3, 1, 55, 2000) >= 0) {
                ret = 0;
            }
            Bluetooth.cmdComplete();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = sync;
        synchronized (object) {
            Bluetooth.cmdStart();
            Bluetooth.cmdWait(3, 2, 20, -1);
            Bluetooth.cmdComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPower(boolean on) {
        Object object = sync;
        synchronized (object) {
            if (powerOn == on) {
                return;
            }
            if (on) {
                Bluetooth.btSetResetHigh();
                powerOn = true;
                for (int i = 0; i < 5 && Bluetooth.getOperatingMode() < 0; ++i) {
                }
            } else {
                boolean wasListening = listening;
                Bluetooth.cmdStart();
                if (connected > 0 || listening) {
                    Bluetooth.reset();
                }
                if (wasListening) {
                    try {
                        sync.wait(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Bluetooth.btSetResetLow();
                powerOn = false;
            }
            publicPowerOn = powerOn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPower() {
        Object object = sync;
        synchronized (object) {
            return publicPowerOn;
        }
    }

    public static int getResetCount() {
        return resetCnt;
    }

    public static int readPacket(byte[] buf, int len) {
        return Chans[3].readPacket(buf, len);
    }

    public static void sendPacket(byte[] buf, int bufLen) {
        Chans[3].sendPacket(buf, bufLen);
    }

    public static void btSetCmdMode(int mode) {
    }

    static /* synthetic */ byte[] access$400() {
        return pin;
    }

    static {
        reqState = -1;
        listening = false;
        publicPowerOn = false;
        defaultPin = new byte[]{49, 50, 51, 52};
        pin = defaultPin;
        sync = new Object();
        btThread = new BTThread();
    }

    static class BTThread
    extends Thread {
        static final int MO_STREAM = 0;
        static final int MO_CMD = 1;
        static final int MO_UNKNOWN = -1;
        private int mode = 1;
        private int curChan;

        public BTThread() {
            reqState = -1;
            this.curChan = -1;
            resetCnt = 0;
            Bluetooth.btSetResetHigh();
            for (int i = 0; i < 4; ++i) {
                Bluetooth.Chans[i] = new BTConnection(i);
            }
            connected = 0;
            listening = false;
            Bluetooth.cancelTimeout();
            this.setDaemon(true);
            this.start();
            powerOn = false;
            Bluetooth.setPower(true);
            Bluetooth.setOperatingMode((byte)1);
            Bluetooth.closePort();
            cachedName = Bluetooth.getFriendlyName();
            cachedAddress = Bluetooth.getLocalAddress();
        }

        private void sendCommand() {
            int checkSum = 0;
            int len = cmdBuf[0] & 0xFF;
            for (int i = 0; i < len; ++i) {
                checkSum += cmdBuf[i + 1];
            }
            checkSum = -checkSum;
            Bluetooth.cmdBuf[len + 1] = (byte)(checkSum >> 8 & 0xFF);
            Bluetooth.cmdBuf[len + 2] = (byte)checkSum;
            Bluetooth.cmdBuf[0] = (byte)(len + 2);
            Bluetooth.btWrite(cmdBuf, 0, len + 3);
        }

        private int recvReply() {
            if (Bluetooth.checkTimeout()) {
                return -1;
            }
            int cnt = Bluetooth.btRead(replyBuf, 0, 1);
            if (cnt <= 0) {
                return 0;
            }
            int len = replyBuf[0] & 0xFF;
            if (len < 3 || len >= replyBuf.length) {
                return -1;
            }
            int timeout = (int)System.currentTimeMillis() + 250;
            while (cnt < len + 1) {
                cnt += Bluetooth.btRead(replyBuf, cnt, len + 1 - cnt);
                if ((int)System.currentTimeMillis() <= timeout) continue;
                return -1;
            }
            int csum = len;
            len -= 2;
            for (int i = 0; i < len; ++i) {
                csum += replyBuf[i + 1] & 0xFF;
            }
            if ((byte)(csum = -csum) == replyBuf[len + 2] && (byte)(csum >> 8) == replyBuf[len + 1]) {
                return len;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            Object object = sync;
            synchronized (object) {
                for (int resetCnt = 0; resetCnt < 2; ++resetCnt) {
                    int len;
                    Bluetooth.startTimeout(500);
                    while (!Bluetooth.checkTimeout()) {
                        this.recvReply();
                    }
                    Bluetooth.btSetArmCmdMode(1);
                    Bluetooth.btSetResetLow();
                    Bluetooth.startTimeout(100);
                    while (!Bluetooth.checkTimeout()) {
                        this.recvReply();
                    }
                    Bluetooth.btSetResetHigh();
                    Bluetooth.startTimeout(5000);
                    while ((len = this.recvReply()) == 0 || len > 0 && replyBuf[1] != 20) {
                        Thread.yield();
                    }
                    Bluetooth.cmdInit(53, 1, 0, 0);
                    this.sendCommand();
                    Bluetooth.startTimeout(2000);
                    while ((len = this.recvReply()) == 0 || len > 0 && replyBuf[1] != 55) {
                        Thread.yield();
                    }
                    if (len > 0) break;
                }
                this.mode = 1;
                for (int i = 0; i < 4; ++i) {
                    Chans[i].reset();
                }
                listening = false;
                connected = 0;
                this.curChan = -1;
                Bluetooth.cancelTimeout();
                if (reqState > 0) {
                    reqState = 5;
                }
                sync.notifyAll();
                ++resetCnt;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void processReply() {
            var1_1 = Bluetooth.sync;
            synchronized (var1_1) {
                while (Bluetooth.reqState < 3 && (len = this.recvReply()) != 0) {
                    block14: {
                        block13: {
                            if (len < 0 || Bluetooth.replyBuf[1] == 20) {
                                this.reset();
                                break;
                            }
                            if (Bluetooth.replyBuf[1] != 26) break block13;
                            if (Bluetooth.replyBuf[3] >= 0 && Bluetooth.replyBuf[3] < Bluetooth.Chans.length) {
                                if (Bluetooth.Chans[Bluetooth.replyBuf[3]].disconnected()) {
                                    --Bluetooth.connected;
                                }
                                if (Bluetooth.replyBuf[3] == (byte)this.curChan) {
                                    this.curChan = -1;
                                }
                            }
                            break block14;
                        }
                        if (Bluetooth.replyBuf[1] != 22) ** GOTO lbl24
                        if (Bluetooth.listening) {
                            Bluetooth.savedState = Bluetooth.reqState;
                            Bluetooth.reqState = 4;
                        } else {
                            Bluetooth.access$300(9, 2, 0, 0);
                            this.sendCommand();
                            continue;
lbl24:
                            // 1 sources

                            if (Bluetooth.replyBuf[1] == 21) {
                                if (Bluetooth.access$400() == null) continue;
                                Bluetooth.access$300(10, 24, 0, 0);
                                System.arraycopy(Bluetooth.replyBuf, 2, Bluetooth.cmdBuf, 2, 7);
                                for (i = 0; i < 16; ++i) {
                                    Bluetooth.cmdBuf[i + 9] = i < Bluetooth.access$400().length ? Bluetooth.access$400()[i] : 0;
                                }
                                this.sendCommand();
                                continue;
                            }
                            if (Bluetooth.replyBuf[1] == 31) continue;
                        }
                    }
                    if (Bluetooth.reqState == 2) {
                        Bluetooth.reqState = 3;
                    }
                    if (Bluetooth.reqState < 3) continue;
                    Bluetooth.sync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCommands() {
            this.switchToCmd();
            int cmdEnd = (int)System.currentTimeMillis() + 50;
            while (cmdEnd > (int)System.currentTimeMillis() || reqState > 0) {
                Object object = sync;
                synchronized (object) {
                    if (reqState == 1) {
                        this.sendCommand();
                        reqState = 2;
                    }
                    this.processReply();
                }
                Thread.yield();
            }
        }

        private int selectChan() {
            if (connected == 0) {
                return -1;
            }
            int cur = this.curChan;
            for (int i = 0; i < Chans.length; ++i) {
                if (!Chans[cur = (cur + 1) % Chans.length].needsAttention()) continue;
                return cur;
            }
            return 0x7FFFFFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processStreams() {
            while (true) {
                Object object = sync;
                synchronized (object) {
                    if (reqState != 0) {
                        return;
                    }
                    int next = this.selectChan();
                    if (next < 0) {
                        return;
                    }
                    if (next != 0x7FFFFFF) {
                        if (!this.switchToStream(next)) {
                            return;
                        }
                        int ioEnd = (int)System.currentTimeMillis() + 100;
                        while (ioEnd > (int)System.currentTimeMillis() && Bluetooth.Chans[this.curChan].state >= 2) {
                            if (this.bc4Mode() != 0) {
                                return;
                            }
                            Chans[this.curChan].send();
                            Chans[this.curChan].recv();
                            Thread.yield();
                        }
                    } else if (this.bc4Mode() != this.mode) {
                        return;
                    }
                    if (listening) {
                        return;
                    }
                }
                Thread.yield();
            }
        }

        private int waitSwitch(int target, boolean flush) {
            int timeout = (int)System.currentTimeMillis() + 500;
            while (timeout > (int)System.currentTimeMillis()) {
                if (this.bc4Mode() == target) {
                    return target;
                }
                if (!flush || this.curChan < 0) continue;
                Chans[this.curChan].flushInput();
            }
            this.mode = -1;
            this.curChan = -1;
            return this.bc4Mode();
        }

        private boolean switchToStream(int chan) {
            if (this.mode == 0 && chan == this.curChan) {
                return true;
            }
            this.switchToCmd();
            Bluetooth.cmdInit(11, 2, Bluetooth.Chans[chan].handle, 0);
            this.sendCommand();
            if (this.waitSwitch(0, false) != 0) {
                return false;
            }
            this.processReply();
            Bluetooth.btSetArmCmdMode(0);
            this.mode = 0;
            this.curChan = chan;
            return true;
        }

        private void switchToCmd() {
            if (this.mode == 1) {
                return;
            }
            if (this.mode == 0 && this.bc4Mode() == 1 && this.curChan >= 0) {
                Chans[this.curChan].flushInput();
            }
            while ((Bluetooth.btPending() & 2) != 0) {
                Thread.yield();
            }
            try {
                Thread.sleep(75L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Bluetooth.btSetArmCmdMode(1);
            if (this.waitSwitch(1, true) != 1) {
                this.reset();
                return;
            }
            this.mode = 1;
        }

        private int bc4Mode() {
            int ret = Bluetooth.btGetBC4CmdMode();
            if (ret > 512) {
                return 0;
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitInit() {
            Object object = sync;
            synchronized (object) {
                reqState = -1;
                this.processCommands();
                reqState = 0;
                sync.notifyAll();
            }
        }

        public void run() {
            this.waitInit();
            while (true) {
                this.processCommands();
                this.processStreams();
                Thread.yield();
            }
        }
    }
}

