/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CSensor;
import lejos.nxt.SensorPort;

public class PSPNXController
extends I2CSensor {
    private static final byte MODE = 65;
    private static final byte ENERGIZED = 69;
    private static final byte DE_ENERGIZED = 68;
    private static final byte SET_DIGITAL_MODE = 65;
    private static final byte SET_ANALOG_MODE = 115;
    private static final byte SET_ADPA_MODE_ON = 78;
    private static final byte SET_ADPA_MODE_OFF = 79;
    private static final byte BUTTON_1 = 66;
    private static final byte BUTTON_2 = 67;
    private static final byte X_LEFT_JOYSTICK = 68;
    private static final byte Y_LEFT_JOYSTICK = 69;
    private static final byte X_RIGHT_JOYSTICK = 70;
    private static final byte Y_RIGHT_JOYSTICK = 71;
    private byte[] buf = new byte[1];

    public PSPNXController(SensorPort port) {
        super(port);
        this.powerUp(true);
        this.setDigitalMode(true);
    }

    private int setMode(byte mode) {
        this.buf[0] = mode;
        int ret = this.sendData(65, this.buf, 1);
        return ret;
    }

    public int powerUp(boolean activate) {
        if (activate) {
            return this.setMode((byte)69);
        }
        return this.setMode((byte)68);
    }

    public short getButtons() {
        short buttons = 0;
        int ret = this.getData(66, this.buf, 1);
        if (ret == 0) {
            buttons = this.buf[0];
            ret = this.getData(67, this.buf, 1);
            buttons = (short)(buttons + (this.buf[0] << 8));
        } else {
            buttons = -1;
        }
        return buttons;
    }

    public int setDigitalMode(boolean activate) {
        if (activate) {
            return this.setMode((byte)65);
        }
        return this.setMode((byte)115);
    }

    public byte getLeftX() {
        int ret = this.getData(68, this.buf, 1);
        return ret == 0 ? this.buf[0] : (byte)-1;
    }

    public byte getleftY() {
        int ret = this.getData(69, this.buf, 1);
        return ret == 0 ? this.buf[0] : (byte)-1;
    }

    public byte getRightX() {
        int ret = this.getData(70, this.buf, 1);
        return ret == 0 ? this.buf[0] : (byte)-1;
    }

    public byte getRightY() {
        int ret = this.getData(71, this.buf, 1);
        return ret == 0 ? this.buf[0] : (byte)-1;
    }

    public byte getMode() {
        int ret = this.getData(65, this.buf, 1);
        return ret == 0 ? this.buf[0] : (byte)-1;
    }

    public int setADPAMode(boolean activate) {
        if (activate) {
            return this.setMode((byte)78);
        }
        return this.setMode((byte)79);
    }
}

