/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import java.util.ArrayList;
import lejos.nxt.I2CSensor;
import lejos.nxt.LServo;
import lejos.nxt.SensorPort;

public class LSC
extends I2CSensor {
    private final int MAXIMUM_SERVOS = 10;
    private ArrayList arrServo;
    public static final byte[] arrServoID = new byte[]{1, 2, 4, 8};
    private final String ERROR_SERVO_DEFINITION = "Error with Servo definition";
    private byte SPI_PORT;
    private SensorPort portConnected;
    int I2C_Response;
    private byte[] bufReadResponse;
    private byte h_byte;
    private byte l_byte;

    public LSC(SensorPort port, byte SPI_PORT) {
        super(port);
        this.portConnected = port;
        this.SPI_PORT = SPI_PORT;
        this.bufReadResponse = new byte[8];
        this.arrServo = new ArrayList();
        this.setAddress(40);
    }

    public void addServo(int index, String name) throws Exception {
        if (this.arrServo.size() > 10) {
            throw new Exception("Error with Servo definition");
        }
        LServo s = new LServo(this.portConnected, index, name, this.SPI_PORT);
        this.arrServo.add(s);
    }

    public LServo getServo(int index) {
        return (LServo)this.arrServo.get(index);
    }

    public void calibrate() throws Exception {
        this.I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        this.I2C_Response = this.getData(this.SPI_PORT, this.bufReadResponse, 1);
        while (this.bufReadResponse[0] != 99) {
            this.I2C_Response = this.sendData(this.SPI_PORT, (byte)-1);
            this.I2C_Response = this.sendData(this.SPI_PORT, (byte)-1);
            this.I2C_Response = this.sendData(this.SPI_PORT, (byte)126);
            this.I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
            this.I2C_Response = this.getData(this.SPI_PORT, this.bufReadResponse, 1);
            if (this.bufReadResponse[0] != 99) continue;
            break;
        }
    }

    public void loadAllServos() throws Exception {
        int channel = 1023;
        this.h_byte = (byte)-32;
        this.l_byte = (byte)channel;
        this.I2C_Response = this.sendData(this.SPI_PORT, this.h_byte);
        this.I2C_Response = this.sendData(this.SPI_PORT, this.l_byte);
    }
}

