/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

public class LCD {
    public static final int SCREEN_WIDTH = 100;
    public static final int SCREEN_HEIGHT = 64;
    public static final int DISPLAY_WIDTH = 100;
    public static final int DISPLAY_DEPTH = 8;
    public static final int NOOF_CHARS = 128;
    public static final int FONT_WIDTH = 5;
    public static final int FONT_HEIGHT = 8;
    public static final int CELL_WIDTH = 6;
    public static final int CELL_HEIGHT = 8;
    public static final int DISPLAY_CHAR_WIDTH = 16;
    public static final int DISPLAY_CHAR_DEPTH = 8;
    private static byte[] font = LCD.getSystemFont();
    private static byte[] displayBuf = LCD.getDisplay();
    public static final int ROP_CLEAR = 0;
    public static final int ROP_AND = -16777216;
    public static final int ROP_ANDREVERSE = -16711936;
    public static final int ROP_COPY = 65280;
    public static final int ROP_ANDINVERTED = -65536;
    public static final int ROP_NOOP = 0xFF0000;
    public static final int ROP_XOR = 0xFFFF00;
    public static final int ROP_OR = -256;
    public static final int ROP_NOR = -1;
    public static final int ROP_EQUIV = 0xFFFFFF;
    public static final int ROP_INVERT = 0xFF00FF;
    public static final int ROP_ORREVERSE = -65281;
    public static final int ROP_COPYINVERTED = 65535;
    public static final int ROP_ORINVERTED = -16711681;
    public static final int ROP_NAND = -16776961;
    public static final int ROP_SET = 255;

    public static void bitBlt(byte[] src, int sw, int sh, int sx, int sy, int dx, int dy, int w, int h, int rop) {
        LCD.bitBlt(src, sw, sh, sx, sy, displayBuf, 100, 64, dx, dy, w, h, rop);
    }

    public static void bitBlt(int dx, int dy, int w, int h, int rop) {
        LCD.bitBlt(displayBuf, 100, 64, 0, 0, displayBuf, 100, 64, dx, dy, w, h, rop);
    }

    public static void setPixel(int rgbColor, int x, int y) {
        if (x < 0 || x >= 100 || y < 0 || y >= 64) {
            return;
        }
        int bit = y & 7;
        int index = y / 8 * 100 + x;
        LCD.displayBuf[index] = (byte)(displayBuf[index] & ~(1 << bit) | rgbColor << bit);
    }

    public static void drawString(String str, int x, int y, boolean invert) {
        char[] strData = str.toCharArray();
        if (invert) {
            for (int i = 0; i < strData.length; ++i) {
                LCD.drawChar(strData[i], x + i * 6, y, true);
            }
        } else {
            for (int i = 0; i < strData.length; ++i) {
                LCD.drawChar(strData[i], x + i * 6, y, 65280);
            }
        }
    }

    public static void drawChar(char c, int x, int y, boolean invert) {
        LCD.bitBlt(font, 640, 8, 5 * c, 0, x, y, 5, 8, invert ? 65535 : 65280);
        if (invert) {
            LCD.bitBlt(x + 5, y, 1, 8, 255);
        }
    }

    public static void drawString(String str, int x, int y, int rop) {
        char[] strData = str.toCharArray();
        for (int i = 0; i < strData.length; ++i) {
            LCD.drawChar(strData[i], x + i * 6, y, rop);
        }
    }

    public static void drawChar(char c, int x, int y, int rop) {
        LCD.bitBlt(font, 640, 8, 5 * c, 0, x, y, 5, 8, rop);
    }

    public static void drawPixels(byte b, int x, int y, boolean invert) {
        int index;
        int n = index = y / 8 * 100 + x;
        displayBuf[n] = (byte)(displayBuf[n] | (invert ? b ^ 0xFF : b));
    }

    public static void clearDisplay() {
        LCD.clear();
    }

    public static void setDisplay() {
    }

    public static native void drawString(String var0, int var1, int var2);

    public static native void drawInt(int var0, int var1, int var2);

    public static native void drawInt(int var0, int var1, int var2, int var3);

    public static native void refresh();

    public static native void clear();

    public static native void setDisplay(int[] var0);

    public static native byte[] getDisplay();

    public static native byte[] getSystemFont();

    public static native void setAutoRefresh(int var0);

    public static native void bitBlt(byte[] var0, int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    public static void scroll() {
        LCD.bitBlt(displayBuf, 100, 64, 0, 8, 0, 0, 100, 56, 65280);
        LCD.bitBlt(0, 56, 100, 8, 0);
    }
}

