/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.ButtonListener;
import lejos.nxt.ListenerCaller;
import lejos.nxt.ListenerThread;
import lejos.nxt.Poll;
import lejos.nxt.Sound;
import lejos.nxt.SystemSettings;

public class Button
implements ListenerCaller {
    private int iCode;
    private ButtonListener[] iListeners = new ButtonListener[4];
    private int iNumListeners;
    private static int[] clickFreq = new int[16];
    private static int clickVol;
    private static int clickLen;
    private static int curButtons;
    public static final String VOL_SETTING = "lejos.keyclick_volume";
    public static final Button ENTER;
    public static final Button LEFT;
    public static final Button RIGHT;
    public static final Button ESCAPE;
    public static final Button[] BUTTONS;
    static Poll poller;

    private Button(int aCode) {
        this.iCode = aCode;
    }

    public final int getId() {
        return this.iCode;
    }

    public final boolean isPressed() {
        return (Button.readButtons() & this.iCode) != 0;
    }

    public final void waitForPressAndRelease() throws InterruptedException {
        do {
            poller.poll(this.iCode << 4, 0);
        } while (this.isPressed());
    }

    public static int waitForPress() {
        while (0 < Button.readButtons()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {}
        }
        while (0 == Button.readButtons()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return Button.readButtons();
    }

    public synchronized void addButtonListener(ButtonListener aListener) {
        if (this.iListeners == null) {
            this.iListeners = new ButtonListener[4];
        }
        this.iListeners[this.iNumListeners++] = aListener;
        ListenerThread.get().addButtonToMask(this.iCode, this);
    }

    static native int getButtons();

    public static int readButtons() {
        int tone;
        int newButtons = Button.getButtons();
        if (newButtons != curButtons && clickVol != 0 && (tone = clickFreq[newButtons]) != 0) {
            Sound.playTone(tone, clickLen, -clickVol);
        }
        curButtons = newButtons;
        return newButtons;
    }

    public synchronized void callListeners() {
        for (int i = 0; i < this.iNumListeners; ++i) {
            if (this.isPressed()) {
                this.iListeners[i].buttonPressed(this);
                continue;
            }
            this.iListeners[i].buttonReleased(this);
        }
    }

    public static void setKeyClickVolume(int vol) {
        clickVol = vol;
    }

    public static int getKeyClickVolume() {
        return clickVol;
    }

    public static void setKeyClickLength(int len) {
        clickLen = len;
    }

    public static int getKeyClickLength() {
        return clickLen;
    }

    public static void setKeyClickTone(int key, int freq) {
        Button.clickFreq[key] = freq;
    }

    public static int getKeyClickTone(int key) {
        return clickFreq[key];
    }

    public static void loadSettings() {
        clickVol = SystemSettings.getIntSetting(VOL_SETTING, 20);
        clickLen = 50;
        Button.clickFreq[1] = 906;
        Button.clickFreq[2] = 979;
        Button.clickFreq[4] = 1061;
        Button.clickFreq[8] = 1150;
        Button.clickFreq[3] = 1403;
        Button.clickFreq[5] = 1485;
        Button.clickFreq[9] = 1574;
    }

    static {
        curButtons = 0;
        Button.loadSettings();
        ENTER = new Button(1);
        LEFT = new Button(2);
        RIGHT = new Button(4);
        ESCAPE = new Button(8);
        BUTTONS = new Button[]{ENTER, LEFT, RIGHT, ESCAPE};
        poller = new Poll();
    }
}

