/*
 * Decompiled with CFR 0.152.
 */
package lejos.devices;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lejos.devices.KeyEvent;
import lejos.devices.KeyListener;

public class Keyboard
extends Thread {
    private static int ECHO = 238;
    private static int KEEP_ALIVE_DELAY = 4000;
    private static int MAX_LISTENERS = 3;
    private InputStream in = null;
    private OutputStream out = null;
    private KeyListener[] listeners = new KeyListener[MAX_LISTENERS];
    private static byte[] scanCodes = new byte[]{0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 9, 96, 0, 0, 18, 15, 18, 17, 113, 49, 0, 0, 0, 122, 115, 97, 119, 50, 0, 0, 99, 120, 100, 101, 52, 51, 0, 0, 32, 118, 102, 116, 114, 53, 0, 0, 110, 98, 104, 103, 121, 54, 0, 0, 0, 109, 106, 117, 55, 56, 0, 0, 0, 107, 105, 111, 48, 57, 0, 0, 46, 47, 108, 59, 112, 45, 0, 0, 0, 39, 0, 91, 61, 0, 0, 0, 15, 10, 93, 32, 92, 0, 0, 0, 0, 0, 0, 0, 0, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8};

    public Keyboard(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.setDaemon(true);
        this.start();
    }

    public void addKeyListener(KeyListener l) {
        this.listeners[0] = l;
    }

    public void removeKeylistener(KeyListener l) {
        this.listeners[0] = null;
    }

    private void notifyListeners(KeyEvent e) {
        if (e.getID() == KeyEvent.KEY_PRESSED) {
            this.listeners[0].keyPressed(e);
        } else if (e.getID() == KeyEvent.KEY_RELEASED) {
            this.listeners[0].keyReleased(e);
        } else if (e.getID() == KeyEvent.KEY_TYPED) {
            this.listeners[0].keyTyped(e);
        }
    }

    public static byte getASCII(byte scanCode) {
        if (scanCode < 0) {
            return 0;
        }
        return scanCodes[scanCode];
    }

    public void run() {
        int previousEcho = (int)System.currentTimeMillis();
        while (true) {
            int now;
            if ((now = (int)System.currentTimeMillis()) - previousEcho >= KEEP_ALIVE_DELAY) {
                try {
                    this.out.write(ECHO);
                    this.out.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
                previousEcho = now;
            }
            try {
                int bval;
                KeyEvent e;
                if (this.in.available() > 0 && (e = this.getKeyEvent(bval = this.in.read(), now)) != null) {
                    this.notifyListeners(e);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Thread.yield();
        }
    }

    private KeyEvent getKeyEvent(int scanCode, int timeStamp) {
        char curChar = (char)Keyboard.getASCII((byte)scanCode);
        if ((byte)scanCode < 0) {
            return null;
        }
        KeyEvent e = new KeyEvent(this, KeyEvent.KEY_PRESSED, timeStamp, 0, 0, curChar);
        return e;
    }
}

