/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import lejos.nxt.Flash;

public class FileOutputStream
extends OutputStream {
    private int page_pointer;
    private int data_pointer;
    private byte[] buff;
    private boolean append = false;
    File file;

    public FileOutputStream(File f) {
        this(f, false);
    }

    public FileOutputStream(File f, boolean append) {
        this.append = append;
        this.file = f;
        this.buff = new byte[Flash.BYTES_PER_PAGE];
        this.page_pointer = this.file.page_location;
        this.data_pointer = 0;
        if (append) {
            this.page_pointer = this.file.page_location + this.file.file_length / Flash.BYTES_PER_PAGE;
            this.data_pointer = this.file.file_length % Flash.BYTES_PER_PAGE;
            Flash.readPage(this.buff, this.page_pointer);
        } else {
            this.file.file_length = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.file.page_location < 0) {
            throw new IOException();
        }
        this.buff[this.data_pointer] = (byte)b;
        ++this.data_pointer;
        ++this.file.file_length;
        if (this.data_pointer >= Flash.BYTES_PER_PAGE) {
            if (this.file.getIndex() < File.totalFiles - 1) {
                this.file.moveToTop();
                this.page_pointer = this.file.page_location + this.file.file_length / Flash.BYTES_PER_PAGE;
            }
            this.flush();
            ++this.page_pointer;
            this.data_pointer = 0;
        }
    }

    public void flush() throws IOException {
        Flash.writePage(this.buff, this.page_pointer);
    }

    public void close() throws IOException {
        this.flush();
        File.writeTable(File.listFiles());
        this.page_pointer = this.file.page_location;
        this.data_pointer = 0;
    }
}

