/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import lejos.nxt.Flash;

public class File {
    private static final byte READ_ONLY_ATTR = 1;
    private static final byte HIDDEN_ATTR = 2;
    public static final byte MAX_FILES = 30;
    private static final byte MAX_FILENAME = 30;
    private static final String TABLE_ID = "V_0.4";
    private static byte TABLE_START_PAGE = 1;
    private static byte FILE_TABLE_PAGES = (byte)2;
    private static byte FILE_START_PAGE = (byte)(TABLE_START_PAGE + FILE_TABLE_PAGES);
    private static byte NUM_FILES_POS = (byte)"V_0.4".length();
    private static byte[] buff = new byte[Flash.BYTES_PER_PAGE];
    static File[] files = null;
    public static byte totalFiles = (byte)-1;
    private static char[] charBuff = new char[30];
    private String file_name;
    short page_location = (short)-1;
    int file_length;
    boolean exists = false;
    byte file_attributes;
    private static short page_pointer;
    private static short byte_pointer;

    public File(String name) {
        this(name, true);
    }

    private File(String name, boolean checkExists) {
        if (!File.tableExists()) {
            File.format();
        }
        this.file_name = name;
        if (files == null) {
            files = new File[30];
            File.readTable(files);
        }
        if (checkExists) {
            for (byte i = 0; i < totalFiles; i = (byte)(i + 1)) {
                if (!File.files[i].file_name.equals(this.file_name)) continue;
                this.file_length = File.files[i].file_length;
                this.page_location = File.files[i].page_location;
                this.exists = true;
                File.files[i] = this;
            }
        } else {
            this.exists = true;
        }
    }

    public boolean delete() {
        if (!this.exists()) {
            return false;
        }
        byte index = -1;
        for (byte i = 0; i < totalFiles; i = (byte)(i + 1)) {
            if (!File.files[i].file_name.equals(this.file_name)) continue;
            index = i;
        }
        totalFiles = (byte)(totalFiles - 1);
        if (files[index + 1] != null) {
            while (index <= totalFiles) {
                File.files[index] = files[index + 1];
                index = (byte)(index + 1);
            }
        } else {
            File.files[index] = null;
        }
        try {
            File.writeTable(files);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.exists = false;
        this.file_length = 0;
        return true;
    }

    public void exec() {
        Flash.exec(this.page_location, this.file_length);
    }

    public static File[] listFiles() {
        if (files == null) {
            files = new File[30];
            File.readTable(files);
        }
        return files;
    }

    public String getName() {
        return this.file_name;
    }

    public int length() {
        return this.file_length;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return (this.file_attributes & 1) != 1;
    }

    public boolean isHidden() {
        return (this.file_attributes & 2) == 2;
    }

    public boolean setReadOnly() {
        this.file_attributes = (byte)(this.file_attributes | 1);
        return true;
    }

    static void readTable(File[] files) {
        if (!File.tableExists()) {
            File.format();
        }
        File.resetTablePointer();
        Flash.readPage(buff, TABLE_START_PAGE);
        byte_pointer = NUM_FILES_POS;
        totalFiles = File.readNextByte();
        for (int i = 0; i < totalFiles; ++i) {
            short pageLocation = (short)(0xFF & File.readNextByte() | (0xFF & File.readNextByte()) << 8);
            int fileLength = 0xFF & File.readNextByte() | (0xFF & File.readNextByte()) << 8 | (0xFF & File.readNextByte()) << 16 | (0xFF & File.readNextByte()) << 24;
            byte fileAttributes = File.readNextByte();
            if (files[i] == null) {
                int numChars = File.readNextByte();
                for (int j = 0; j < numChars; ++j) {
                    File.charBuff[j] = (char)File.readNextByte();
                }
                String name = new String(charBuff, 0, numChars);
                files[i] = new File(name, false);
            }
            files[i].page_location = pageLocation;
            files[i].file_length = fileLength;
            files[i].file_attributes = fileAttributes;
        }
    }

    private static byte readNextByte() {
        if (byte_pointer >= Flash.BYTES_PER_PAGE) {
            page_pointer = (short)(page_pointer + 1);
            byte_pointer = 0;
            Flash.readPage(buff, page_pointer);
        }
        short s = byte_pointer;
        byte_pointer = (short)(s + 1);
        return buff[s];
    }

    static void writeTable(File[] files) throws IOException {
        File.resetTablePointer();
        for (int i = 0; i < TABLE_ID.length(); ++i) {
            File.writeNextByte((byte)TABLE_ID.charAt(i));
        }
        File.writeNextByte((byte)0);
        int arrayIndex = 0;
        if (files != null && files.length != 0) {
            while (files[arrayIndex] != null && files[arrayIndex].file_length != -999) {
                try {
                    File.writeNextByte((byte)files[arrayIndex].page_location);
                    File.writeNextByte((byte)(files[arrayIndex].page_location >> 8));
                    File.writeNextByte((byte)files[arrayIndex].file_length);
                    File.writeNextByte((byte)(files[arrayIndex].file_length >> 8));
                    File.writeNextByte((byte)(files[arrayIndex].file_length >> 16));
                    File.writeNextByte((byte)(files[arrayIndex].file_length >> 24));
                    File.writeNextByte(files[arrayIndex].file_attributes);
                    File.writeNextByte((byte)files[arrayIndex].file_name.length());
                    for (int i = 0; i < files[arrayIndex].file_name.length(); ++i) {
                        File.writeNextByte((byte)files[arrayIndex].file_name.charAt(i));
                    }
                }
                catch (IOException e) {
                    File.writeBufftoFlash();
                    Flash.readPage(buff, TABLE_START_PAGE);
                    File.buff[File.NUM_FILES_POS] = arrayIndex;
                    totalFiles = (byte)arrayIndex;
                    Flash.writePage(buff, TABLE_START_PAGE);
                    throw e;
                }
                if ((arrayIndex = (int)((byte)(arrayIndex + 1))) < files.length) continue;
            }
        }
        File.writeBufftoFlash();
        Flash.readPage(buff, TABLE_START_PAGE);
        File.buff[File.NUM_FILES_POS] = arrayIndex;
        totalFiles = (byte)arrayIndex;
        Flash.writePage(buff, TABLE_START_PAGE);
    }

    private static void writeNextByte(byte value) throws IOException {
        if (byte_pointer >= Flash.BYTES_PER_PAGE) {
            File.writeBufftoFlash();
            page_pointer = (short)(page_pointer + 1);
            if (page_pointer >= FILE_TABLE_PAGES) {
                File.dumpFileTable();
                throw new IOException("File table is full. Try deleting some files.");
            }
            byte_pointer = 0;
        }
        File.buff[File.byte_pointer] = value;
        byte_pointer = (short)(byte_pointer + 1);
    }

    public static void dumpFileTable() {
        if (files == null) {
            File.listFiles();
        }
    }

    private static void writeBufftoFlash() {
        Flash.writePage(buff, page_pointer);
    }

    private static void resetTablePointer() {
        page_pointer = TABLE_START_PAGE;
        byte_pointer = 0;
    }

    public static void format() {
        for (int i = 0; i < TABLE_ID.length(); ++i) {
            File.buff[i] = (byte)TABLE_ID.charAt(i);
        }
        File.buff[File.NUM_FILES_POS] = 0;
        Flash.writePage(buff, TABLE_START_PAGE);
        files = null;
    }

    public boolean createNewFile() throws IOException {
        if (this.exists()) {
            return false;
        }
        if (files == null) {
            files = new File[30];
            File.readTable(files);
        }
        if (totalFiles > 0) {
            this.page_location = File.files[File.totalFiles - 1].page_location;
            int prevFileSize = File.files[File.totalFiles - 1].file_length;
            if (prevFileSize == 0) {
                prevFileSize = 1;
            }
            int pages = prevFileSize / Flash.BYTES_PER_PAGE;
            if (prevFileSize % Flash.BYTES_PER_PAGE != 0) {
                ++pages;
            }
            this.page_location = (short)(this.page_location + pages);
        } else {
            this.page_location = FILE_START_PAGE;
        }
        File.files[File.totalFiles] = this;
        File.writeTable(files);
        this.exists = true;
        return true;
    }

    private void moveTo(int page) throws IOException {
        int nrPages = this.file_length / Flash.BYTES_PER_PAGE;
        if (this.file_length % Flash.BYTES_PER_PAGE > 0) {
            ++nrPages;
        }
        int from = this.page_location;
        int to = page;
        this.page_location = (short)page;
        for (int i = 0; i < nrPages; ++i) {
            Flash.readPage(buff, from++);
            Flash.writePage(buff, to++);
        }
        File.writeTable(files);
    }

    public void moveToTop() throws IOException {
        File top = files[totalFiles - 1];
        int page = 1 + top.getPage() + top.length() / Flash.BYTES_PER_PAGE;
        int length = this.file_length;
        this.moveTo(page);
        this.delete();
        this.file_length = length;
        this.createNewFile();
    }

    public static int freeMemory() {
        int last_page;
        if (files == null) {
            files = new File[30];
            File.readTable(files);
        }
        if (totalFiles <= 0) {
            last_page = -1;
        } else {
            File top = files[totalFiles - 1];
            last_page = top.getPage() + (top.length() - 1) / Flash.BYTES_PER_PAGE;
        }
        return (703 - last_page) * Flash.BYTES_PER_PAGE;
    }

    public int getIndex() {
        int i;
        for (i = 0; i < totalFiles && this != files[i]; ++i) {
        }
        return i;
    }

    private static boolean tableExists() {
        boolean formatted = true;
        Flash.readPage(buff, TABLE_START_PAGE);
        for (int i = 0; i < TABLE_ID.length(); ++i) {
            if (buff[i] == TABLE_ID.charAt(i)) continue;
            formatted = false;
        }
        return formatted;
    }

    public static void defrag() throws IOException {
        int page_pointer = FILE_START_PAGE;
        for (byte i = 0; i < totalFiles; i = (byte)(i + 1)) {
            File file = files[i];
            if (file.page_location > page_pointer) {
                file.moveTo(page_pointer);
            }
            page_pointer = file.page_location + file.length() / Flash.BYTES_PER_PAGE;
            if (file.length() % Flash.BYTES_PER_PAGE <= 0) continue;
            ++page_pointer;
        }
        File.writeTable(files);
    }

    public int getPage() {
        return this.page_location;
    }

    public static void reset() {
        files = null;
    }
}

