/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;

public class NXTCommFactory {
    public static final int USB = 1;
    public static final int BLUETOOTH = 2;
    private static String os = System.getProperty("os.name");
    private static String SEP = System.getProperty("file.separator");

    public static NXTComm createNXTComm(int protocol) throws NXTCommException {
        String defaultDriver;
        boolean windows = false;
        boolean mac = false;
        String home = System.getProperty("nxj.home");
        String propFile = null;
        Properties props = new Properties();
        if (home == null) {
            home = System.getenv("NXJ_HOME");
        }
        if (home != null) {
            propFile = home + SEP + "bin" + SEP + "nxj.properties";
        }
        if (propFile != null) {
            try {
                props.load(new FileInputStream(propFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                throw new NXTCommException("Cannot read nxj.properties file");
            }
        }
        if (os.length() >= 7 && os.substring(0, 7).equals("Windows")) {
            windows = true;
        }
        if (os.equals("Mac OS X")) {
            mac = true;
        }
        if ((protocol & 1) != 0) {
            String nxtCommName = props.getProperty("NXTCommUSB", "lejos.pc.comm.NXTCommLibnxt");
            try {
                Class<?> c = Class.forName(nxtCommName);
                return (NXTComm)c.newInstance();
            }
            catch (Throwable t) {
                throw new NXTCommException("Cannot load USB driver");
            }
        }
        String string = defaultDriver = windows || mac ? "lejos.pc.comm.NXTCommBluecove" : "lejos.pc.comm.NXTCommBluez";
        if ((protocol & 2) != 0) {
            String nxtCommName = props.getProperty("NXTCommBluetooth", defaultDriver);
            try {
                Class<?> c = Class.forName(nxtCommName);
                return (NXTComm)c.newInstance();
            }
            catch (Throwable t) {
                throw new NXTCommException("Cannot load Bluetooth driver");
            }
        }
        return null;
    }
}

