/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import js.tinyvm.ConstantValue;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;

public class ConstantRecord
implements WritableData {
    Constant _constant;
    ConstantValue _constantValue;
    boolean isUsed = false;

    public ConstantRecord(ConstantPool pool, Constant constant) {
        this._constantValue = new ConstantValue(pool, constant);
    }

    public ConstantValue constantValue() {
        assert (this._constantValue != null) : "Postconditon: result != null";
        return this._constantValue;
    }

    public boolean equals(Object object) {
        return object instanceof ConstantRecord && this._constantValue.value().equals(((ConstantRecord)object)._constantValue.value());
    }

    public int hashCode() {
        return this._constantValue.value().hashCode();
    }

    public int getLength() {
        return IOUtilities.adjustedSize(4, 2);
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        assert (writer != null) : "Precondition: writer != null";
        try {
            writer.writeU2(this._constantValue.getOffset());
            writer.writeU1(this._constantValue.getType().type());
            writer.writeU1(this._constantValue.getLength());
            IOUtilities.writePadding(writer, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public void markUsed() {
        this.isUsed = true;
    }

    public boolean used() {
        return this.isUsed;
    }
}

