/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.ConstantRecord;
import js.tinyvm.MethodRecord;
import js.tinyvm.OpCodeConstants;
import js.tinyvm.OpCodeInfo;
import js.tinyvm.Signature;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;

public class CodeUtilities
implements OpCodeConstants,
OpCodeInfo {
    String iFullName;
    JavaClass iCF;
    Binary iBinary;

    public CodeUtilities(String aMethodName, JavaClass aCF, Binary aBinary) {
        this.iFullName = CodeUtilities.fullMethod(aCF, aMethodName);
        this.iCF = aCF;
        this.iBinary = aBinary;
    }

    public void exitOnBadOpCode(int aOpCode) throws TinyVMException {
        throw new TinyVMException("Unsupported " + OPCODE_NAME[aOpCode] + " in " + this.iFullName + ".\n" + "The following features/conditions are currently unsupported:\n" + "- Arithmetic or logical operations on variables of type long.\n" + "- Remainder operations on floats or doubles.\n" + "- Too many locals ( > 255).\n" + "- Too many constants ( > 1024).\n" + "- Too many static fields ( > 1024).\n" + "- Method code too long ( > 64 Kb!).\n" + "");
    }

    public static String fullMethod(JavaClass aCF, String aMethodName) {
        return aCF.getClassName() + ":" + aMethodName;
    }

    public int processConstantIndex(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantInteger || pEntry instanceof ConstantFloat || pEntry instanceof ConstantString || pEntry instanceof ConstantDouble || pEntry instanceof ConstantLong)) {
            throw new TinyVMException("Classfile error: LDC-type instruction does not refer to a suitable constant. ");
        }
        ConstantRecord pRecord = new ConstantRecord(this.iCF.getConstantPool(), pEntry);
        int pIdx = this.iBinary.getConstantIndex(pRecord);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-2: Didn't find constant " + pEntry + " of class " + this.iCF.getClassName());
        }
        return pIdx;
    }

    public int processClassIndex(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantClass)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantClass pClassEntry = (ConstantClass)pEntry;
        String pClassName = pClassEntry.getBytes(this.iCF.getConstantPool());
        if (pClassName.startsWith("[")) {
            throw new TinyVMException("In " + this.iFullName + ": Operations instanceof or " + "checkcast on array classes (" + pClassName + " in this case) are not yet supported by TinyVM.");
        }
        int pIdx = this.iBinary.getClassIndex(pClassName);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pEntry + " from class " + this.iCF.getClassName());
        }
        return pIdx;
    }

    public int processMultiArray(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantClass)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantClass pClassEntry = (ConstantClass)pEntry;
        int[] pTypeDim = CodeUtilities.getTypeAndDimensions(pClassEntry.getBytes(this.iCF.getConstantPool()));
        assert (pTypeDim[0] <= 255) : "Check: correct type";
        assert (pTypeDim[1] > 0 && pTypeDim[1] <= 255) : "Check: correct dimension";
        return pTypeDim[0] << 8 | pTypeDim[1];
    }

    public static int[] getTypeAndDimensions(String aMultiArrayDesc) {
        int i = 0;
        while (aMultiArrayDesc.charAt(i) == '[') {
            ++i;
        }
        return new int[]{Utility.typeOfSignature((String)aMultiArrayDesc.substring(i)), i};
    }

    int processField(int aFieldIndex, boolean aStatic) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.iBinary.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + className + " from class " + this.iCF.getClassName());
        }
        ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pFieldEntry.getNameAndTypeIndex());
        String pName = cnat.getName(this.iCF.getConstantPool());
        if (aStatic) {
            int pClassIndex = this.iBinary.getClassIndex(pClassRecord);
            assert (pClassIndex >= 0 && pClassIndex <= 255) : "Check: class index in range";
            int pFieldIndex = pClassRecord.getStaticFieldIndex(pName);
            assert (pFieldIndex >= 0 && pFieldIndex <= 1023) : "Check: field index in range";
            return pClassIndex << 16 | pFieldIndex;
        }
        int pOffset = pClassRecord.getInstanceFieldOffset(pName);
        if (pOffset == -1) {
            throw new TinyVMException("Error: Didn't find field " + className + ":" + pName + " from class " + this.iCF.getClassName());
        }
        assert (pOffset <= 4095) : "Check: field offset in range";
        TinyVMType fieldType = TinyVMType.tinyVMTypeFromSignature(cnat.getSignature(this.iCF.getConstantPool()));
        return fieldType.type() << 12 | pOffset;
    }

    public void markClass(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantClass)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantClass pClassEntry = (ConstantClass)pEntry;
        String pClassName = pClassEntry.getBytes(this.iCF.getConstantPool());
        ClassRecord pClassRecord = this.iBinary.getClassRecord(pClassName);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pClassName + " from class " + this.iCF.getClassName());
        }
        this.iBinary.markClassUsed(pClassRecord);
    }

    void markStaticField(int aFieldIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.iBinary.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + className + " from class " + this.iCF.getClassName());
        }
        ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pFieldEntry.getNameAndTypeIndex());
        String pName = cnat.getName(this.iCF.getConstantPool());
        this.iBinary.markClassUsed(pClassRecord);
        pClassRecord.getStaticFieldRecord(pName).markUsed();
    }

    int processMethod(int aMethodIndex, boolean aSpecial) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aMethodIndex);
        if (!(pEntry instanceof ConstantCP)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_MethodRef or CONSTANT_InterfaceMethodRef got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantCP pMethodEntry = (ConstantCP)pEntry;
        String className = pMethodEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.iBinary.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-4: Didn't find class " + className + " from class " + this.iCF.getClassName());
        }
        ConstantNameAndType pNT = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pMethodEntry.getNameAndTypeIndex());
        Signature pSig = new Signature(pNT.getName(this.iCF.getConstantPool()), pNT.getSignature(this.iCF.getConstantPool()));
        MethodRecord pMethod = pClassRecord.getVirtualMethodRecord(pSig);
        if (pMethod == null) {
            throw new TinyVMException("Method " + pSig + " not found  in " + className);
        }
        ClassRecord pTopClass = pMethod.getClassRecord();
        if (aSpecial) {
            int pClassIndex = this.iBinary.getClassIndex(pTopClass);
            assert (pClassIndex != -1 && pClassIndex < 256) : "Check: class index in range";
            int pMethodIndex = pTopClass.getMethodIndex(pMethod);
            assert (pMethodIndex != -1 && pMethodIndex < 255) : "Check: method index in range";
            return pClassIndex << 8 | pMethodIndex & 0xFF;
        }
        int pNumParams = pMethod.getNumParameterWords() - 1;
        assert (pNumParams < 16) : "Check: number of parameters not to high";
        int pSignature = pMethod.getSignatureId();
        assert (pSignature < 4096) : "Check: signature in range";
        return pNumParams << 12 | pSignature;
    }

    MethodRecord findMethod(int aMethodIndex, boolean aSpecial) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aMethodIndex);
        if (!(pEntry instanceof ConstantCP)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_MethodRef or CONSTANT_InterfaceMethodRef got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantCP pMethodEntry = (ConstantCP)pEntry;
        String className = pMethodEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.iBinary.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-4: Didn't find class " + className + " from class " + this.iCF.getClassName());
        }
        ConstantNameAndType pNT = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pMethodEntry.getNameAndTypeIndex());
        Signature pSig = new Signature(pNT.getName(this.iCF.getConstantPool()), pNT.getSignature(this.iCF.getConstantPool()));
        MethodRecord pMethod = pClassRecord.getVirtualMethodRecord(pSig);
        return pMethod;
    }

    static int getAndCopyFourBytesInt(byte[] aCode, int ix, byte[] pOutCode, int ox) {
        int a = 0;
        a |= (aCode[ix + 0] & 0xFF) << 24;
        a |= (aCode[ix + 1] & 0xFF) << 16;
        a |= (aCode[ix + 2] & 0xFF) << 8;
        a |= (aCode[ix + 3] & 0xFF) << 0;
        for (int i = 0; i < 4; ++i) {
            pOutCode[ox + i] = aCode[ix + i];
        }
        return a;
    }

    static int getFourBytesInt(byte[] aCode, int ix) {
        int a = 0;
        a |= (aCode[ix + 0] & 0xFF) << 24;
        a |= (aCode[ix + 1] & 0xFF) << 16;
        a |= (aCode[ix + 2] & 0xFF) << 8;
        return a |= (aCode[ix + 3] & 0xFF) << 0;
    }

    public byte[] processCode(byte[] aCode) throws TinyVMException {
        byte[] pOutCode = new byte[aCode.length];
        int i = 0;
        block17: while (i < aCode.length) {
            pOutCode[i] = aCode[i];
            int pOpCode = pOutCode[i] & 0xFF;
            ++i;
            switch (pOpCode) {
                case 18: {
                    int constIdx = this.processConstantIndex(aCode[i] & 0xFF);
                    if (constIdx >= 256) {
                        pOutCode[i - 1] = (byte)(219 + (constIdx - 256) / 256);
                        if (constIdx > 1024) {
                            this.exitOnBadOpCode(pOpCode);
                        }
                    }
                    pOutCode[i++] = (byte)constIdx;
                    break;
                }
                case 19: 
                case 20: {
                    int pIdx1 = this.processConstantIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx1 >> 8);
                    pOutCode[i++] = (byte)(pIdx1 & 0xFF);
                    break;
                }
                case 189: {
                    pOutCode[i - 1] = -68;
                    pOutCode[i++] = 0;
                    pOutCode[i++] = 0;
                    break;
                }
                case 197: {
                    int pIdx2 = this.processMultiArray((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx2 >> 8);
                    pOutCode[i++] = (byte)(pIdx2 & 0xFF);
                    pOutCode[i] = aCode[i];
                    ++i;
                    break;
                }
                case 187: 
                case 192: 
                case 193: {
                    int pIdx3 = this.processClassIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    assert (pIdx3 < 256) : "Check: class index in range";
                    pOutCode[i++] = (byte)(pIdx3 >> 8);
                    pOutCode[i++] = (byte)(pIdx3 & 0xFF);
                    break;
                }
                case 178: 
                case 179: {
                    int pWord1 = this.processField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true);
                    pOutCode[i++] = (byte)(pWord1 >> 16);
                    int fldIdx = pWord1 & 0x3FF;
                    if (fldIdx >= 256) {
                        if (fldIdx > 1024) {
                            this.exitOnBadOpCode(pOpCode);
                        }
                        int newOpCode = (aCode[i - 2] & 0xFF) == 179 ? 204 + (fldIdx - 256) / 256 * 2 : 203 + (fldIdx - 256) / 256 * 2;
                        pOutCode[i - 2] = (byte)(newOpCode & 0xFF);
                    }
                    pOutCode[i++] = (byte)(pWord1 & 0xFF);
                    break;
                }
                case 180: 
                case 181: {
                    int pWord2 = this.processField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    int opcode = aCode[i - 1] & 0xFF;
                    byte b0 = (byte)(pWord2 >> 8);
                    byte b1 = (byte)(pWord2 & 0xFF);
                    pOutCode[i - 1] = (byte)opcode;
                    pOutCode[i++] = b0;
                    pOutCode[i++] = b1;
                    break;
                }
                case 185: {
                    pOutCode[i - 1] = -74;
                    int pWord3 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord3 >> 8);
                    pOutCode[i++] = (byte)(pWord3 & 0xFF);
                    pOutCode[i++] = 0;
                    pOutCode[i++] = 0;
                    break;
                }
                case 183: 
                case 184: {
                    int pWord4 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true);
                    pOutCode[i++] = (byte)(pWord4 >> 8);
                    pOutCode[i++] = (byte)(pWord4 & 0xFF);
                    break;
                }
                case 182: {
                    int pWord5 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord5 >> 8);
                    pOutCode[i++] = (byte)(pWord5 & 0xFF);
                    break;
                }
                case 171: {
                    int oi = i;
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                    int npairs = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                    i += 4;
                    oi += 4;
                    for (int k = 0; k < npairs; ++k) {
                        int idx = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                        int off = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                        i += 4;
                        oi += 4;
                    }
                    while (oi < i) {
                        pOutCode[oi++] = 0;
                    }
                    continue block17;
                }
                case 170: {
                    int oi = i;
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                    int low = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                    int hig = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                    i += 4;
                    oi += 4;
                    for (int k = low; k <= hig; ++k) {
                        int idx = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                        i += 4;
                        oi += 4;
                    }
                    while (oi < i) {
                        pOutCode[oi++] = 0;
                    }
                    continue block17;
                }
                case 196: {
                    if ((aCode[i] & 0xFF) == 132 && aCode[i + 1] == 0) {
                        int k = 0;
                        while (k < 5) {
                            pOutCode[i] = aCode[i];
                            ++k;
                            ++i;
                        }
                        continue block17;
                    }
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: 
                case 148: 
                case 200: 
                case 201: {
                    this.exitOnBadOpCode(pOpCode);
                    break;
                }
                case 202: {
                    throw new TinyVMException("Invalid opcode detected: " + pOpCode + " " + OPCODE_NAME[pOpCode]);
                }
                default: {
                    int pArgs = OPCODE_ARGS[pOpCode];
                    if (pArgs == -1) {
                        throw new TinyVMException("Bug CU-1: Got " + pOpCode + " in " + this.iFullName + ".");
                    }
                    for (int ctr = 0; ctr < pArgs; ++ctr) {
                        pOutCode[i + ctr] = aCode[i + ctr];
                    }
                    i += pArgs;
                }
            }
        }
        return pOutCode;
    }

    public void processCalls(byte[] aCode, JavaClass aClassFile, Binary aBinary) throws TinyVMException {
        int i = 0;
        block13: while (i < aCode.length) {
            int pOpCode = aCode[i] & 0xFF;
            ++i;
            switch (pOpCode) {
                case 18: {
                    int constIdx = this.processConstantIndex(aCode[i] & 0xFF);
                    ConstantRecord pRec = this.iBinary.getConstantRecord(constIdx);
                    pRec.markUsed();
                    ++i;
                    break;
                }
                case 19: 
                case 20: {
                    int constIdx = this.processConstantIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    ConstantRecord pRec = this.iBinary.getConstantRecord(constIdx);
                    pRec.markUsed();
                    i += 2;
                    break;
                }
                case 187: 
                case 192: 
                case 193: {
                    this.markClass((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    i += 2;
                    break;
                }
                case 178: 
                case 179: {
                    this.markStaticField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    i += 2;
                    break;
                }
                case 185: {
                    MethodRecord pMeth0 = this.findMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    if (pMeth0 != null) {
                        pMeth0.getClassRecord().markMethod(pMeth0, true);
                    }
                    i += 4;
                    break;
                }
                case 182: {
                    MethodRecord pMeth1 = this.findMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    if (pMeth1 != null) {
                        pMeth1.getClassRecord().markMethod(pMeth1, true);
                    }
                    i += 2;
                    break;
                }
                case 183: 
                case 184: {
                    MethodRecord pMeth2 = this.findMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true);
                    if (pMeth2 != null) {
                        pMeth2.getClassRecord().markMethod(pMeth2, true);
                    }
                    i += 2;
                    break;
                }
                case 171: {
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getFourBytesInt(aCode, i);
                    int npairs = CodeUtilities.getFourBytesInt(aCode, i += 4);
                    i += 4;
                    i += 8 * npairs;
                    break;
                }
                case 170: {
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getFourBytesInt(aCode, i);
                    int low = CodeUtilities.getFourBytesInt(aCode, i += 4);
                    int hig = CodeUtilities.getFourBytesInt(aCode, i += 4);
                    i += 4;
                    for (int k = low; k <= hig; ++k) {
                        i += 4;
                    }
                    continue block13;
                }
                case 196: {
                    if ((aCode[i] & 0xFF) == 132 && aCode[i + 1] == 0) {
                        i += 5;
                        break;
                    }
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: 
                case 148: 
                case 200: 
                case 201: {
                    this.exitOnBadOpCode(pOpCode);
                    break;
                }
                default: {
                    int pArgs = OPCODE_ARGS[pOpCode];
                    if (pArgs == -1) {
                        throw new TinyVMException("Bug CU-1: Got " + pOpCode + " in " + this.iFullName + ".");
                    }
                    i += pArgs;
                }
            }
        }
    }
}

