# -*- coding: utf-8 -*-
#
#  Copyright (C) 2010-2014 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

try:
    import pywapi
except:
    pywapi = None

from ninix.plugin import BasePlugin


class Plugin(BasePlugin):

    def select_city(self):
        script = r'どこの都市?(日本の地名はローマ字で入力)'
        location = self.open_dialog(script)
        self.set_variables({'location': location})
        script = r'\h\s0{0}だね。\e'.format(location)
        self.send_sstp('otenkiyan',
                       script_odict={self.caller['ifghost']: script})
        return location

    def create_message(self):
        error_message = \
          r'\1あっ,\w4エラーになってしもたやん.\n\w4' \
          r'Yahooはん, \w2おとうはんといっしょで\w2かいしょなしやん.\w9\0!?\e'
        location = self.get_variable('location')
        location_id = None
        while location_id is None:
            if location is None:
                location = self.select_city()
            location_ids = pywapi.get_location_ids(location)
            if not location_ids or 'error' in location_ids:
                location = None
                continue
            location_id = list(location_ids.keys())[0]
        data = pywapi.get_weather_from_yahoo(location_id)
        if 'error' in data:
            if data['error'] == 'City not found':
                self.set_variables({'location': None})
                return r'\1{0}は予報が出てないやん.\w9\e'.format(location)
            else:
                return error_message
        if len(self.args) < 1:
            result = r'\1今の'
            conditions = data['condition']
        elif self.args[0] == 'currnet':
            result = r'\1今の'
            conditions = data['condition']
        elif self.args[0] == 'today':
            if len(data['forecasts']) < 1:
                return error_message
            result = r'\1今日の'
            conditions = data['forecasts'][0]
        elif self.args[0] == 'tomorrow':
            if len(data['forecasts']) < 2:
                return error_message
            result = r'\1明日の'
            conditions = data['forecasts'][1]
        else:
            result = r'\1今の'
            conditions = data['condition']
        location = data['location']['city']
        result = ''.join((result, location, r'の'))
        if 'text' not in conditions:
            return error_message
        else:
            condition = conditions['text']
        result = ''.join((result, r'てんきはな, \w9'))
        result = ''.join((result, condition, r'やん.\n\w9'))
        if 'temp_c' in conditions:
            try:
                temp_c = int(conditions['temp_c'])
            except:
                return error_message
            else:
                if temp_c <= 15:
                    result = ''.join((result, r'さむいやん.'))
                elif 15 < temp_c < 25:
                    result = ''.join((result, r'すごしやすそうやん.'))
                elif temp_c >= 25:
                    result = ''.join((result, r'あつそうやん.'))
        elif 'high' in conditions and 'low' in conditions:
            try:
                high = int(conditions['high'])
                low = int(conditions['low'])
            except:
                return error_message
            else:
                if high - low > 10:
                    result = ''.join((result,
                                      r'いやー,\w4 ' \
                                      r'あつなったりさむなったり,\w2 ' \
                                      r'きついわぁ.'))
                else:
                    result = ''.join((result,
                                      r'あつささむさもひがんまでやん.'))
        result = ''.join((result, r'\0!?\e'))
        return result

    def run(self):
        if pywapi is None:
            raise(SystemExit,
                  'Need pywapi - ' \
                  'Python Weather API from ' \
                  'http://code.google.com/p/python-weather-api/.')
        if len(self.args) > 0 and self.args[0] == 'area':
            location = self.select_city()
            return
        script = self.create_message()
        self.send_sstp('otenkiyan',
                       script_odict={self.caller['ifghost']: script})
        return script


if __name__ == "__main__":
    otenkiyan = Plugin(None, None, [], None, None, None, None)
    result = otenkiyan.run()
    print(result)
    print(dir(otenkiyan))
