﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//using System.Reflection;
using System.Linq;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _202顧客一覧 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // 内部クラス
        ////////////////////////////////////////////////////////////////////////
        #region CSV取込処理内部クラス

        private class 取込処理内部クラス : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    顧客ID = 0,
			//    氏名 = 1,
			//    氏名カナ = 2,
			//    性別 = 3,
			//    生年月日 = 4,
			//    郵便番号 = 5,
			//    住所 = 6,
			//    TEL = 7,
			//    メールアドレス = 8,
			//    メルマガ許諾 = 9,
			//    備考 = 10
			//}
			private static class CSV取込列
			{
				public const byte byt新規 = 0;
                public const byte byt顧客ID = 0;
                public const byte byt氏名 = 1;
                public const byte byt氏名カナ = 2;
                public const byte byt性別 = 3;
                public const byte byt生年月日 = 4;
                public const byte byt郵便番号 = 5;
                public const byte byt住所 = 6;
                public const byte bytTEL = 7;
                public const byte bytメールアドレス = 8;
                public const byte bytメルマガ許諾 = 9;
				public const byte byt備考 = 10;
			}

            protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt備考 + 1;
            }

            //必須入力、桁数、書式検証
            protected override bool 基底CSV取込クラスからの検証(int rowIndex, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.byt顧客ID:
                        if (!IsValidate共通(value, true, C_最大文字数.顧客ID, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_顧客ID))
                            return false;

                        ////DB重複チェック
                        //if (!IsExsist顧客ID(value, ((enmCSV取込列)colIndex).ToString()))
                        //    return false;

                        break;

                    case CSV取込列.byt氏名:
                        if (!IsValidate共通(value, false, C_最大文字数.氏名, C_正規表現.なし
                            , Properties.Resources.DGV列名_氏名))
                            return false;

                        break;

                    case CSV取込列.byt氏名カナ:
                        if (!IsValidate共通(value, false, C_最大文字数.氏名カナ, C_正規表現.全角カタカナ
                            , Properties.Resources.DGV列名_氏名カナ))
                            return false;

                        break;

                    case CSV取込列.byt性別:
                        if (!IsValidate共通(value, false, C_最大文字数.性別, C_正規表現.なし
                            , Properties.Resources.DGV列名_性別))
                            return false;

                        break;

                    case CSV取込列.byt生年月日:
                        if (!IsValidate共通(value, true, C_最大文字数.年月日, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_生年月日))
                            return false;

                        // 日付型チェック
                        DateTime dt;
                        if (DateTime.TryParse(value, out dt) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aが日付として正しくありません
                                , Properties.Resources.DGV列名_生年月日);
                            return false;
                        }

                        // 日付範囲チェック
                        if (dt.Year < C_最小値.年 || C_最大値.年 < dt.Year)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_B_C年以外の値を_入力できません
                                , Properties.Resources.DGV列名_生年月日, C_最小値.年, C_最大値.年);
                            return false;
                        }

                        break;

                    case CSV取込列.byt郵便番号:
                        if (!IsValidate共通(value, false, C_最大文字数.郵便番号, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_郵便番号))
                            return false;

                        break;

                    case CSV取込列.byt住所:
                        if (!IsValidate共通(value, false, C_最大文字数.住所, C_正規表現.なし
                            , Properties.Resources.DGV列名_住所))
                            return false;

                        break;

                    case CSV取込列.bytTEL:
                        if (!IsValidate共通(value, false, C_最大文字数.TEL, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_TEL))
                            return false;

                        break;

                    case CSV取込列.bytメールアドレス:
                        if (!IsValidate共通(value, false, C_最大文字数.メールアドレス, C_正規表現.メールアドレス
                            , Properties.Resources.DGV列名_メールアドレス))
                            return false;

                        break;

                    case CSV取込列.bytメルマガ許諾:
                        if (!IsValidate共通(value, false, C_最大文字数.メルマガ許諾, C_正規表現.なし
                            , Properties.Resources.DGV列名_メルマガ許諾))
                            return false;

                        break;

                    case CSV取込列.byt備考:
                        if (!IsValidate共通(value, false, C_最大文字数.備考, C_正規表現.なし
                            , Properties.Resources.DGV列名_備考))
                            return false;

                        break;
                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int rowIndex, List<string> values, DataTable dt)
            {
                D10顧客.D10顧客DataTable dt顧客 = (D10顧客.D10顧客DataTable)dt;
                D10顧客.D10顧客Row row = dt顧客.NewD10顧客Row();

                row.新規 = true;   // チェック有り
                row.顧客ID = values[CSV取込列.byt顧客ID];
                row.氏名 = values[CSV取込列.byt氏名];
                row.氏名カナ = values[CSV取込列.byt氏名カナ];
                row.性別 = values[CSV取込列.byt性別];
                row.生年月日 = DateTime.Parse(values[CSV取込列.byt生年月日]);
                row.郵便番号 = values[CSV取込列.byt郵便番号];
                row.住所 = values[CSV取込列.byt住所];
                row.TEL = values[CSV取込列.bytTEL];
                row.メールアドレス = values[CSV取込列.bytメールアドレス];
                row.メルマガ許諾名 = values[CSV取込列.bytメルマガ許諾];
                row.備考 = values[CSV取込列.byt備考];

                dt顧客.AddD10顧客Row(row);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        private class 検索条件
        {
            public string 顧客ID { get; set; }
            public string 氏名 { get; set; }
            public string 氏名カナ { get; set; }
            public Nullable<int> 性別 { get; set; }
            public Nullable<DateTime> 生年月日 { get; set; }
            public string 郵便番号 { get; set; }
            public string 住所 { get; set; }
            public string TEL { get; set; }
            public string メールアドレス { get; set; }
            public Nullable<int> メルマガ許諾 { get; set; }
            public Nullable<int>[] 購入済み商品No { get; set; }
        }

		//public enum enm顧客リストCell : int
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    顧客No = 3,
		//    顧客ID = 4,
		//    氏名 = 5,
		//    氏名カナ = 6,
		//    性別 = 7,
		//    生年月日 = 8,
		//    郵便番号 = 9,
		//    住所 = 10,
		//    TEL = 11,
		//    メールアドレス = 12,
		//    メルマガ許諾 = 13,
		//    備考 = 14
		//}
		private static class 顧客リストCell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte byt顧客No = 3;
            public const byte byt顧客ID = 4;
            public const byte byt氏名 = 5;
            public const byte byt氏名カナ = 6;
            public const byte byt性別 = 7;
            public const byte byt生年月日 = 8;
            public const byte byt郵便番号 = 9;
            public const byte byt住所 = 10;
            public const byte bytTEL = 11;
            public const byte bytメールアドレス = 12;
            public const byte bytメルマガ許諾 = 13;
			public const byte byt備考 = 14;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _202顧客一覧()
        {
            InitializeComponent();

            Set表示項目();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド Static

		//最終行でかつ全項目未入力となっているかを返す
		private static bool 最終行or全項目未入力(DataGridView dgv, int iRow)
		{
			if ((dgv.RowCount - 1) != iRow)
				return false;

			if ((dgv.Rows[iRow].Cells[顧客リストCell.byt顧客ID].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.byt氏名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.byt性別].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.byt生年月日].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.byt郵便番号].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.byt住所].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.bytTEL].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.bytメールアドレス].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.bytメルマガ許諾].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[iRow].Cells[顧客リストCell.byt備考].FormattedValue.ToString() == string.Empty))
			{
				return true;
			}

			return false;
		}

		private static bool IsValidateDGV顧客リスト(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力(dgv, iRow))
				return ret;

			for (int iCol = 0; iCol < dgv.ColumnCount; iCol++)
			{
				string value = dgv.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case 顧客リストCell.byt顧客ID:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell禁止文字(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell半角入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 顧客リストCell.byt氏名カナ:
						if (value == string.Empty)
							break;

						if (!C11ValidateOnForm.IsValidateCell全角カナ(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 顧客リストCell.byt生年月日:
						if (value == string.Empty)
						{
							dgv.Rows[iRow].Cells[顧客リストCell.byt生年月日].Value = DateTime.Parse("1900/1/1");
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell日時型(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 顧客リストCell.byt郵便番号:
					case 顧客リストCell.bytTEL:
						if (value == string.Empty)
							break;

						if (!C11ValidateOnForm.IsValidateCell半角入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 顧客リストCell.bytメールアドレス:
						if (value == string.Empty)
							break;

						if (!C11ValidateOnForm.IsValidateCellメールアドレス(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;
				}
			}
			return ret;
		}

		//全項目未入力となっているかを返す
		private static bool IsValidate未入力行(DataGridViewRow row)
		{
			if ((row.Cells[顧客リストCell.byt顧客No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt顧客ID].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt氏名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt氏名カナ].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt性別].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt生年月日].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt郵便番号].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt住所].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.bytTEL].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.bytメールアドレス].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.bytメルマガ許諾].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[顧客リストCell.byt備考].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}

		//入力値検証
		private static bool IsValidate新規変更削除チェック状態(DataGridView dgv, string strFormTitle)
		{
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力(dgv, iRow) == true)
					continue;

				if ((Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt新規].Value == false &&
					(Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt変更].Value == false &&
					(Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt削除].Value == false)
					continue;

				string strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow
					, 顧客リストCell.byt新規, 顧客リストCell.byt変更, 顧客リストCell.byt削除
					, 顧客リストCell.byt顧客No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}


		//private byte Get性別(string str性別)
		//{
		//    byte bt性別 = 1; // 男性/女性 以外を初期値にする
		//    if (str性別 == "男性")
		//        bt性別 = 2;
		//    else if (str性別 == "女性")
		//        bt性別 = 3;

		//    return bt性別;
		//}

		/// <summary>
		///顧客IDの重複チェック
		/// </summary>
		/// <returns></returns>
		private static bool IsValidate重複チェック(DataGridView dgv, string strFormTitle)
		{
			// 仮想の更新済みTableを用意。
			D10顧客.D10顧客DataTable dt顧客 = new D10顧客.D10顧客DataTable();
			D10顧客TableAdapters.D10顧客ta d10顧客ta = new D10顧客TableAdapters.D10顧客ta();

			d10顧客ta.FillBy検索(dt顧客, null, null, null, null, null, null, null, null, null, null, null, null, null);

			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力(dgv, iRow) == true)
					continue;

				if ((Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt新規].Value == true)
				{
					D10顧客.D10顧客Row row顧客;
					row顧客 = dt顧客.NewD10顧客Row();
					row顧客.顧客ID = dgv.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString();
					dt顧客.AddD10顧客Row(row顧客);
				}
				else if ((Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt変更].Value == true)
				{
					DataRow[] dr顧客 = dt顧客.Select(Properties.Resources.DGV列名_顧客No + " = "
						+ dgv.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString());
					((D10顧客.D10顧客Row)dr顧客[0]).顧客ID
						= dgv.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString();
				}
				else if ((Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt削除].Value == true)
				{
					DataRow[] dr顧客 = dt顧客.Select(Properties.Resources.DGV列名_顧客No + " = "
						+ dgv.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString());
					dr顧客[0].Delete();
				}
			}

			// 顧客IDが重複していないかチェック。
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力(dgv, iRow) == true)
					continue;

				if ((Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt新規].Value == true ||
					(Boolean)dgv.Rows[iRow].Cells[顧客リストCell.byt変更].Value == true)
				{
					DataRow[] dr顧客 = dt顧客.Select(Properties.Resources.DGV列名_顧客ID + " = '"
						+ dgv.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString() + "'");
					if (dr顧客.Length <= 1)
						continue;

					string errmsg = string.Format(Properties.Resources.MSG_W_A行目の顧客IDが_他の顧客IDと重複しています
						, (iRow + 1).ToString());
					MessageBox.Show(errmsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		private void 検索実行(ref int iCnt)
		{
			d10顧客bs.DataSource = null;

			検索条件 row = Get検索条件();

			//検索実行
			d10顧客ta.FillBy検索(d10顧客._D10顧客
								, row.顧客ID
								, row.氏名
								, row.氏名カナ
								, row.性別
								, row.生年月日
								, row.郵便番号
								, row.住所
								, row.TEL
								, row.メールアドレス
								, row.メルマガ許諾
								, row.購入済み商品No[0]
								, row.購入済み商品No[1]
								, row.購入済み商品No[2]);

			iCnt = d10顧客._D10顧客.Rows.Count;
		}

		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅()
        {
            dgv顧客リスト.Columns[顧客リストCell.byt新規].Visible = false;
            dgv顧客リスト.Columns[顧客リストCell.byt変更].Visible = false;
            dgv顧客リスト.Columns[顧客リストCell.byt削除].Width = C_列幅.削除;
            dgv顧客リスト.Columns[顧客リストCell.byt顧客No].Visible = false;
            dgv顧客リスト.Columns[顧客リストCell.byt顧客ID].Width = C_列幅.顧客ID;
            dgv顧客リスト.Columns[顧客リストCell.byt氏名].Width = C_列幅.氏名;
            dgv顧客リスト.Columns[顧客リストCell.byt氏名カナ].Width = C_列幅.氏名カナ;
            dgv顧客リスト.Columns[顧客リストCell.byt性別].Width = C_列幅.性別;
            dgv顧客リスト.Columns[顧客リストCell.byt生年月日].Width = C_列幅.年月日;
            dgv顧客リスト.Columns[顧客リストCell.byt郵便番号].Width = C_列幅.郵便番号;
            dgv顧客リスト.Columns[顧客リストCell.byt住所].Width = C_列幅.住所;
            dgv顧客リスト.Columns[顧客リストCell.bytTEL].Width = C_列幅.TEL;
            dgv顧客リスト.Columns[顧客リストCell.bytメールアドレス].Width = C_列幅.メールアドレス;
            dgv顧客リスト.Columns[顧客リストCell.bytメルマガ許諾].Width = C_列幅.メルマガ許諾;
            dgv顧客リスト.Columns[顧客リストCell.byt備考].Width = C_列幅.備考;
        }

        //検索で使用するSQLパラメータの取得
        private 検索条件 Get検索条件()
        {
            検索条件 row = new 検索条件();

            if (txt顧客ID.Text == "")
                row.顧客ID = null;
            else
                row.顧客ID = txt顧客ID.Text;

            if (txt氏名.Text == "")
                row.氏名 = null;
            else
                row.氏名 = txt氏名.Text;

            if (txt氏名カナ.Text == "")
                row.氏名カナ = null;
            else
                row.氏名カナ = txt氏名カナ.Text;

            if (cmb性別.Text == "")
                row.性別 = null;
            else
                row.性別 = (int)cmb性別.SelectedValue;

            if (dtp生年月日.Checked == true)
                row.生年月日 = dtp生年月日.Value.Date;
            else
                row.生年月日 = null;

            if (txt郵便番号.Text == "")
                row.郵便番号 = null;
            else
                row.郵便番号 = txt郵便番号.Text;

            if (txt住所.Text == "")
                row.住所 = null;
            else
                row.住所 = txt住所.Text;

            if (txtTEL.Text == "")
                row.TEL = null;
            else
                row.TEL = txtTEL.Text;

            if (txtメールアドレス.Text == "")
                row.メールアドレス = null;
            else
                row.メールアドレス = txtメールアドレス.Text;

            if (cmbメルマガ許諾.Text == "")
                row.メルマガ許諾 = null;
            else
                row.メルマガ許諾 = (int)cmbメルマガ許諾.SelectedValue;
            //row.メルマガ許諾 = C02業務共通処理.Getメルマガ許諾No(cmbメルマガ許諾.Text);

            row.購入済み商品No = new Nullable<int>[3];
            if (txt購入済み商品.Tag == null)
            {
                row.購入済み商品No[0] = null;
                row.購入済み商品No[1] = null;
                row.購入済み商品No[2] = null;
            }
            else
            { 
                string[] strTmp = ((string)txt購入済み商品.Tag).Split(',');

                //if (strTmp.Length == 0)
                //{
                //    row.購入済み商品No[0] = null;
                //    row.購入済み商品No[1] = null;
                //    row.購入済み商品No[2] = null;
                //}
                //else if (strTmp.Length == 1)
                if (strTmp.Length == 1)
                {
                    row.購入済み商品No[0] = int.Parse(strTmp[0]);
                    row.購入済み商品No[1] = null;
                    row.購入済み商品No[2] = null;
                }
                else if (strTmp.Length == 2)
                {
                    row.購入済み商品No[0] = int.Parse(strTmp[0]);
                    row.購入済み商品No[1] = int.Parse(strTmp[1]);
                    row.購入済み商品No[2] = null;
                }
                else
                {
                    int i = int.Parse(strTmp[0]);
                    row.購入済み商品No[0] = int.Parse(strTmp[0]);
                    row.購入済み商品No[1] = int.Parse(strTmp[1]);
                    row.購入済み商品No[2] = int.Parse(strTmp[2]);
                }
            }

            return (row);
        }


        //入力値検証
        private bool IsValidate検索()
        {
            if (txt顧客ID.Text != "")
            {
				if (C11ValidateOnForm.IsValidate半角英数(txt顧客ID.Text, Properties.Resources.DGV列名_顧客ID)
                    == false)
                    return false;
            }

            if (txt氏名カナ.Text != "")
            {
				if (C11ValidateOnForm.IsValidate全角カナ型(txt氏名カナ.Text, Properties.Resources.DGV列名_氏名カナ)
                    == false)
                    return false;
            }

            if (txt郵便番号.Text != "")
            {
				if (C11ValidateOnForm.IsValidate半角英数(txt郵便番号.Text, Properties.Resources.DGV列名_郵便番号)
                    == false)
                    return false;
            }

            if (txtTEL.Text != "")
            {
				if (C11ValidateOnForm.IsValidate半角英数(txtTEL.Text, Properties.Resources.DGV列名_TEL)
                    == false)
                    return false;
            }

            if (txtメールアドレス.Text != "")
            {
				if (C11ValidateOnForm.IsValidate半角英数(txtメールアドレス.Text, Properties.Resources.DGV列名_メールアドレス)
                    == false)
                    return false;
            }

            return true;
        }

        //入力値検証
        private bool IsValidate()
        {
            //最大登録件数チェック
            D10顧客.D10顧客Row[] dr = (D10顧客.D10顧客Row[])d10顧客._D10顧客.Select(Properties.Resources.DGV列名_新規 + " = true");
            //int intCnt = (int)d10顧客ta.Scalar顧客Cnt() + dr.Length;
            //if (intCnt > C_最大値.登録件数)
            //{
            //    string msg = string.Format(Properties.Resources.MSG_INF_101, C_最大値.登録件数);
            //    MessageBox.Show(msg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //    dgv顧客リスト.Focus();
            //    return false;
            //}

            //未入力
			if ((dgv顧客リスト.RowCount == 1) && (最終行or全項目未入力(dgv顧客リスト, 0)))
            {
                MessageBox.Show(Properties.Resources.MSG_W_顧客一覧が入力されていません, this.Text, 
					MessageBoxButtons.OK, MessageBoxIcon.Warning);
                dgv顧客リスト.Focus();
                return false;
            }

            //最大値確定件数チェック
            dr = (D10顧客.D10顧客Row[])d10顧客._D10顧客.Select(Properties.Resources.DGV列名_新規 + " = true or " 
                + Properties.Resources.DGV列名_変更 + " = true or " + Properties.Resources.DGV列名_削除 + " = true");
            if (dr.Length > C_最大値.確定件数)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_編集された行数が_最大数A件_を超えています, 
					(long)C_最大値.CSV取込件数), this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }

			if (IsValidate新規変更削除チェック状態(dgv顧客リスト, this.Text) == false)
                return false;

            //未入力
            //bool b新規変更削除にチェック有り = false;
            //for (int iRow = 0; iRow < dgv顧客リスト.RowCount; iRow++)
            //{
            //    if (IsRowEmpty(iRow) == true)
            //        continue;

            //    if ((Boolean)dgv顧客リスト.Rows[iRow].Cells[(int)enm顧客リスト.新規].Value == false &&
            //        (Boolean)dgv顧客リスト.Rows[iRow].Cells[(int)enm顧客リスト.変更].Value == false &&
            //        (Boolean)dgv顧客リスト.Rows[iRow].Cells[(int)enm顧客リスト.削除].Value == false)
            //        continue;

            //    b新規変更削除にチェック有り = true;
            //    break;
            //}

            //チェックがされていなければエラー
            //if (b新規変更削除にチェック有り == false)
            if (dr.Length < 1)
            {
                MessageBox.Show(Properties.Resources.MSG_W_編集された行がありません, this.Text, 
					MessageBoxButtons.OK, MessageBoxIcon.Warning);
                dgv顧客リスト.Focus();
                return false;
            }

            //編集されたセルを全てチェックする
            bool isValid = true;
            for (int iRow = 0; iRow < dgv顧客リスト.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgv顧客リスト, iRow) == true)
                    continue;

                if ((Boolean)dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt新規].Value == false &&
                    (Boolean)dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt変更].Value == false &&
                    (Boolean)dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt削除].Value == false)
                    continue;

				if (!IsValidateDGV顧客リスト(dgv顧客リスト, iRow))
                    isValid = false;

                //dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt販売個数].ErrorText = string.Empty;
                //dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt商品単価].ErrorText = string.Empty;
            }
            //bool isValid = true;
            //for (int iRow = 0; iRow < dr.Length; iRow++)
            //{
            //    if (!IsValidateDGV顧客リスト(dr))
            //        isValid = false;

            //    //dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt販売個数].ErrorText = string.Empty;
            //    //dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt商品単価].ErrorText = string.Empty;
            //}

            if (isValid == false)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_Aの入力内容に誤りがある為_登録を完了できません, 
					Properties.Resources.MSG_TTL_顧客一覧), this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                dgv顧客リスト.Focus();
                return false;
            }

            //重複チェック
            if (IsValidate重複チェック(dgv顧客リスト, this.Text) == false)
                return false;

            return true;
        }

        private void Insert顧客リスト()
        {
            D10顧客.D10顧客Row[] dr = (D10顧客.D10顧客Row[])d10顧客._D10顧客
                .Select(Properties.Resources.DGV列名_新規 + " = true");

            string str顧客IDリスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                dr[iRow].顧客ID = C04システム共通.NULLを空文字に変換(dr[iRow].顧客ID);
                dr[iRow].氏名 = C04システム共通.NULLを空文字に変換(dr[iRow].氏名);
                dr[iRow].氏名カナ = C04システム共通.NULLを空文字に変換(dr[iRow].氏名カナ);
                int int性別 = C02業務共通処理.Get性別No(dr[iRow].性別);
                dr[iRow].郵便番号 = C04システム共通.NULLを空文字に変換(dr[iRow].郵便番号);
                dr[iRow].住所 = C04システム共通.NULLを空文字に変換(dr[iRow].住所);
                dr[iRow].TEL = C04システム共通.NULLを空文字に変換(dr[iRow].TEL);
                dr[iRow].メールアドレス = C04システム共通.NULLを空文字に変換(dr[iRow].メールアドレス);
                int intメルマガ許諾 = C02業務共通処理.Getメルマガ許諾No(dr[iRow].メルマガ許諾
                    , dr[iRow].メルマガ許諾名);
                dr[iRow].備考 = C04システム共通.NULLを空文字に変換(dr[iRow].備考);

                d10顧客2ta.Insert(dr[iRow].顧客ID,
                                  dr[iRow].氏名,
                                  dr[iRow].氏名カナ,
                                  int性別,
                                  dr[iRow].生年月日,
                                  dr[iRow].郵便番号,
                                  dr[iRow].住所,
                                  dr[iRow].TEL,
                                  dr[iRow].メールアドレス,
                                  intメルマガ許諾,
                                  dr[iRow].備考,
                                  C02業務共通処理.miログインスタッフNo);

                //Update販売履歴(dr[iRow].顧客ID);

                str顧客IDリスト += dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString() + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_001 
                    + "=" + str顧客IDリスト.Substring(0, str顧客IDリスト.Length - 2));

            //for (int iRow = 0; iRow < dgv顧客リスト.RowCount; iRow++)
            //{
            //    if (dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt新規].Value == null)
            //        continue;

            //    if ((Boolean)dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt新規].Value == false)
            //        continue;

            //    d10顧客2ta.Insert(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString(),
            //                      dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt氏名].Value.ToString(),
            //                      dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt氏名カナ].Value.ToString(),
            //                      Get性別(iRow),
            //                      Byte.Parse(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt年齢].Value.ToString()),
            //                      dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt郵便番号].Value.ToString(),
            //                      dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt住所].Value.ToString(),
            //                      dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.bytTEL].Value.ToString(),
            //                      dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.bytメールアドレス].Value.ToString(),
            //                      dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt備考].Value.ToString());

            //    Update販売履歴(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString());
            //}
        }

        //public void Update販売履歴(string str顧客ID)
        private void Update販売履歴()
        {
            //// H01販売履歴 を更新
            //D10顧客.D10顧客DataTable dt顧客 = new D10顧客.D10顧客DataTable();
            //d10顧客ta.FillBy顧客No取得(dt顧客, str顧客ID);

            //d03販売履歴ta.Update顧客No(dt顧客[0].顧客No, str顧客ID);

            //for (int iRow = 0; iRow < dgv顧客リスト.RowCount; iRow++)
            //{
            //    if (IsRowEmpty(iRow) == true)
            //        continue;

            //    if ((Boolean)dgv顧客リスト.Rows[iRow].Cells[(int)enm顧客リスト.新規].Value == false &&
            //        (Boolean)dgv顧客リスト.Rows[iRow].Cells[(int)enm顧客リスト.変更].Value == false)
            //        continue;

            //    D10顧客.D10顧客DataTable dt顧客 = new D10顧客.D10顧客DataTable();
            //    d10顧客ta.FillBy顧客No取得(dt顧客, dgv顧客リスト.Rows[iRow].Cells[(int)enm顧客リスト.顧客ID].Value.ToString());

            //    d03販売履歴ta.Update顧客No(dt顧客[0].顧客No, dgv顧客リスト.Rows[iRow].Cells[(int)enm顧客リスト.顧客ID].Value.ToString());
            //}

            d03販売履歴ta.Updateリプレース顧客No();
        }


        private void Update顧客リスト()
        {
            D10顧客.D10顧客Row[] dr = (D10顧客.D10顧客Row[])d10顧客._D10顧客
                .Select(Properties.Resources.DGV列名_変更 + " = true");

            string str顧客IDリスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                dr[iRow].顧客ID = C04システム共通.NULLを空文字に変換(dr[iRow].顧客ID);
                dr[iRow].氏名 = C04システム共通.NULLを空文字に変換(dr[iRow].氏名);
                dr[iRow].氏名カナ = C04システム共通.NULLを空文字に変換(dr[iRow].氏名カナ);
                dr[iRow].郵便番号 = C04システム共通.NULLを空文字に変換(dr[iRow].郵便番号);
                dr[iRow].住所 = C04システム共通.NULLを空文字に変換(dr[iRow].住所);
                dr[iRow].TEL = C04システム共通.NULLを空文字に変換(dr[iRow].TEL);
                dr[iRow].メールアドレス = C04システム共通.NULLを空文字に変換(dr[iRow].メールアドレス);
                dr[iRow].備考 = C04システム共通.NULLを空文字に変換(dr[iRow].備考);

                d10顧客2ta.Update(dr[iRow].顧客ID,
                                    dr[iRow].氏名,
                                    dr[iRow].氏名カナ,
                                    C02業務共通処理.Get性別No(dr[iRow].性別),
                                    dr[iRow].生年月日,
                                    dr[iRow].郵便番号,
                                    dr[iRow].住所,
                                    dr[iRow].TEL,
                                    dr[iRow].メールアドレス,
                                    C02業務共通処理.Getメルマガ許諾No(dr[iRow].メルマガ許諾, dr[iRow].メルマガ許諾名),
                                    dr[iRow].備考,
                                    C02業務共通処理.miログインスタッフNo,
                                    dr[iRow].顧客No);
                    
                //Update販売履歴(dr[iRow].顧客ID);

                str顧客IDリスト += dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString() + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_002 
                    + "=" + str顧客IDリスト.Substring(0, str顧客IDリスト.Length - 2));

            //for (int iRow = 0; iRow < dgv顧客リスト.RowCount; iRow++)
            //{
            //    if (dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt変更].Value == null)
            //        continue;

            //    if ((Boolean)dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt変更].Value == false)
            //        continue;

            //    if (dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString() == "")
            //        continue;

            //    d10顧客2ta.Update(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString(),
            //                          dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt氏名].Value.ToString(),
            //                          dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt氏名カナ].Value.ToString(),
            //                          Get性別(iRow),
            //                          Byte.Parse(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt年齢].Value.ToString()),
            //                          dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt郵便番号].Value.ToString(),
            //                          dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt住所].Value.ToString(),
            //                          dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.bytTEL].Value.ToString(),
            //                          dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.bytメールアドレス].Value.ToString(),
            //                          dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt備考].Value.ToString(),
            //                          Byte.Parse(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString()));

            //    Update販売履歴(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString());
            //}
        }

        private void Delete顧客リスト()
        {
            //D10顧客.D10顧客Row[] dr = (D10顧客.D10顧客Row[])d10顧客._D10顧客.Select("削除 = true");

            //for (int iRow = 0; iRow < dr.Length; iRow++)
            //{
            //    d10顧客2ta.Delete(dr[iRow].顧客No);
            //}

            ////先頭１行だけSelectされない、.Netのバグに対応する為、１行目の処理だけ別で行う。
            //if (dgv顧客リスト.Rows[0].Cells[(int)enm顧客リスト.削除].Value != null)
            //    if ((Boolean)dgv顧客リスト.Rows[0].Cells[(int)enm顧客リスト.削除].Value != false)
            //        d10顧客2ta.Delete(int.Parse(dgv顧客リスト.Rows[0].Cells[(int)enm顧客リスト.顧客No].Value.ToString()));

            string str顧客IDリスト = "";
            int i削除行数 = 0;
            for (int iRow = 0; iRow < dgv顧客リスト.RowCount; iRow++)
            {
                if (dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt削除].Value == false)
                    continue;

                if (dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString() == "")
                    continue;

                d10顧客2ta.Delete(int.Parse(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString()));

                str顧客IDリスト += dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString() + ", ";

                i削除行数++;
            }

            if (i削除行数 > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_003 
                    + "=" + str顧客IDリスト.Substring(0, str顧客IDリスト.Length - 2));
        }

        //public void Update販売履歴()
        //{
        //    for (int iRow = 0; iRow < dgv顧客リスト.RowCount; iRow++)
        //    {
        //        if (dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt変更].Value == null)
        //            continue;

        //        if ((Boolean)dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt変更].Value == false)
        //            continue;

        //        if (dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString() == "")
        //            continue;

        //        d10顧客2ta.Update(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客ID].Value.ToString(),
        //                              dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt氏名].Value.ToString(),
        //                              dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt氏名カナ].Value.ToString(),
        //                              Get性別(iRow),
        //                              Byte.Parse(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt年齢].Value.ToString()),
        //                              dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt郵便番号].Value.ToString(),
        //                              dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt住所].Value.ToString(),
        //                              dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.bytTEL].Value.ToString(),
        //                              dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.bytメールアドレス].Value.ToString(),
        //                              dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt備考].Value.ToString(),
        //                              Byte.Parse(dgv顧客リスト.Rows[iRow].Cells[顧客リストCell.byt顧客No].Value.ToString()));
        //    }
        //}

        private void Set表示項目()
        {

#if 顧客分析君2010
            lbl生年月日.Visible = false;
            dtp生年月日.Visible = false;
            btn選択顧客へメール配信.Visible = false;
            btn顧客毎のお勧め商品一覧をCSVファイルに出力する.Visible = false;
#endif

#if 顧客分析君ZERO
            lbl生年月日.Visible = false;
            dtp生年月日.Visible = false;
            btn選択顧客へメール配信.Visible = false;
            btn顧客毎のお勧め商品一覧をCSVファイルに出力する.Visible = false;
            btn顧客詳細.Visible = false;

            txt住所.Width = 120;
            lblTEL.Left = txt住所.Left + txt住所.Width + 10;
            txtTEL.Left = lblTEL.Left + lblTEL.Width + 10;
            lblメールアドレス.Left = txtTEL.Left + txtTEL.Width + 10;
            txtメールアドレス.Width = 120;
            txtメールアドレス.Left = lblメールアドレス.Left + lblメールアドレス.Width + 10;
            grp検索条件_顧客属性.Width = 700;
#endif
        }

        private void Set属性マスタ()
        {
            this.d01性別ta.Fill(this.d01業務共通.D01性別);
            this.d01メルマガ許諾ta.Fill(this.d01業務共通.D01メルマガ許諾);
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ


        private void _202顧客一覧_Load(object sender, EventArgs e)
        {
            try
            {
#if RELEASE
                btn選択顧客へメール配信.Visible = false;
#endif
                Set属性マスタ();

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "_202顧客一覧_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void _202顧客一覧_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "_202顧客一覧_Resize", ex);
            }
        }

        private void dgv顧客リスト_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv顧客リスト.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv顧客リスト.RowHeadersDefaultCellStyle.Font,
                                              dgv顧客リスト.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "dgv顧客リスト_RowPostPaint", ex);
            }

        }



        private void dgv顧客リスト_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                //if (e.RowIndex < 0)
                //    return;

                //if (e.ColumnIndex < 3)
                //    return;

                //if (dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt顧客No].Value == null)
                //    return;

                //if (int.Parse(dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt顧客No].Value.ToString()) < 0)
                //{
                //    // 「変更」列をチェック状態にする
                //    dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt新規].Value = false;
                //    dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt変更].Value = true;
                //    dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt削除].Value = false;
                //}
                //else
                //{
                //    // 「新規」列をチェック状態にする
                //    dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt新規].Value = true;
                //    dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt変更].Value = false;
                //    dgv顧客リスト.Rows[e.RowIndex].Cells[顧客リストCell.byt削除].Value = false;
                //}

                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, 顧客リストCell.byt顧客No,
                    顧客リストCell.byt新規, 顧客リストCell.byt変更, 顧客リストCell.byt削除,
                    ref dgv顧客リスト);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "dgv顧客リスト_CellValueChanged", ex);
            }
        }

        private void dgv顧客リスト_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case 顧客リストCell.byt顧客ID:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell禁止文字(dgv顧客リスト, e.RowIndex, e.ColumnIndex, value))
                                break;

                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv顧客リスト, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv顧客リスト.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 顧客リストCell.byt氏名カナ:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell全角カナ(dgv顧客リスト, e.RowIndex, e.ColumnIndex, value))
                                break;
                        }

                        //必須入力で入力完了したものについてはメッセージを消去
                        dgv顧客リスト.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;

                        break;

                    case 顧客リストCell.byt生年月日:
                        if (value != string.Empty)
                        {
							if (!C11ValidateOnForm.IsValidateCell日付型(dgv顧客リスト, e.RowIndex, e.ColumnIndex, value))
                                break;
                        }

                        //必須入力で入力完了したものについてはメッセージを消去
                        dgv顧客リスト.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;

                        break;

                    case 顧客リストCell.byt郵便番号:
                    case 顧客リストCell.bytTEL:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv顧客リスト, e.RowIndex, e.ColumnIndex, value))
                                break;
                        }

                        //必須入力で入力完了したものについてはメッセージを消去
                        dgv顧客リスト.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;

                        break;

                    case 顧客リストCell.bytメールアドレス:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCellメールアドレス(dgv顧客リスト, e.RowIndex, e.ColumnIndex, value))
                                break;
                        }

                        //必須入力で入力完了したものについてはメッセージを消去
                        dgv顧客リスト.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;

                        break;

                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "dgv顧客リスト_CellValidating", ex);
            }
            finally
            {
                //dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void dgv顧客リスト_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgv顧客リスト.RowCount)
                {
					IsValidateDGV顧客リスト(dgv顧客リスト, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "dgv顧客リスト_RowValidating", ex);
            }
        }

        private void dgv顧客リスト_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                //データソースとの不整合が発生した場合のエラーを無視する
                e.Cancel = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "dgv顧客リスト_DataError", ex);
            }
        }
        
        private void btn商品選択_Click(object sender, EventArgs e)
        {
            try
            {
                _603商品検索 _203商品一覧 = null;
                _203商品一覧 = new _603商品検索();
                C01FormCommon.画面最小サイズに変更(_203商品一覧, false);
                _203商品一覧.mstr選択済み商品No = (string)txt購入済み商品.Tag;

                if (_203商品一覧.ShowDialog() == DialogResult.Cancel)
                    return;

                txt購入済み商品.Tag = _203商品一覧.mstr選択済み商品No;
                txt購入済み商品.Text = _203商品一覧.mstr購入済み商品ID;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn商品選択_Click", ex);
            }
        }

        private void btnクリア_Click(object sender, EventArgs e)
        {
            try
            {
                txt購入済み商品.Tag = null;
                txt購入済み商品.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btnクリア_Click", ex);
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                txt顧客ID.Text = "";
                txt氏名.Text = "";
                txt氏名カナ.Text = "";
                cmb性別.Text = "";
                dtp生年月日.Value = DateTime.Today;
                dtp生年月日.Checked = false;
                txt郵便番号.Text = "";
                txt住所.Text = "";
                txtTEL.Text = "";
                txtメールアドレス.Text = "";

                txt購入済み商品.Tag = null;
                txt購入済み商品.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
                //入力値検証
                if (false == IsValidate検索())
                    return;

                Cursor.Current = Cursors.WaitCursor;

				////dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;
				//d10顧客bs.DataSource = null;

				//検索条件 row = Get検索条件();

				////検索実行
				//d10顧客ta.FillBy検索(d10顧客._D10顧客
				//                    , row.顧客ID
				//                    , row.氏名
				//                    , row.氏名カナ
				//                    , row.性別
				//                    , row.生年月日
				//                    , row.郵便番号
				//                    , row.住所
				//                    , row.TEL
				//                    , row.メールアドレス
				//                    , row.メルマガ許諾
				//                    , row.購入済み商品No[0]
				//                    , row.購入済み商品No[1]
				//                    , row.購入済み商品No[2]);

				int iCnt = 0;
				検索実行(ref iCnt);

                //見つからない場合はメッセージ表示
				//if (d10顧客._D10顧客.Rows.Count == 0)
				if (iCnt == 0)
				{
					MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした, this.Text, 
						MessageBoxButtons.OK, MessageBoxIcon.Warning);
				}
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn検索_Click", ex);
            }
            finally
            {
                d10顧客bs.DataSource = d10顧客._D10顧客;
				lbl件数.Text = "検索結果：" + d10顧客._D10顧客.Count.ToString() + " 件";
				//dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                Cursor.Current = Cursors.Arrow;
            }
        }

		
		private void btnCSVファイル読込_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                取込処理内部クラス 取込処理 = new 取込処理内部クラス();
                D10顧客.D10顧客DataTable dt = new D10顧客.D10顧客DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
					MessageBox.Show(errmsg, Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, 
						(long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                //dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;
                d10顧客bs.DataSource = null;

                // バインドされているDataTabelに追加。
                d10顧客._D10顧客.Merge(dt);

            }
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_202顧客一覧", "btnCSVファイル読込_Click", ex);
            }
            finally
            {
                d10顧客bs.DataSource = d10顧客._D10顧客;
                //dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, 
					MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました, this.Text, 
					MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }

        private void btn選択行の削除を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                //dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;

                foreach (DataGridViewRow row in dgv顧客リスト.SelectedRows)
                {
                    if (IsValidate未入力行(row))
                        continue;

                    row.Cells[顧客リストCell.byt新規].Value = false;
                    row.Cells[顧客リストCell.byt変更].Value = false;
                    row.Cells[顧客リストCell.byt削除].Value = true;

                    //row.Cells[(int)enm顧客リスト.バグ対応].Value = "仮";
                    //D10顧客.D10顧客Row[] dr = (D10顧客.D10顧客Row[])d10顧客._D10顧客.Select("顧客No = " + row.Cells[(int)enm顧客リスト.顧客No].Value);
                    //dr[0].新規 = false;
                    //dr[0].変更 = false;
                    //dr[0].削除 = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn選択行の削除を全てチェック_Click", ex);
            }
            finally
            {
                //dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                //dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;

                foreach (DataGridViewRow row in dgv顧客リスト.SelectedRows)
                {
                    row.Cells[顧客リストCell.byt新規].Value = false;
                    row.Cells[顧客リストCell.byt変更].Value = false;
                    row.Cells[顧客リストCell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                //dgv顧客リスト.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                d10顧客._D10顧客.Clear();
				lbl件数.Text = "";
			}
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn検索結果をクリア_Click", ex);
            }
        }
        //private void btn全てクリア_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_INF_006
        //            , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
        //            return;

        //        d10顧客._D10顧客.Clear();
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_202顧客一覧", "btn全てクリア_Click", ex);
        //    }
        //}


        private void btn選択行をCSVファイルに出力_Click(object sender, EventArgs e)
        {
            try
            {
                //行が選択されていない場合はメッセージを表示
                if (dgv顧客リスト.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073, this.Text, MessageBoxButtons.OK,
                        MessageBoxIcon.Warning);
                    return;
                }

                //ファイル参照ダイアログを表示する
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                //グリッドの内容をCSV形式で出力する
				C06CSV.CreateCSVファイル(dgv顧客リスト, sfd.FileName, true, 4, true, "");

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, 
					MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn選択行をCSVファイルに出力_Click", ex);
            }
        }

        private void btn顧客詳細_Click(object sender, EventArgs e)
        {
            try
            {
                if (C02業務共通処理.チェック閲覧権限(this.Text, C_画面名.顧客詳細) == false)
                    return;

                if (dgv顧客リスト.SelectedCells.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_セルが選択されていません, this.Text, MessageBoxButtons.OK, 
                        MessageBoxIcon.Warning);
                    return;
                }

				if (最終行or全項目未入力(dgv顧客リスト, dgv顧客リスト.SelectedCells[0].RowIndex) == true)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_行が選択されていません, Text, MessageBoxButtons.OK, 
                        MessageBoxIcon.Warning);
                    return;
                }

                if (int.Parse(dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex].Cells[
                    顧客リストCell.byt顧客No].Value.ToString()) < 1)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_確定が済んでいない行では_詳細画面を表示することはできません, Text, 
						MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                _405顧客詳細 _顧客詳細 = null;
                _顧客詳細 = new _405顧客詳細();
                _顧客詳細.mint顧客No = int.Parse(dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt顧客No].Value.ToString());
                _顧客詳細.mstr顧客ID = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt顧客ID].Value.ToString();
                _顧客詳細.mstr氏名 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt氏名].Value.ToString();
                _顧客詳細.mstr氏名カナ = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt氏名カナ].Value.ToString();
                _顧客詳細.mstr生年月日 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt生年月日].Value.ToString();
                _顧客詳細.mstr郵便番号 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt郵便番号].Value.ToString();
                _顧客詳細.mstr住所 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt住所].Value.ToString();
                _顧客詳細.mstrTEL = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.bytTEL].Value.ToString();
                _顧客詳細.mstrメールアドレス = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.bytメールアドレス].Value.ToString();

                _顧客詳細.mstr性別 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex].Cells[顧客リストCell.byt性別].Value.ToString();
                //_顧客詳細.mstrメルマガ許諾 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex].Cells[顧客リストCell.bytメルマガ許諾].Value.ToString();
				_顧客詳細.mstrメルマガ許諾 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex].Cells[顧客リストCell.bytメルマガ許諾].FormattedValue.ToString();
				
                _顧客詳細.mstr備考 = dgv顧客リスト.Rows[dgv顧客リスト.SelectedCells[0].RowIndex]
                    .Cells[顧客リストCell.byt備考].Value.ToString();
                C01FormCommon.画面最小サイズに変更(_顧客詳細, true);
                _顧客詳細.ShowDialog();

				if (_顧客詳細.mbyt確定実行済み == 1)
				{
					int iCnt = 0;
					検索実行(ref iCnt);

					d10顧客bs.DataSource = d10顧客._D10顧客;
				}
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn顧客詳細_Click", ex);
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                //入力値検証
                Cursor.Current = Cursors.WaitCursor;
                if (false == IsValidate())
                { 
                    return;
                }

                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Cursor.Current = Cursors.WaitCursor;

                Delete顧客リスト();
                Insert顧客リスト();
                Update顧客リスト();

                Update販売履歴();

                //C02業務共通処理.未登録顧客の顧客Noを0にする();
				C02業務共通処理.未登録顧客の顧客Noを0にする();

                d10顧客._D10顧客.Clear();

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, 
					MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btnキャンセル_Click", ex);
            }
        }



        private void btn選択顧客へメール配信_Click(object sender, EventArgs e)
        {
            try
            {
                _205メール配信 _205メール配信 = null;
                _205メール配信 = new _205メール配信();
                C01FormCommon.画面最小サイズに変更(_205メール配信, false);
                //C02業務共通処理.メール宛先抽出(dgv顧客リスト, 顧客リストCell.byt顧客No, 顧客リストCell.byt顧客ID, 顧客リストCell.byt氏名, 顧客リストCell.bytメールアドレス, ref _205メール配信.mdt宛先);
                _205メール配信.ShowDialog();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_202顧客一覧", "btnメール配信_Click", ex);
            }
        }


        #endregion


    }
}
